/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclarationImpl;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtDestructuringDeclaration
extends KtDeclarationImpl
implements KtValVarKeywordOwner {
    public KtDestructuringDeclaration(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtDestructuringDeclaration", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtDestructuringDeclaration", "accept"));
        }
        return visitor2.visitDestructuringDeclaration(this, data2);
    }

    @NotNull
    public List<KtDestructuringDeclarationEntry> getEntries() {
        List<KtDestructuringDeclarationEntry> list2 = this.findChildrenByType(KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtDestructuringDeclaration", "getEntries"));
        }
        return list2;
    }

    @Nullable
    public KtExpression getInitializer() {
        ASTNode eqNode = this.getNode().findChildByType(KtTokens.EQ);
        if (eqNode == null) {
            return null;
        }
        return PsiTreeUtil.getNextSiblingOfType(eqNode.getPsi(), KtExpression.class);
    }

    public boolean isVar() {
        return this.getNode().findChildByType(KtTokens.VAR_KEYWORD) != null;
    }

    @Override
    @Nullable
    public PsiElement getValOrVarKeyword() {
        return this.findChildByType(TokenSet.create(KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD));
    }

    @Nullable
    public PsiElement getRPar() {
        return this.findChildByType(KtTokens.RPAR);
    }

    @Nullable
    public PsiElement getLPar() {
        return this.findChildByType(KtTokens.LPAR);
    }
}

