/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.internal.work.AsyncWorkCompletion;
import org.gradle.internal.work.AsyncWorkTracker;

public class DefaultAsyncWorkTracker
implements AsyncWorkTracker {
    private final ListMultimap<BuildOperationExecutor.Operation, AsyncWorkCompletion> items = ArrayListMultimap.create();
    private final Set<BuildOperationExecutor.Operation> waiting = Sets.newHashSet();
    private final ReentrantLock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWork(BuildOperationExecutor.Operation operation, AsyncWorkCompletion workCompletion) {
        this.lock.lock();
        try {
            if (this.waiting.contains(operation)) {
                throw new IllegalStateException("Another thread is currently waiting on the completion of work for the provided operation");
            }
            this.items.put((Object)operation, (Object)workCompletion);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion(BuildOperationExecutor.Operation operation) {
        ImmutableList workItems;
        ArrayList failures = Lists.newArrayList();
        this.lock.lock();
        try {
            workItems = ImmutableList.copyOf((Collection)this.items.get((Object)operation));
            this.items.removeAll((Object)operation);
            this.startWaiting(operation);
        }
        finally {
            this.lock.unlock();
        }
        try {
            for (AsyncWorkCompletion item : workItems) {
                try {
                    item.waitForCompletion();
                }
                catch (Throwable t) {
                    failures.add(t);
                }
            }
            if (failures.size() > 0) {
                throw new DefaultMultiCauseException("There were failures while executing asynchronous work:", (Iterable)failures);
            }
        }
        finally {
            this.stopWaiting(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWaiting(BuildOperationExecutor.Operation operation) {
        this.lock.lock();
        try {
            this.waiting.add(operation);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWaiting(BuildOperationExecutor.Operation operation) {
        this.lock.lock();
        try {
            this.waiting.remove(operation);
        }
        finally {
            this.lock.unlock();
        }
    }
}

