/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CheckUtil {
    private CheckUtil() {
    }

    public static void checkWritable(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/CheckUtil", "checkWritable"));
        }
        if (!element.isWritable()) {
            if (element instanceof PsiDirectory) {
                String url = ((PsiDirectory)element).getVirtualFile().getPresentableUrl();
                throw new IncorrectOperationException(PsiBundle.message("cannot.modify.a.read.only.directory", url));
            }
            PsiFile file2 = element.getContainingFile();
            if (file2 == null) {
                throw new IncorrectOperationException();
            }
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile == null) {
                throw new IncorrectOperationException();
            }
            throw new IncorrectOperationException(PsiBundle.message("cannot.modify.a.read.only.file", virtualFile.getPresentableUrl()));
        }
    }

    public static void checkDelete(@NotNull VirtualFile file2) throws IncorrectOperationException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/CheckUtil", "checkDelete"));
        }
        VfsUtilCore.visitChildrenRecursively(file2, new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @Override
            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/CheckUtil$1", "visitFile"));
                }
                if (FileTypeRegistry.getInstance().isFileIgnored(file2)) {
                    return false;
                }
                if (!file2.isWritable()) {
                    throw new IncorrectOperationException(PsiBundle.message("cannot.delete.a.read.only.file", file2.getPresentableUrl()));
                }
                return true;
            }
        });
    }
}

