-- EFL LuaJIT bindings: efl_canvas_text_cursor.eo (class Efl.Canvas.Text.Cursor)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.efl_canvas_text_cursor_class_get()
    eo.class_register("Efl_Canvas_Text_Cursor", {"Eo_Base"}, nil, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *efl_canvas_text_cursor_class_get(void);
    void efl_canvas_text_cursor_text_object_set(const Efl_Canvas_Object * tb);
    const Efl_Canvas_Object *efl_canvas_text_cursor_text_object_get(void);
    void efl_canvas_text_cursor_position_set(int position);
    int efl_canvas_text_cursor_position_get(void);
    Eina_Bool efl_canvas_text_cursor_geometry_get(Efl_Canvas_Text_Cursor_Type ctype, Evas_Coord *cx, Evas_Coord *cy, Evas_Coord *cw, Evas_Coord *ch, Evas_Coord *cx2, Evas_Coord *cy2, Evas_Coord *cw2, Evas_Coord *ch2);
    Eina_Unicode efl_canvas_text_cursor_content_get(void);
    Efl_Canvas_Text_Annotation *efl_canvas_text_cursor_object_item_annotation_get(void);
    void efl_canvas_text_cursor_copy(const Efl_Canvas_Text_Cursor * src);
    int efl_canvas_text_cursor_text_insert(const char * text);
    void efl_canvas_text_cursor_char_prev(void);
    void efl_canvas_text_cursor_char_next(void);
    void efl_canvas_text_cursor_char_delete(void);
    void efl_canvas_text_cursor_paragraph_first(void);
    void efl_canvas_text_cursor_paragraph_last(void);
    void efl_canvas_text_cursor_paragraph_next(void);
    void efl_canvas_text_cursor_paragraph_prev(void);
    void efl_canvas_text_cursor_paragraph_char_first(void);
    void efl_canvas_text_cursor_paragraph_char_last(void);
    void efl_canvas_text_cursor_word_start(void);
    void efl_canvas_text_cursor_word_end(void);
    void efl_canvas_text_cursor_line_char_first(void);
    void efl_canvas_text_cursor_line_char_last(void);
    void efl_canvas_text_cursor_line_jump_by(int by);
    int efl_canvas_text_cursor_compare(const Efl_Canvas_Text_Cursor * cur);
    Eina_Bool efl_canvas_text_cursor_equal(const Efl_Canvas_Text_Cursor * cur);
    void efl_canvas_text_cursor_coord_set(Evas_Coord x, Evas_Coord y);
    Efl_Canvas_Text_Annotation *efl_canvas_text_cursor_object_item_insert(const char * format);
    extern const Eo_Event_Description _EFL_CANVAS_TEXT_CURSOR_EVENT_CHANGED;
]]

local __M = util.get_namespace(M, { "canvas", "text" })
__body = {
    __eo_ctor = function(self, text_object_tb, __func)
        self:text_object_set(text_object_tb)
        if __func then __func() end
    end,

    text_object_set = function(self, tb)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_text_object_set(tb)
        eo.__do_end()
    end,

    text_object_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_canvas_text_cursor_text_object_get()
        eo.__do_end()
        return v
    end,

    position_set = function(self, position)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_position_set(position)
        eo.__do_end()
    end,

    position_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_canvas_text_cursor_position_get()
        eo.__do_end()
        return tonumber(v)
    end,

    geometry_get = function(self, ctype)
        eo.__do_start(self, __class)
        local cx = ffi.new("Evas_Coord[1]")
        local cy = ffi.new("Evas_Coord[1]")
        local cw = ffi.new("Evas_Coord[1]")
        local ch = ffi.new("Evas_Coord[1]")
        local cx2 = ffi.new("Evas_Coord[1]")
        local cy2 = ffi.new("Evas_Coord[1]")
        local cw2 = ffi.new("Evas_Coord[1]")
        local ch2 = ffi.new("Evas_Coord[1]")
        local v = __lib.efl_canvas_text_cursor_geometry_get(ctype, cx, cy, cw, ch, cx2, cy2, cw2, ch2)
        eo.__do_end()
        return cx[0], cy[0], cw[0], ch[0], cx2[0], cy2[0], cw2[0], ch2[0]
    end,

    content_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_canvas_text_cursor_content_get()
        eo.__do_end()
        return v
    end,

    object_item_annotation_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_canvas_text_cursor_object_item_annotation_get()
        eo.__do_end()
        return v
    end,

    copy = function(self, src)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_copy(src)
        eo.__do_end()
    end,

    text_insert = function(self, text)
        eo.__do_start(self, __class)
        local v = __lib.efl_canvas_text_cursor_text_insert(text)
        eo.__do_end()
        return tonumber(v)
    end,

    char_prev = function(self)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_char_prev()
        eo.__do_end()
    end,

    char_next = function(self)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_char_next()
        eo.__do_end()
    end,

    char_delete = function(self)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_char_delete()
        eo.__do_end()
    end,

    paragraph_first = function(self)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_paragraph_first()
        eo.__do_end()
    end,

    paragraph_last = function(self)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_paragraph_last()
        eo.__do_end()
    end,

    paragraph_next = function(self)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_paragraph_next()
        eo.__do_end()
    end,

    paragraph_prev = function(self)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_paragraph_prev()
        eo.__do_end()
    end,

    paragraph_char_first = function(self)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_paragraph_char_first()
        eo.__do_end()
    end,

    paragraph_char_last = function(self)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_paragraph_char_last()
        eo.__do_end()
    end,

    word_start = function(self)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_word_start()
        eo.__do_end()
    end,

    word_end = function(self)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_word_end()
        eo.__do_end()
    end,

    line_char_first = function(self)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_line_char_first()
        eo.__do_end()
    end,

    line_char_last = function(self)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_line_char_last()
        eo.__do_end()
    end,

    line_jump_by = function(self, by)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_line_jump_by(by)
        eo.__do_end()
    end,

    compare = function(self, cur)
        eo.__do_start(self, __class)
        local v = __lib.efl_canvas_text_cursor_compare(cur)
        eo.__do_end()
        return tonumber(v)
    end,

    equal = function(self, cur)
        eo.__do_start(self, __class)
        local v = __lib.efl_canvas_text_cursor_equal(cur)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    coord_set = function(self, x, y)
        eo.__do_start(self, __class)
        __lib.efl_canvas_text_cursor_coord_set(x, y)
        eo.__do_end()
    end,

    object_item_insert = function(self, format)
        eo.__do_start(self, __class)
        local v = __lib.efl_canvas_text_cursor_object_item_insert(format)
        eo.__do_end()
        return v
    end,

    __events = {
        ["changed"] = __lib._EFL_CANVAS_TEXT_CURSOR_EVENT_CHANGED
    },

    __properties = {
        ["geometry"] = { 1, 0, 8, 0, true, false },
        ["position"] = { 0, 0, 1, 1, true, true },
        ["object_item_annotation"] = { 0, 0, 1, 0, true, false },
        ["text_object"] = { 0, 0, 1, 1, true, true },
        ["content"] = { 0, 0, 1, 0, true, false }
    }
}

__M.Cursor = function(parent, ...)
    return eo.__ctor_common(__class, parent, eo.class_get("Efl_Canvas_Text_Cursor").__eo_ctor,
                            1, ...)
end

return M
