/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import com.sun.security.auth.callback.TextCallbackHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.net.www.protocol.http.spnego.NegotiateCallbackHandler;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.GSSCredentialImpl;
import sun.security.jgss.GSSNameImpl;
import sun.security.jgss.HttpCaller;
import sun.security.jgss.LoginConfigImpl;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spnego.SpNegoCredElement;

public class GSSUtil {
    public static final Oid GSS_KRB5_MECH_OID = GSSUtil.createOid("1.2.840.113554.1.2.2");
    public static final Oid GSS_KRB5_MECH_OID2 = GSSUtil.createOid("1.3.5.1.5.2");
    public static final Oid GSS_KRB5_MECH_OID_MS = GSSUtil.createOid("1.2.840.48018.1.2.2");
    public static final Oid GSS_SPNEGO_MECH_OID = GSSUtil.createOid("1.3.6.1.5.5.2");
    public static final Oid NT_GSS_KRB5_PRINCIPAL = GSSUtil.createOid("1.2.840.113554.1.2.2.1");
    private static final String DEFAULT_HANDLER = "auth.login.defaultCallbackHandler";
    static final boolean DEBUG = AccessController.doPrivileged(new GetBooleanAction("sun.security.jgss.debug"));

    static void debug(String message) {
        if (DEBUG) {
            assert (message != null);
            System.out.println(message);
        }
    }

    public static Oid createOid(String oidStr) {
        try {
            return new Oid(oidStr);
        }
        catch (GSSException e) {
            GSSUtil.debug("Ignored invalid OID: " + oidStr);
            return null;
        }
    }

    public static boolean isSpNegoMech(Oid oid) {
        return GSS_SPNEGO_MECH_OID.equals(oid);
    }

    public static boolean isKerberosMech(Oid oid) {
        return GSS_KRB5_MECH_OID.equals(oid) || GSS_KRB5_MECH_OID2.equals(oid) || GSS_KRB5_MECH_OID_MS.equals(oid);
    }

    public static String getMechStr(Oid oid) {
        if (GSSUtil.isSpNegoMech(oid)) {
            return "SPNEGO";
        }
        if (GSSUtil.isKerberosMech(oid)) {
            return "Kerberos V5";
        }
        return oid.toString();
    }

    public static Subject getSubject(GSSName name, GSSCredential creds) {
        HashSet<Object> privCredentials = null;
        HashSet pubCredentials = new HashSet();
        Set<GSSCredentialSpi> gssCredentials = null;
        HashSet<KerberosPrincipal> krb5Principals = new HashSet<KerberosPrincipal>();
        if (name instanceof GSSNameImpl) {
            try {
                GSSNameSpi ne = ((GSSNameImpl)name).getElement(GSS_KRB5_MECH_OID);
                String krbName = ne.toString();
                if (ne instanceof Krb5NameElement) {
                    krbName = ((Krb5NameElement)ne).getKrb5PrincipalName().getName();
                }
                KerberosPrincipal krbPrinc = new KerberosPrincipal(krbName);
                krb5Principals.add(krbPrinc);
            }
            catch (GSSException ge) {
                GSSUtil.debug("Skipped name " + name + " due to " + ge);
            }
        }
        if (creds instanceof GSSCredentialImpl) {
            gssCredentials = ((GSSCredentialImpl)creds).getElements();
            privCredentials = new HashSet(gssCredentials.size());
            GSSUtil.populateCredentials(privCredentials, gssCredentials);
        } else {
            privCredentials = new HashSet<Object>();
        }
        GSSUtil.debug("Created Subject with the following");
        GSSUtil.debug("principals=" + krb5Principals);
        GSSUtil.debug("public creds=" + pubCredentials);
        GSSUtil.debug("private creds=" + privCredentials);
        return new Subject(false, krb5Principals, pubCredentials, privCredentials);
    }

    private static void populateCredentials(Set<Object> credentials, Set<?> gssCredentials) {
        for (Object cred : gssCredentials) {
            if (cred instanceof SpNegoCredElement) {
                cred = ((SpNegoCredElement)cred).getInternalCred();
            }
            if (cred instanceof KerberosTicket) {
                if (!cred.getClass().getName().equals("javax.security.auth.kerberos.KerberosTicket")) {
                    KerberosTicket tempTkt = (KerberosTicket)cred;
                    cred = new KerberosTicket(tempTkt.getEncoded(), tempTkt.getClient(), tempTkt.getServer(), tempTkt.getSessionKey().getEncoded(), tempTkt.getSessionKeyType(), tempTkt.getFlags(), tempTkt.getAuthTime(), tempTkt.getStartTime(), tempTkt.getEndTime(), tempTkt.getRenewTill(), tempTkt.getClientAddresses());
                }
                credentials.add(cred);
                continue;
            }
            if (cred instanceof KerberosKey) {
                if (!cred.getClass().getName().equals("javax.security.auth.kerberos.KerberosKey")) {
                    KerberosKey tempKey = (KerberosKey)cred;
                    cred = new KerberosKey(tempKey.getPrincipal(), tempKey.getEncoded(), tempKey.getKeyType(), tempKey.getVersionNumber());
                }
                credentials.add(cred);
                continue;
            }
            GSSUtil.debug("Skipped cred element: " + cred);
        }
    }

    public static Subject login(GSSCaller caller, Oid mech) throws LoginException {
        String defaultHandler;
        Object cb = null;
        cb = caller instanceof HttpCaller ? new NegotiateCallbackHandler(((HttpCaller)caller).info()) : ((defaultHandler = Security.getProperty(DEFAULT_HANDLER)) != null && defaultHandler.length() != 0 ? null : new TextCallbackHandler());
        LoginContext lc = new LoginContext("", null, (CallbackHandler)cb, new LoginConfigImpl(caller, mech));
        lc.login();
        return lc.getSubject();
    }

    public static boolean useSubjectCredsOnly(GSSCaller caller) {
        if (caller instanceof HttpCaller) {
            return false;
        }
        String propValue = AccessController.doPrivileged(new GetPropertyAction("javax.security.auth.useSubjectCredsOnly", "true"));
        return !propValue.equalsIgnoreCase("false");
    }

    public static boolean useMSInterop() {
        String propValue = AccessController.doPrivileged(new GetPropertyAction("sun.security.spnego.msinterop", "true"));
        return !propValue.equalsIgnoreCase("false");
    }

    public static <T extends GSSCredentialSpi> Vector<T> searchSubject(final GSSNameSpi name, final Oid mech, final boolean initiate, final Class<? extends T> credCls) {
        GSSUtil.debug("Search Subject for " + GSSUtil.getMechStr(mech) + (initiate ? " INIT" : " ACCEPT") + " cred (" + (name == null ? "<<DEF>>" : name.toString()) + ", " + credCls.getName() + ")");
        final AccessControlContext acc = AccessController.getContext();
        try {
            Vector creds = (Vector)AccessController.doPrivileged(new PrivilegedExceptionAction<Vector<T>>(){

                @Override
                public Vector<T> run() throws Exception {
                    Subject accSubj = Subject.getSubject(acc);
                    Vector result = null;
                    if (accSubj != null) {
                        result = new Vector();
                        for (GSSCredentialImpl cred : accSubj.getPrivateCredentials(GSSCredentialImpl.class)) {
                            GSSUtil.debug("...Found cred" + cred);
                            try {
                                GSSCredentialSpi ce = cred.getElement(mech, initiate);
                                GSSUtil.debug("......Found element: " + ce);
                                if (ce.getClass().equals(credCls) && (name == null || name.equals((Object)ce.getName()))) {
                                    result.add(credCls.cast(ce));
                                    continue;
                                }
                                GSSUtil.debug("......Discard element");
                            }
                            catch (GSSException ge) {
                                GSSUtil.debug("...Discard cred (" + ge + ")");
                            }
                        }
                    } else {
                        GSSUtil.debug("No Subject");
                    }
                    return result;
                }
            });
            return creds;
        }
        catch (PrivilegedActionException pae) {
            GSSUtil.debug("Unexpected exception when searching Subject:");
            if (DEBUG) {
                pae.printStackTrace();
            }
            return null;
        }
    }
}

