/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.profiler.snaptracer.Positionable;
import org.netbeans.modules.profiler.snaptracer.TracerPackage;
import org.netbeans.modules.profiler.snaptracer.TracerPackageProvider;
import org.netbeans.modules.profiler.snaptracer.impl.IdeSnapshot;
import org.netbeans.modules.profiler.snaptracer.impl.packages.TestPackageProvider;
import org.openide.util.RequestProcessor;

public final class TracerSupportImpl {
    private static TracerSupportImpl INSTANCE;
    private static RequestProcessor PROCESSOR;
    private final Set<TracerPackageProvider> providers = new HashSet<TracerPackageProvider>();

    public static synchronized TracerSupportImpl getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TracerSupportImpl();
            PROCESSOR = new RequestProcessor("Tracer Processor", 5);
        }
        return INSTANCE;
    }

    public synchronized void registerPackageProvider(TracerPackageProvider tracerPackageProvider) {
        this.providers.add(tracerPackageProvider);
    }

    public synchronized void unregisterPackageProvider(TracerPackageProvider tracerPackageProvider) {
        this.providers.remove(tracerPackageProvider);
    }

    public synchronized boolean hasPackages(Object object) {
        for (TracerPackageProvider tracerPackageProvider : this.providers) {
            if (!tracerPackageProvider.getScope().isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public synchronized List<TracerPackage> getPackages(IdeSnapshot ideSnapshot) {
        ArrayList<TracerPackage> arrayList = new ArrayList<TracerPackage>();
        for (TracerPackageProvider tracerPackageProvider : this.providers) {
            arrayList.addAll(Arrays.asList(tracerPackageProvider.getPackages(ideSnapshot)));
        }
        Collections.sort(arrayList, Positionable.COMPARATOR);
        return arrayList;
    }

    public void perform(Runnable runnable) {
        PROCESSOR.post(runnable);
    }

    private TracerSupportImpl() {
        this.registerPackageProvider(new TestPackageProvider());
    }
}

