/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.transport.TransportRequest;

public class StartRecoveryRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private String targetAllocationId;
    private DiscoveryNode sourceNode;
    private DiscoveryNode targetNode;
    private Store.MetadataSnapshot metadataSnapshot;
    private boolean primaryRelocation;

    public StartRecoveryRequest() {
    }

    public StartRecoveryRequest(ShardId shardId, String targetAllocationId, DiscoveryNode sourceNode, DiscoveryNode targetNode, Store.MetadataSnapshot metadataSnapshot, boolean primaryRelocation, long recoveryId) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.targetAllocationId = targetAllocationId;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.metadataSnapshot = metadataSnapshot;
        this.primaryRelocation = primaryRelocation;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    @Nullable
    public String targetAllocationId() {
        return this.targetAllocationId;
    }

    public DiscoveryNode sourceNode() {
        return this.sourceNode;
    }

    public DiscoveryNode targetNode() {
        return this.targetNode;
    }

    public boolean isPrimaryRelocation() {
        return this.primaryRelocation;
    }

    public Store.MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        this.targetAllocationId = in.getVersion().onOrAfter(Version.V_5_4_0_UNRELEASED) ? in.readString() : null;
        this.sourceNode = new DiscoveryNode(in);
        this.targetNode = new DiscoveryNode(in);
        this.metadataSnapshot = new Store.MetadataSnapshot(in);
        this.primaryRelocation = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_5_4_0_UNRELEASED)) {
            out.writeString(this.targetAllocationId);
        }
        this.sourceNode.writeTo(out);
        this.targetNode.writeTo(out);
        this.metadataSnapshot.writeTo(out);
        out.writeBoolean(this.primaryRelocation);
    }
}

