/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.DialogHandler;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.LoadingSavegameInfo;
import net.sf.freecol.client.gui.panel.MiniMap;
import net.sf.freecol.client.gui.panel.Parameters;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.resources.ResourceManager;

public class GUI {
    protected static final Logger logger = Logger.getLogger(GUI.class.getName());
    protected static final String[] levels = new String[]{"low", "normal", "high"};
    public static final int MOVE_UNITS_MODE = 0;
    public static final int VIEW_TERRAIN_MODE = 1;
    protected final FreeColClient freeColClient;
    protected final ImageLibrary imageLibrary;

    public GUI(FreeColClient freeColClient, float scaleFactor) {
        this.freeColClient = freeColClient;
        this.imageLibrary = new ImageLibrary(scaleFactor);
    }

    protected InGameController igc() {
        return this.freeColClient.getInGameController();
    }

    public ImageLibrary getImageLibrary() {
        return this.imageLibrary;
    }

    public boolean isWindowed() {
        return true;
    }

    public void installLookAndFeel(String fontName) throws FreeColException {
    }

    public void quit() throws Exception {
    }

    public void initializeInGame(Tile tile) {
    }

    public void setupMouseListeners() {
    }

    public void displaySplashScreen(InputStream splashStream) {
    }

    public void hideSplashScreen() {
    }

    public void showOpeningVideo(String userMsg) {
    }

    public void startGUI(Dimension desiredWindowSize) {
        logger.info("It seems that the GraphicsEnvironment is headless!");
    }

    public void changeWindowedMode() {
    }

    public void startMapEditorGUI() {
    }

    public void activateGotoPath() {
    }

    public void clearGotoPath() {
    }

    public BufferedImage createMiniMapThumbNail() {
        MiniMap miniMap = new MiniMap(this.freeColClient);
        miniMap.setTileSize(24);
        Game game = this.freeColClient.getGame();
        int width = game.getMap().getWidth() * 24 + 12;
        int height = game.getMap().getHeight() * 24 / 4;
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g1 = image.createGraphics();
        miniMap.paintMap(g1);
        g1.dispose();
        int scaledWidth = Math.min((int)((float)(64 * width) / (float)height), 128);
        BufferedImage scaledImage = new BufferedImage(scaledWidth, 64, 2);
        Graphics2D g2 = scaledImage.createGraphics();
        g2.drawImage(image, 0, 0, scaledWidth, 64, null);
        g2.dispose();
        return scaledImage;
    }

    public void displayChatMessage(Player player, String message, boolean privateChat) {
    }

    public void refresh() {
    }

    public void resetMenuBar() {
    }

    protected void resetMapZoom() {
        ResourceManager.clean();
    }

    public boolean canZoomInMap() {
        return false;
    }

    public boolean canZoomOutMap() {
        return false;
    }

    public void zoomInMap() {
        ResourceManager.clean();
    }

    public void zoomOutMap() {
        ResourceManager.clean();
    }

    public boolean setActiveUnit(Unit unit) {
        return false;
    }

    public void updateMenuBar() {
    }

    public boolean requireFocus(Tile tile) {
        return false;
    }

    public void animateUnitAttack(Unit attacker, Unit defender, Tile attackerTile, Tile defenderTile, boolean success) {
    }

    public void animateUnitMove(Unit unit, Tile srcTile, Tile dstTile) {
    }

    public void enableMapControls(boolean enable) {
    }

    public void updateMapControls() {
    }

    public void zoomInMapControls() {
    }

    public void zoomOutMapControls() {
    }

    public boolean canZoomInMapControls() {
        return false;
    }

    public boolean canZoomOutMapControls() {
        return false;
    }

    public void miniMapToggleViewControls() {
    }

    public void miniMapToggleFogOfWarControls() {
    }

    public boolean confirm(String textKey, String okKey, String cancelKey) {
        return false;
    }

    public boolean confirm(Tile tile, StringTemplate template, String okKey, String cancelKey) {
        return false;
    }

    public boolean confirm(Tile tile, StringTemplate template, Unit unit, String okKey, String cancelKey) {
        return false;
    }

    public boolean confirm(Tile tile, StringTemplate template, Settlement settlement, String okKey, String cancelKey) {
        return false;
    }

    public boolean confirm(Tile tile, StringTemplate template, GoodsType goodsType, String okKey, String cancelKey) {
        return false;
    }

    public boolean confirmAbandonEducation(Unit unit, boolean leaveColony) {
        boolean student;
        if (!unit.isInColony()) {
            return true;
        }
        boolean teacher = unit.getStudent() != null;
        boolean bl = student = leaveColony && unit.getTeacher() != null;
        if (!teacher && !student) {
            return true;
        }
        Building school = (Building)(teacher ? unit.getLocation() : unit.getTeacher().getLocation());
        StringTemplate label = unit.getLabel(Unit.UnitLabelType.NATIONAL);
        StringTemplate template = leaveColony ? StringTemplate.template("abandonEducation.text").addStringTemplate("%unit%", label).addName("%colony%", school.getColony().getName()).addNamed("%building%", school).addStringTemplate("%action%", teacher ? StringTemplate.key("abandonEducation.action.teaching") : StringTemplate.key("abandonEducation.action.studying")) : (teacher ? StringTemplate.template("abandonTeaching.text").addStringTemplate("%unit%", label).addNamed("%building%", school) : null);
        return template == null || this.confirm(unit.getTile(), template, unit, "abandonEducation.yes", "abandonEducation.no");
    }

    public boolean confirmClearTradeRoute(Unit unit) {
        TradeRoute tr = unit.getTradeRoute();
        if (tr == null) {
            return true;
        }
        StringTemplate template = StringTemplate.template("clearTradeRoute.text").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addName("%route%", tr.getName());
        return this.confirm(unit.getTile(), template, unit, "yes", "no");
    }

    public List<String> confirmDeclaration() {
        return Collections.emptyList();
    }

    public int confirmEuropeanTribute(Unit attacker, Colony colony, NationSummary ns) {
        Player player = attacker.getOwner();
        Player other = colony.getOwner();
        int strength = player.calculateStrength(false);
        int otherStrength = ns.getMilitaryStrength();
        int mil = otherStrength <= 1 || otherStrength * 5 < strength ? 0 : (strength == 0 || strength * 5 < otherStrength ? 2 : 1);
        int gold = ns.getGold();
        if (gold == 0) {
            StringTemplate t = StringTemplate.template("confirmTribute.broke").addStringTemplate("%nation%", other.getNationLabel());
            this.showInformationMessage(t);
            return -1;
        }
        int fin = gold <= 100 ? 0 : (gold <= 1000 ? 1 : 2);
        StringTemplate t = StringTemplate.template("confirmTribute.european").addStringTemplate("%nation%", other.getNationLabel()).addStringTemplate("%danger%", StringTemplate.template("danger." + levels[mil])).addStringTemplate("%finance%", StringTemplate.template("finance." + levels[fin]));
        return this.showSelectTributeAmountDialog(t, gold);
    }

    public boolean confirmHostileAction(Unit attacker, Tile target) {
        String messageId;
        Player enemy;
        if (attacker.hasAbility("model.ability.piracy")) {
            return true;
        }
        if (target.hasSettlement()) {
            enemy = target.getSettlement().getOwner();
        } else if (target == attacker.getTile()) {
            enemy = target.getOwner();
            if (enemy == null) {
                return true;
            }
        } else {
            Unit defender = target.getDefendingUnit(attacker);
            if (defender == null) {
                logger.warning("Attacking, but no defender - will try!");
                return true;
            }
            if (defender.hasAbility("model.ability.piracy")) {
                return true;
            }
            enemy = defender.getOwner();
        }
        switch (attacker.getOwner().getStance(enemy)) {
            case WAR: {
                logger.finest("Player at war, no confirmation needed");
                return true;
            }
            case CEASE_FIRE: {
                messageId = "confirmHostile.ceaseFire";
                break;
            }
            case ALLIANCE: {
                messageId = "confirmHostile.alliance";
                break;
            }
            default: {
                messageId = "confirmHostile.peace";
            }
        }
        return this.confirm(attacker.getTile(), StringTemplate.template(messageId).addStringTemplate("%nation%", enemy.getNationLabel()), attacker, "confirmHostile.yes", "cancel");
    }

    public boolean confirmLeaveColony(Unit unit) {
        Colony colony = unit.getColony();
        StringTemplate message = colony.getReducePopulationMessage();
        if (message != null) {
            this.showInformationMessage(message);
            return false;
        }
        return this.confirmAbandonEducation(unit, true);
    }

    public int confirmNativeTribute(Unit attacker, IndianSettlement is) {
        Player player = attacker.getOwner();
        Player other = is.getOwner();
        int strength = player.calculateStrength(false);
        String messageId = other.getNumberOfSettlements() >= strength ? "confirmTribute.unwise" : (other.getStance(player) == Stance.CEASE_FIRE ? "confirmTribute.warLikely" : (is.getAlarm(player).getLevel() == Tension.Level.HAPPY ? "confirmTribute.happy" : "confirmTribute.normal"));
        return this.confirm(is.getTile(), StringTemplate.template(messageId).addName("%settlement%", is.getName()).addStringTemplate("%nation%", other.getNationLabel()), attacker, "confirmTribute.yes", "confirmTribute.no") ? 1 : -1;
    }

    public boolean confirmPreCombat(Unit attacker, Tile tile) {
        if (this.freeColClient.getClientOptions().getBoolean("model.option.guiShowPreCombat")) {
            Settlement settlement = tile.getSettlement();
            Settlement defender = settlement != null ? settlement : tile.getDefendingUnit(attacker);
            return this.showPreCombatDialog(attacker, defender, tile);
        }
        return true;
    }

    public boolean confirmStopGame() {
        return this.confirm("stopCurrentGame.text", "stopCurrentGame.yes", "stopCurrentGame.no");
    }

    public InGameController.ArmedUnitSettlementAction getArmedUnitSettlementChoice(Settlement settlement) {
        Player player = this.freeColClient.getMyPlayer();
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<InGameController.ArmedUnitSettlementAction>(Messages.message("armedUnitSettlement.tribute"), InGameController.ArmedUnitSettlementAction.SETTLEMENT_TRIBUTE));
        choices.add(new ChoiceItem<InGameController.ArmedUnitSettlementAction>(Messages.message("armedUnitSettlement.attack"), InGameController.ArmedUnitSettlementAction.SETTLEMENT_ATTACK));
        return (InGameController.ArmedUnitSettlementAction)((Object)this.getChoice(settlement.getTile(), (Object)settlement.getAlarmLevelLabel(player), settlement, "cancel", choices));
    }

    public InGameController.BoycottAction getBoycottChoice(Goods goods, Europe europe) {
        int arrears = europe.getOwner().getArrears(goods.getType());
        StringTemplate template = StringTemplate.template("boycottedGoods.text").addNamed("%goods%", goods).addNamed("%europe%", europe).addAmount("%amount%", arrears);
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<InGameController.BoycottAction>(Messages.message("payArrears"), InGameController.BoycottAction.PAY_ARREARS));
        choices.add(new ChoiceItem<InGameController.BoycottAction>(Messages.message("boycottedGoods.dumpGoods"), InGameController.BoycottAction.DUMP_CARGO));
        return (InGameController.BoycottAction)((Object)this.getChoice(null, (Object)template, goods.getType(), "cancel", choices));
    }

    public InGameController.BuyAction getBuyChoice(Unit unit, Settlement settlement, Goods goods, int gold, boolean canBuy) {
        StringTemplate template = StringTemplate.template("buy.text").addStringTemplate("%nation%", settlement.getOwner().getNationLabel()).addStringTemplate("%goods%", goods.getLabel(true)).addAmount("%gold%", gold);
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<InGameController.BuyAction>(Messages.message("buy.takeOffer"), InGameController.BuyAction.BUY, canBuy));
        choices.add(new ChoiceItem<InGameController.BuyAction>(Messages.message("buy.moreGold"), InGameController.BuyAction.HAGGLE));
        return (InGameController.BuyAction)((Object)this.getChoice(unit.getTile(), (Object)template, goods.getType(), "cancel", choices));
    }

    public InGameController.ClaimAction getClaimChoice(Tile tile, Player player, int price, Player owner) {
        StringTemplate template;
        ArrayList choices = new ArrayList();
        if (owner.hasContacted(player)) {
            template = StringTemplate.template("indianLand.text").addStringTemplate("%player%", owner.getNationLabel());
            StringTemplate pay = StringTemplate.template("indianLand.pay").addAmount("%amount%", price);
            choices.add(new ChoiceItem<InGameController.ClaimAction>(Messages.message(pay), InGameController.ClaimAction.ACCEPT, player.checkGold(price)));
        } else {
            template = StringTemplate.template("indianLand.unknown");
        }
        choices.add(new ChoiceItem<InGameController.ClaimAction>(Messages.message("indianLand.take"), InGameController.ClaimAction.STEAL));
        return (InGameController.ClaimAction)((Object)this.getChoice(tile, (Object)template, owner.getNation(), "indianLand.cancel", choices));
    }

    public InGameController.TradeAction getIndianSettlementTradeChoice(Settlement settlement, StringTemplate template, boolean canBuy, boolean canSell, boolean canGift) {
        ArrayList choices = new ArrayList();
        if (canBuy) {
            choices.add(new ChoiceItem<InGameController.TradeAction>(Messages.message("tradeProposition.toBuy"), InGameController.TradeAction.BUY, canBuy));
        }
        if (canSell) {
            choices.add(new ChoiceItem<InGameController.TradeAction>(Messages.message("tradeProposition.toSell"), InGameController.TradeAction.SELL, canSell));
        }
        if (canGift) {
            choices.add(new ChoiceItem<InGameController.TradeAction>(Messages.message("tradeProposition.toGift"), InGameController.TradeAction.GIFT, canGift));
        }
        if (choices.isEmpty()) {
            return null;
        }
        return (InGameController.TradeAction)((Object)this.getChoice(settlement.getTile(), (Object)template, settlement, "cancel", choices));
    }

    public InGameController.MissionaryAction getMissionaryChoice(Unit unit, IndianSettlement settlement, boolean canEstablish, boolean canDenounce) {
        StringTemplate template = StringTemplate.label("\n\n").addStringTemplate(settlement.getAlarmLevelLabel(unit.getOwner())).addStringTemplate(StringTemplate.template("missionarySettlement.question").addName("%settlement%", settlement.getName()));
        ArrayList choices = new ArrayList();
        if (canEstablish) {
            choices.add(new ChoiceItem<InGameController.MissionaryAction>(Messages.message("missionarySettlement.establish"), InGameController.MissionaryAction.ESTABLISH_MISSION, canEstablish));
        }
        if (canDenounce) {
            choices.add(new ChoiceItem<InGameController.MissionaryAction>(Messages.message("missionarySettlement.heresy"), InGameController.MissionaryAction.DENOUNCE_HERESY, canDenounce));
        }
        choices.add(new ChoiceItem<InGameController.MissionaryAction>(Messages.message("missionarySettlement.incite"), InGameController.MissionaryAction.INCITE_INDIANS));
        return (InGameController.MissionaryAction)((Object)this.getChoice(unit.getTile(), (Object)template, settlement, "cancel", choices));
    }

    public String getNewColonyName(Player player, Tile tile) {
        String suggested = player.getSettlementName(null);
        String name = this.getInput(tile, StringTemplate.template("nameColony.text"), suggested, "accept", "cancel");
        if (name != null) {
            if (name.isEmpty()) {
                this.showInformationMessage("enterSomeText");
            } else if (player.getSettlementByName(name) != null) {
                this.showInformationMessage(tile, StringTemplate.template("nameColony.notUnique").addName("%name%", name));
            } else {
                return name;
            }
        }
        player.putSettlementName(suggested);
        return null;
    }

    public InGameController.ScoutColonyAction getScoutForeignColonyChoice(Colony colony, Unit unit, boolean neg) {
        StringTemplate template = StringTemplate.template("scoutColony.text").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL)).addName("%colony%", colony.getName());
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<InGameController.ScoutColonyAction>(Messages.message("scoutColony.negotiate"), InGameController.ScoutColonyAction.FOREIGN_COLONY_NEGOTIATE, neg));
        choices.add(new ChoiceItem<InGameController.ScoutColonyAction>(Messages.message("scoutColony.spy"), InGameController.ScoutColonyAction.FOREIGN_COLONY_SPY));
        choices.add(new ChoiceItem<InGameController.ScoutColonyAction>(Messages.message("scoutColony.attack"), InGameController.ScoutColonyAction.FOREIGN_COLONY_ATTACK));
        return (InGameController.ScoutColonyAction)((Object)this.getChoice(unit.getTile(), (Object)template, colony, "cancel", choices));
    }

    public InGameController.ScoutIndianSettlementAction getScoutIndianSettlementChoice(IndianSettlement settlement, String numberString) {
        int present;
        Player player = this.freeColClient.getMyPlayer();
        Player owner = settlement.getOwner();
        StringTemplate template = StringTemplate.label("").addStringTemplate(settlement.getAlarmLevelLabel(player)).addName("\n\n").addStringTemplate(StringTemplate.template("scoutSettlement.greetings").addStringTemplate("%nation%", owner.getNationLabel()).addName("%settlement%", settlement.getName()).addName("%number%", numberString).add("%settlementType%", ((IndianNationType)owner.getNationType()).getSettlementTypeKey(true))).addName(" ");
        if (settlement.getLearnableSkill() != null) {
            template.addStringTemplate(StringTemplate.template("scoutSettlement.skill").addNamed("%skill%", settlement.getLearnableSkill())).addName(" ");
        }
        GoodsType[] wantedGoods = settlement.getWantedGoods();
        for (present = 0; present < wantedGoods.length && wantedGoods[present] != null; ++present) {
        }
        if (present > 0) {
            StringTemplate t = StringTemplate.template("scoutSettlement.trade." + Integer.toString(present));
            for (int i = 0; i < present; ++i) {
                String tradeKey = "%goods" + Integer.toString(i + 1) + "%";
                t.addNamed(tradeKey, wantedGoods[i]);
            }
            template.addStringTemplate(t).addName("\n\n");
        }
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<InGameController.ScoutIndianSettlementAction>(Messages.message("scoutSettlement.speak"), InGameController.ScoutIndianSettlementAction.INDIAN_SETTLEMENT_SPEAK));
        choices.add(new ChoiceItem<InGameController.ScoutIndianSettlementAction>(Messages.message("scoutSettlement.tribute"), InGameController.ScoutIndianSettlementAction.INDIAN_SETTLEMENT_TRIBUTE));
        choices.add(new ChoiceItem<InGameController.ScoutIndianSettlementAction>(Messages.message("scoutSettlement.attack"), InGameController.ScoutIndianSettlementAction.INDIAN_SETTLEMENT_ATTACK));
        return (InGameController.ScoutIndianSettlementAction)((Object)this.getChoice(settlement.getTile(), (Object)template, settlement, "cancel", choices));
    }

    public InGameController.SellAction getSellChoice(Unit unit, Settlement settlement, Goods goods, int gold) {
        StringTemplate goodsTemplate = goods.getLabel(true);
        StringTemplate template = StringTemplate.template("sell.text").addStringTemplate("%nation%", settlement.getOwner().getNationLabel()).addStringTemplate("%goods%", goodsTemplate).addAmount("%gold%", gold);
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<InGameController.SellAction>(Messages.message("sell.takeOffer"), InGameController.SellAction.SELL));
        choices.add(new ChoiceItem<InGameController.SellAction>(Messages.message("sell.moreGold"), InGameController.SellAction.HAGGLE));
        choices.add(new ChoiceItem<InGameController.SellAction>(Messages.message(StringTemplate.template("sell.gift").addStringTemplate("%goods%", goodsTemplate)), InGameController.SellAction.GIFT));
        return (InGameController.SellAction)((Object)this.getChoice(unit.getTile(), (Object)template, goods.getType(), "cancel", choices));
    }

    public <T> T getChoice(Tile tile, Object explain, String cancelKey, List<ChoiceItem<T>> choices) {
        return null;
    }

    public <T> T getChoice(Tile tile, Object explain, Unit unit, String cancelKey, List<ChoiceItem<T>> choices) {
        return null;
    }

    public <T> T getChoice(Tile tile, Object explain, Settlement settlement, String cancelKey, List<ChoiceItem<T>> choices) {
        return null;
    }

    public <T> T getChoice(Tile tile, Object explain, GoodsType goodsType, String cancelKey, List<ChoiceItem<T>> choices) {
        return null;
    }

    public <T> T getChoice(Tile tile, Object explain, Nation nation, String cancelKey, List<ChoiceItem<T>> choices) {
        return null;
    }

    public String getInput(Tile tile, StringTemplate template, String defaultValue, String okKey, String cancelKey) {
        return null;
    }

    public void closeMainPanel() {
    }

    public void closeMenus() {
    }

    public void closeStatusPanel() {
    }

    public boolean containsInGameComponents() {
        return false;
    }

    public LoadingSavegameInfo getLoadingSavegameInfo() {
        return null;
    }

    public boolean isClientOptionsDialogShowing() {
        return false;
    }

    public boolean isMapboardActionsEnabled() {
        return false;
    }

    public boolean isShowingSubPanel() {
        return false;
    }

    public void paintImmediatelyCanvasIn(Rectangle rectangle) {
    }

    public void paintImmediatelyCanvasInItsBounds() {
    }

    public void refreshPlayersTable() {
    }

    public void removeInGameComponents() {
    }

    public void requestFocusForSubPanel() {
    }

    public boolean requestFocusInWindow() {
        return false;
    }

    public void returnToTitle() {
    }

    public void showAboutPanel() {
    }

    public void showCaptureGoodsDialog(Unit unit, List<Goods> gl, DialogHandler<List<Goods>> handler) {
    }

    public void showChatPanel() {
    }

    public void showChooseFoundingFatherDialog(List<FoundingFather> ffs, DialogHandler<FoundingFather> handler) {
    }

    public void showClientOptionsDialog() {
    }

    void showSettlement(Settlement settlement) {
        if (settlement instanceof Colony) {
            if (settlement.getOwner().equals(this.freeColClient.getMyPlayer())) {
                this.showColonyPanel((Colony)settlement, null);
            } else if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
                this.showForeignColony(settlement);
            }
        } else if (settlement instanceof IndianSettlement) {
            this.showIndianSettlementPanel((IndianSettlement)settlement);
        } else {
            throw new IllegalStateException("Bogus settlement");
        }
    }

    protected void showForeignColony(Settlement settlement) {
    }

    public void showColonyPanel(Colony colony, Unit unit) {
    }

    public void showColopediaPanel(String nodeId) {
    }

    public void showCompactLabourReport() {
    }

    public void showDeclarationPanel() {
    }

    public OptionGroup showDifficultyDialog() {
        return null;
    }

    public void showDumpCargoDialog(Unit unit, DialogHandler<List<Goods>> handler) {
    }

    public boolean showEditOptionDialog(Option option) {
        return false;
    }

    public void showEmigrationDialog(Player player, boolean fountainOfYouth, DialogHandler<Integer> handler) {
    }

    public void showEndTurnDialog(List<Unit> units, DialogHandler<Boolean> handler) {
    }

    public void showErrorMessage(StringTemplate template) {
    }

    public void showErrorMessage(String messageId) {
    }

    public void showErrorMessage(String messageID, String message) {
    }

    public void showEuropePanel() {
    }

    public void showEventPanel(String header, String image, String footer) {
    }

    public void showFindSettlementPanel() {
    }

    public OptionGroup showGameOptionsDialog(boolean editable, boolean custom) {
        return null;
    }

    public void showHighScoresPanel(String messageId, List<HighScore> scores) {
    }

    public void showIndianSettlementPanel(IndianSettlement indianSettlement) {
    }

    public void showInformationMessage(String messageId) {
        this.alertSound();
    }

    public void showInformationMessage(StringTemplate template) {
        this.alertSound();
    }

    public final void showInformationMessage(Settlement displayObject, String messageId) {
        this.showInformationMessage(displayObject, StringTemplate.key(messageId));
    }

    public void showInformationMessage(Settlement displayObject, StringTemplate template) {
        this.alertSound();
    }

    public void showInformationMessage(Unit displayObject, StringTemplate template) {
        this.alertSound();
    }

    public final void showInformationMessage(Tile displayObject, String messageId) {
        this.showInformationMessage(displayObject, StringTemplate.key(messageId));
    }

    public void showInformationMessage(Tile displayObject, StringTemplate template) {
        this.alertSound();
    }

    public void showInformationMessage(FreeColObject displayObject, String messageId) {
        this.alertSound();
    }

    public void showInformationMessage(FreeColObject displayObject, StringTemplate template) {
        this.alertSound();
    }

    public File showLoadDialog(File directory) {
        return null;
    }

    public final File showLoadSaveFileDialog() {
        File file = this.showLoadDialog(FreeColDirectories.getSaveDirectory());
        if (file != null && !file.isFile()) {
            this.showErrorMessage("error.noSuchFile");
            file = null;
        }
        return file;
    }

    public boolean showLoadingSavegameDialog(boolean publicServer, boolean singlePlayer) {
        return false;
    }

    public void showLogFilePanel() {
    }

    public void showMainPanel(String userMsg) {
    }

    public OptionGroup showMapGeneratorOptionsDialog(boolean editable) {
        return null;
    }

    public Dimension showMapSizeDialog() {
        return null;
    }

    public void showModelMessages(List<ModelMessage> modelMessages) {
    }

    public void showMonarchDialog(Monarch.MonarchAction action, StringTemplate template, String monarchKey, DialogHandler<Boolean> handler) {
    }

    public void showNamingDialog(StringTemplate template, String defaultName, Unit unit, DialogHandler<String> handler) {
    }

    public void showFirstContactDialog(Player player, Player other, Tile tile, int settlementCount, DialogHandler<Boolean> handler) {
    }

    public DiplomaticTrade showNegotiationDialog(FreeColGameObject our, FreeColGameObject other, DiplomaticTrade agreement, StringTemplate comment) {
        return null;
    }

    public void showNewPanel() {
    }

    public void showNewPanel(Specification specification) {
    }

    public void showSpyColonyPanel(Tile tile, Runnable callback) {
    }

    public Parameters showParametersDialog() {
        return null;
    }

    public boolean showPreCombatDialog(Unit attacker, FreeColGameObject defender, Tile tile) {
        return false;
    }

    public void showReportCargoPanel() {
    }

    public void showReportColonyPanel() {
    }

    public void showReportContinentalCongressPanel() {
    }

    public void showReportEducationPanel() {
    }

    public void showReportExplorationPanel() {
    }

    public void showReportForeignAffairPanel() {
    }

    public void showReportHistoryPanel() {
    }

    public void showReportIndianPanel() {
    }

    public void showReportLabourPanel() {
    }

    public void showReportMilitaryPanel() {
    }

    public void showReportNavalPanel() {
    }

    public void showReportProductionPanel() {
    }

    public void showReportReligiousPanel() {
    }

    public void showReportRequirementsPanel() {
    }

    public void showReportTradePanel() {
    }

    public void showReportTurnPanel(List<ModelMessage> messages) {
    }

    public File showSaveDialog(File directory, String defaultName) {
        return null;
    }

    public Dimension showScaleMapSizeDialog() {
        return null;
    }

    public int showSelectAmountDialog(GoodsType goodsType, int available, int defaultAmount, boolean needToPay) {
        return -1;
    }

    public int showSelectTributeAmountDialog(StringTemplate question, int maximum) {
        return -1;
    }

    public Location showSelectDestinationDialog(Unit unit) {
        return null;
    }

    public void showStartGamePanel(Game game, Player player, boolean singlePlayerMode) {
    }

    public void showStatisticsPanel() {
    }

    public void showStatusPanel(String message) {
    }

    public void showTilePopUpAtSelectedTile() {
    }

    public void showTradeRoutePanel(Unit unit) {
    }

    public void showVictoryDialog(DialogHandler<Boolean> handler) {
    }

    public void updateGameOptions() {
    }

    public void updateMapGeneratorOptions() {
    }

    public void centerActiveUnit() {
    }

    public void changeViewMode(int newViewMode) {
    }

    public Unit getActiveUnit() {
        return null;
    }

    public Tile getFocus() {
        return null;
    }

    public Tile getSelectedTile() {
        return null;
    }

    public int getViewMode() {
        return -1;
    }

    public void setFocus(Tile tileToFocus) {
    }

    public boolean setSelectedTile(Tile newTileToSelect) {
        return true;
    }

    public void toggleViewMode() {
    }

    public void playSound(String sound) {
        this.freeColClient.getSoundController().playSound(sound);
    }

    private void alertSound() {
        if (this.freeColClient.getClientOptions().getBoolean("model.option.audioAlerts")) {
            this.freeColClient.getSoundController().playSound("sound.event.alertSound");
        }
    }

    public String getSoundMixerLabelText() {
        return this.freeColClient.getSoundController().getSoundMixerLabelText();
    }

    public void invokeNowOrLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void invokeNowOrWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                logger.log(Level.WARNING, "Client GUI interaction", ex);
            }
        }
    }
}

