/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.FontFace;
import com.kitfox.svg.Glyph;
import com.kitfox.svg.MissingGlyph;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.SVGParseException;
import com.kitfox.svg.xml.StyleAttribute;
import java.util.HashMap;

public class Font
extends SVGElement {
    public static final String TAG_NAME = "font";
    int horizOriginX = 0;
    int horizOriginY = 0;
    int horizAdvX = -1;
    int vertOriginX = -1;
    int vertOriginY = -1;
    int vertAdvY = -1;
    FontFace fontFace = null;
    MissingGlyph missingGlyph = null;
    final HashMap<String, SVGElement> glyphs = new HashMap();

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public void loaderAddChild(SVGLoaderHelper sVGLoaderHelper, SVGElement sVGElement) throws SVGElementException {
        super.loaderAddChild(sVGLoaderHelper, sVGElement);
        if (sVGElement instanceof Glyph) {
            this.glyphs.put(((Glyph)sVGElement).getUnicode(), sVGElement);
        } else if (sVGElement instanceof MissingGlyph) {
            this.missingGlyph = (MissingGlyph)sVGElement;
        } else if (sVGElement instanceof FontFace) {
            this.fontFace = (FontFace)sVGElement;
        }
    }

    @Override
    public void loaderEndElement(SVGLoaderHelper sVGLoaderHelper) throws SVGParseException {
        super.loaderEndElement(sVGLoaderHelper);
        sVGLoaderHelper.universe.registerFont(this);
    }

    @Override
    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("horiz-origin-x"))) {
            this.horizOriginX = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("horiz-origin-y"))) {
            this.horizOriginY = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("horiz-adv-x"))) {
            this.horizAdvX = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("vert-origin-x"))) {
            this.vertOriginX = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("vert-origin-y"))) {
            this.vertOriginY = styleAttribute.getIntValue();
        }
        if (this.getPres(styleAttribute.setName("vert-adv-y"))) {
            this.vertAdvY = styleAttribute.getIntValue();
        }
    }

    public FontFace getFontFace() {
        return this.fontFace;
    }

    public void setFontFace(FontFace fontFace) {
        this.fontFace = fontFace;
    }

    public MissingGlyph getGlyph(String string) {
        Glyph glyph = (Glyph)this.glyphs.get(string);
        if (glyph == null) {
            return this.missingGlyph;
        }
        return glyph;
    }

    public int getHorizOriginX() {
        return this.horizOriginX;
    }

    public int getHorizOriginY() {
        return this.horizOriginY;
    }

    public int getHorizAdvX() {
        return this.horizAdvX;
    }

    public int getVertOriginX() {
        if (this.vertOriginX != -1) {
            return this.vertOriginX;
        }
        this.vertOriginX = this.getHorizAdvX() / 2;
        return this.vertOriginX;
    }

    public int getVertOriginY() {
        if (this.vertOriginY != -1) {
            return this.vertOriginY;
        }
        this.vertOriginY = this.fontFace.getAscent();
        return this.vertOriginY;
    }

    public int getVertAdvY() {
        if (this.vertAdvY != -1) {
            return this.vertAdvY;
        }
        this.vertAdvY = this.fontFace.getUnitsPerEm();
        return this.vertAdvY;
    }

    @Override
    public boolean updateTime(double d) throws SVGException {
        return false;
    }
}

