/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public class WayPoint
extends WithAttributes
implements Comparable<WayPoint>,
TemplateEngineDataProvider {
    public double time;
    public Color customColoring;
    public boolean drawLine;
    public int dir;
    private final double lat;
    private final double lon;
    private double east = Double.NaN;
    private double north = Double.NaN;

    public WayPoint(WayPoint wayPoint) {
        this.attr.putAll(wayPoint.attr);
        this.lat = wayPoint.lat;
        this.lon = wayPoint.lon;
        this.east = wayPoint.east;
        this.north = wayPoint.north;
        this.time = wayPoint.time;
        this.customColoring = wayPoint.customColoring;
        this.drawLine = wayPoint.drawLine;
        this.dir = wayPoint.dir;
    }

    public WayPoint(LatLon latLon) {
        this.lat = latLon.lat();
        this.lon = latLon.lon();
    }

    public void invalidateEastNorthCache() {
        this.east = Double.NaN;
        this.north = Double.NaN;
    }

    public final LatLon getCoor() {
        return new LatLon(this.lat, this.lon);
    }

    public final EastNorth getEastNorth() {
        if (Double.isNaN(this.east) || Double.isNaN(this.north)) {
            EastNorth eastNorth = Projections.project(new LatLon(this.lat, this.lon));
            this.east = eastNorth.east();
            this.north = eastNorth.north();
        }
        return new EastNorth(this.east, this.north);
    }

    public String toString() {
        return "WayPoint (" + (this.attr.containsKey("name") ? this.get("name") + ", " : "") + this.getCoor() + ", " + this.attr + ')';
    }

    public void setTime(Date date) {
        this.time = (double)date.getTime() / 1000.0;
        this.attr.put("time", DateUtils.fromDate(date));
    }

    public void setTime() {
        this.setTimeFromAttribute();
    }

    public Date setTimeFromAttribute() {
        if (this.attr.containsKey("time")) {
            try {
                Date date = DateUtils.fromString(this.get("time").toString());
                this.time = (double)date.getTime() / 1000.0;
                return date;
            }
            catch (UncheckedParseException uncheckedParseException) {
                Main.warn(uncheckedParseException);
                this.time = 0.0;
            }
        }
        return null;
    }

    @Override
    public int compareTo(WayPoint wayPoint) {
        return Double.compare(this.time, wayPoint.time);
    }

    public Date getTime() {
        return new Date((long)(this.time * 1000.0));
    }

    @Override
    public Object getTemplateValue(String string, boolean bl) {
        if (!bl) {
            return this.get(string);
        }
        return null;
    }

    @Override
    public boolean evaluateCondition(SearchCompiler.Match match) {
        throw new UnsupportedOperationException();
    }

    public List<String> getTemplateKeys() {
        return new ArrayList<String>(this.attr.keySet());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        long l = Double.doubleToLongBits(this.lat);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.lon);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.time);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !super.equals(object) || this.getClass() != object.getClass()) {
            return false;
        }
        WayPoint wayPoint = (WayPoint)object;
        return Double.doubleToLongBits(this.lat) == Double.doubleToLongBits(wayPoint.lat) && Double.doubleToLongBits(this.lon) == Double.doubleToLongBits(wayPoint.lon) && Double.doubleToLongBits(this.time) == Double.doubleToLongBits(wayPoint.time);
    }
}

