/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.emf.BitmapInfo;
import org.freehep.graphicsio.emf.BitmapInfoHeader;
import org.freehep.graphicsio.emf.BlendFunction;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.util.UserProperties;
import org.freehep.util.io.NoCloseOutputStream;

public class AlphaBlend
extends EMFTag
implements EMFConstants {
    public static final int size = 108;
    private Rectangle bounds;
    private int x;
    private int y;
    private int width;
    private int height;
    private BlendFunction dwROP;
    private int xSrc;
    private int ySrc;
    private AffineTransform transform;
    private Color bkg;
    private int usage;
    private BitmapInfo bmi;
    private RenderedImage image;

    AlphaBlend() {
        super(114, 1);
    }

    public AlphaBlend(Rectangle bounds, int x, int y, int width, int height, AffineTransform transform, RenderedImage image, Color bkg) {
        this();
        this.bounds = bounds;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.dwROP = new BlendFunction(0, 0, 255, 1);
        this.xSrc = 0;
        this.ySrc = 0;
        this.transform = transform;
        this.bkg = bkg == null ? new Color(0, 0, 0, 0) : bkg;
        this.usage = 0;
        this.image = image;
        this.bmi = null;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        AlphaBlend tag = new AlphaBlend();
        tag.bounds = emf.readRECTL();
        tag.x = emf.readLONG();
        tag.y = emf.readLONG();
        tag.width = emf.readLONG();
        tag.height = emf.readLONG();
        tag.dwROP = new BlendFunction(emf);
        tag.xSrc = emf.readLONG();
        tag.ySrc = emf.readLONG();
        tag.transform = emf.readXFORM();
        tag.bkg = emf.readCOLORREF();
        tag.usage = emf.readDWORD();
        int bmiOffset = emf.readDWORD();
        int bmiSize = emf.readDWORD();
        int bitmapOffset = emf.readDWORD();
        int bitmapSize = emf.readDWORD();
        int width = emf.readLONG();
        int height = emf.readLONG();
        this.bmi = bmiSize > 0 ? new BitmapInfo(emf) : null;
        int[] bytes = emf.readUnsignedByte(bitmapSize);
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeLONG(this.x);
        emf.writeLONG(this.y);
        emf.writeLONG(this.width);
        emf.writeLONG(this.height);
        this.dwROP.write(emf);
        emf.writeLONG(this.xSrc);
        emf.writeLONG(this.ySrc);
        emf.writeXFORM(this.transform);
        emf.writeCOLORREF(this.bkg);
        emf.writeDWORD(this.usage);
        emf.writeDWORD(108);
        emf.writeDWORD(40);
        emf.writeDWORD(148);
        emf.pushBuffer();
        int encode = 0;
        UserProperties properties = new UserProperties();
        properties.setProperty(RawImageWriteParam.BACKGROUND, this.bkg);
        properties.setProperty(RawImageWriteParam.CODE, "*BGRA");
        properties.setProperty(RawImageWriteParam.PAD, 1);
        ImageGraphics2D.writeImage(this.image, "raw", (Properties)properties, (OutputStream)new NoCloseOutputStream(emf));
        int length = emf.popBuffer();
        emf.writeDWORD(length);
        emf.writeLONG(this.image.getWidth());
        emf.writeLONG(this.image.getHeight());
        BitmapInfoHeader header = new BitmapInfoHeader(this.image.getWidth(), this.image.getHeight(), 32, encode, length, 0, 0, 0, 0);
        this.bmi = new BitmapInfo(header);
        this.bmi.write(emf);
        emf.append();
    }

    public String toString() {
        return super.toString() + "\n" + "  bounds: " + this.bounds + "\n" + "  x, y, w, h: " + this.x + " " + this.y + " " + this.width + " " + this.height + "\n" + "  dwROP: " + this.dwROP + "\n" + "  xSrc, ySrc: " + this.xSrc + " " + this.ySrc + "\n" + "  transform: " + this.transform + "\n" + "  bkg: " + this.bkg + "\n" + "  usage: " + this.usage + "\n" + (this.bmi != null ? this.bmi.toString() : "  bitmap: null");
    }
}

