/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.results.locks.LockCCTNode;
import org.netbeans.lib.profiler.results.locks.MonitorCCTNode;
import org.netbeans.lib.profiler.results.locks.MonitorInfo;
import org.netbeans.lib.profiler.results.locks.ThreadInfo;

class ThreadLockCCTNode
extends LockCCTNode {
    private static final String WAIT_MONITORS_LBL;
    private static final String WAIT_MONITORS_OWNER_LBL;
    private static final String OWNER_MONITORS_LBL;
    private static final String OWNER_MONITORS__WAIT_LBL;
    private final ThreadInfo ti;
    private final List<ThreadInfo.MonitorDetail> waitMonitors;
    private final List<ThreadInfo.MonitorDetail> ownerMonitors;
    private MonitorsCCTNode waitNode;
    private long allTime;
    private long allCount;

    ThreadLockCCTNode(LockCCTNode lockCCTNode, ThreadInfo threadInfo, List<List<ThreadInfo.MonitorDetail>> list) {
        super(lockCCTNode);
        assert (list.size() == 2);
        this.ti = threadInfo;
        this.waitMonitors = list.get(0);
        this.ownerMonitors = list.get(1);
    }

    @Override
    public String getNodeName() {
        return this.ti.getName();
    }

    @Override
    public long getTime() {
        if (this.allTime == 0L) {
            this.summarize();
        }
        return this.allTime;
    }

    @Override
    public long getWaits() {
        if (this.allCount == 0L) {
            this.summarize();
        }
        return this.allCount;
    }

    @Override
    public boolean isThreadLockNode() {
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof ThreadLockCCTNode) {
            return this.ti.equals(((ThreadLockCCTNode)object).ti);
        }
        return false;
    }

    public int hashCode() {
        return this.ti.hashCode();
    }

    private void summarize() {
        this.getChildren();
        if (this.waitNode != null) {
            this.allTime = this.waitNode.getTime();
            this.allCount = this.waitNode.getWaits();
        }
    }

    @Override
    void computeChildren() {
        super.computeChildren();
        if (!this.waitMonitors.isEmpty()) {
            this.waitNode = new MonitorsCCTNode(this, WAIT_MONITORS_LBL, WAIT_MONITORS_OWNER_LBL, this.waitMonitors);
            this.addChild(this.waitNode);
        }
        if (!this.ownerMonitors.isEmpty()) {
            this.addChild(new MonitorsCCTNode(this, OWNER_MONITORS_LBL, OWNER_MONITORS__WAIT_LBL, this.ownerMonitors));
        }
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.locks.Bundle");
        WAIT_MONITORS_LBL = resourceBundle.getString("ThreadLockCCTNode_WaitMonitors");
        WAIT_MONITORS_OWNER_LBL = resourceBundle.getString("ThreadLockCCTNode_WaitMonitorsOwner");
        OWNER_MONITORS_LBL = resourceBundle.getString("ThreadLockCCTNode_OwnerMonitors");
        OWNER_MONITORS__WAIT_LBL = resourceBundle.getString("ThreadLockCCTNode_OwnerMonitorsWait");
    }

    class MonitorDetailsCCTNode
    extends LockCCTNode {
        private final ThreadInfo.MonitorDetail monitorDetail;
        private final String threadNameFormat;

        private MonitorDetailsCCTNode(LockCCTNode lockCCTNode, String string, ThreadInfo.MonitorDetail monitorDetail) {
            super(lockCCTNode);
            this.threadNameFormat = string;
            this.monitorDetail = monitorDetail;
        }

        @Override
        public boolean isMonitorNode() {
            return true;
        }

        @Override
        public String getNodeName() {
            return this.monitorDetail.monitor.getName();
        }

        @Override
        public long getTime() {
            return this.monitorDetail.waitTime;
        }

        @Override
        public long getWaits() {
            return this.monitorDetail.count;
        }

        public int hashCode() {
            return this.monitorDetail.monitor.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof MonitorDetailsCCTNode) {
                MonitorDetailsCCTNode monitorDetailsCCTNode = (MonitorDetailsCCTNode)object;
                return this.monitorDetail.monitor.equals(monitorDetailsCCTNode.monitorDetail.monitor) && this.getParent().equals(monitorDetailsCCTNode.getParent());
            }
            return false;
        }

        @Override
        void computeChildren() {
            super.computeChildren();
            for (MonitorInfo.ThreadDetail threadDetail : this.monitorDetail.cloneThreadDetails()) {
                this.addChild(new MonitorCCTNode.ThreadDetailLockCCTNode(this, this.threadNameFormat, threadDetail));
            }
        }
    }

    class MonitorsCCTNode
    extends LockCCTNode {
        private final List<ThreadInfo.MonitorDetail> monitors;
        private final String name;
        private final String threadNameFormat;
        private long allTime;
        private long allCount;

        MonitorsCCTNode(ThreadLockCCTNode threadLockCCTNode2, String string, String string2, List<ThreadInfo.MonitorDetail> list) {
            super(threadLockCCTNode2);
            this.name = string;
            this.threadNameFormat = string2;
            this.monitors = list;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public long getTime() {
            if (this.allTime == 0L) {
                this.summarize();
            }
            return this.allTime;
        }

        @Override
        public long getWaits() {
            if (this.allCount == 0L) {
                this.summarize();
            }
            return this.allCount;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof MonitorsCCTNode) {
                MonitorsCCTNode monitorsCCTNode = (MonitorsCCTNode)object;
                return this.name.equals(monitorsCCTNode.name) && this.getParent().equals(monitorsCCTNode.getParent());
            }
            return false;
        }

        @Override
        void computeChildren() {
            super.computeChildren();
            for (ThreadInfo.MonitorDetail monitorDetail : this.monitors) {
                this.addChild(new MonitorDetailsCCTNode(this, this.threadNameFormat, monitorDetail));
            }
        }

        private void summarize() {
            for (ThreadInfo.MonitorDetail monitorDetail : this.monitors) {
                this.allTime += monitorDetail.waitTime;
                this.allCount += monitorDetail.count;
            }
        }
    }
}

