/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.wizards.InstallStep;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationPanel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomHandleStep
implements WizardDescriptor.FinishablePanel<WizardDescriptor> {
    private OperationPanel panel;
    private PanelBodyContainer component;
    private OperationWizardModel model = null;
    private WizardDescriptor wd = null;
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static final String HEAD_CUSTOM_INSTALL = "CustomHandleStep_Header_Install_Head";
    private static final String CONTENT_CUSTOM_INSTALL = "CustomHandleStep_Header_Install_Content";
    private static final String HEAD_CUSTOM_UNINSTALL = "CustomHandleStep_Header_Uninstall_Head";
    private static final String CONTENT_CUSTOM_UNINSTALL = "CustomHandleStep_Header_Uninstall_Content";
    private static final String HEAD_CUSTOM_INSTALL_DONE = "CustomHandleStep_Header_InstallDone_Head";
    private static final String CONTENT_CUSTOM_INSTALL_DONE = "CustomHandleStep_Header_InstallDone_Content";
    private static final String HEAD_CUSTOM_UNINSTALL_DONE = "CustomHandleStep_Header_UninstallDone_Head";
    private static final String CONTENT_CUSTOM_UNINSTALL_DONE = "CustomHandleStep_Header_UninstallDone_Content";
    private static final String HEAD_CUSTOM_INSTALL_FAIL = "CustomHandleStep_Header_InstallFail_Head";
    private static final String CONTENT_CUSTOM_INSTALL_FAIL = "CustomHandleStep_Header_InstallFail_Content";
    private static final String HEAD_CUSTOM_UNINSTALL_FAIL = "CustomHandleStep_Header_UninstallFail_Head";
    private static final String CONTENT_CUSTOM_UNINSTALL_FAIL = "CustomHandleStep_Header_UninstallFail_Content";
    private static final String HEAD_CUSTOM_INSTALL_RESTART = "CustomHandleStep_Header_Install_Restart_Head";
    private static final String CONTENT_CUSTOM_INSTALL_RESTART = "CustomHandleStep_Header_Install_Restart_Content";
    private static final String HEAD_CUSTOM_UNINSTALL_RESTART = "CustomHandleStep_Header_Uninstall_Restart_Head";
    private static final String CONTENT_CUSTOM_UNINSTALL_RESTART = "CustomHandleStep_Header_Uninstall_Restart_Content";
    private OperationSupport.Restarter restarter = null;
    private boolean isInstall = false;
    private boolean passed = false;
    private String errorMessage = null;
    private boolean done = false;
    private boolean wasStored = false;

    public CustomHandleStep(OperationWizardModel operationWizardModel) {
        this.model = operationWizardModel;
        this.isInstall = operationWizardModel instanceof InstallUnitWizardModel;
    }

    public boolean isFinishPanel() {
        return !this.model.hasStandardComponents();
    }

    public PanelBodyContainer getComponent() {
        if (this.component == null) {
            this.panel = new OperationPanel(false);
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("run-action".equals(propertyChangeEvent.getPropertyName())) {
                        CustomHandleStep.this.doHandleOperation();
                    }
                }
            });
            this.component = this.isInstall ? new PanelBodyContainer(this.getBundle(HEAD_CUSTOM_INSTALL, new String[0]), this.getBundle(CONTENT_CUSTOM_INSTALL, new String[0]), this.panel) : new PanelBodyContainer(this.getBundle(HEAD_CUSTOM_UNINSTALL, new String[0]), this.getBundle(CONTENT_CUSTOM_UNINSTALL, new String[0]), this.panel);
            this.component.setPreferredSize(OperationWizardModel.PREFFERED_DIMENSION);
        }
        return this.component;
    }

    private void doHandleOperation() {
        this.restarter = null;
        if (this.handleOperation()) {
            if (this.isInstall) {
                if (this.restarter != null) {
                    this.presentInstallNeedsRestart();
                } else {
                    this.presentInstallDone();
                }
            } else if (this.restarter != null) {
                this.presentUninstallNeedsRestart();
            } else {
                this.presentUninstallDone();
            }
        } else if (this.isInstall) {
            this.presentInstallFail(this.errorMessage);
        } else {
            this.presentUninstallFail(this.errorMessage);
        }
        this.done = true;
        this.fireChange();
    }

    private boolean handleOperation() {
        final OperationSupport operationSupport = (OperationSupport)this.model.getCustomHandledContainer().getSupport();
        assert (operationSupport != null);
        this.passed = false;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)(CustomHandleStep.this.isInstall ? CustomHandleStep.this.getBundle("CustomHandleStep_Install_InstallingPlugins", new String[0]) : CustomHandleStep.this.getBundle("CustomHandleStep_Uninstall_UninstallingPlugins", new String[0])));
                    JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
                    JLabel jLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
                    JLabel jLabel2 = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
                    progressHandle.setInitialDelay(0);
                    CustomHandleStep.this.panel.waitAndSetProgressComponents(jLabel, jComponent, jLabel2);
                    CustomHandleStep.this.restarter = operationSupport.doOperation(progressHandle);
                    CustomHandleStep.this.passed = true;
                    CustomHandleStep.this.panel.waitAndSetProgressComponents(jLabel, jComponent, new JLabel(CustomHandleStep.this.getBundle("CustomHandleStep_Done", new String[0])));
                }
                catch (OperationException operationException) {
                    CustomHandleStep.this.log.log(Level.INFO, operationException.getMessage(), operationException);
                    CustomHandleStep.this.passed = false;
                    CustomHandleStep.this.errorMessage = operationException.getLocalizedMessage();
                }
            }
        };
        runnable.run();
        return this.passed;
    }

    private void presentInstallDone() {
        this.component.setHeadAndContent(this.getBundle(HEAD_CUSTOM_INSTALL_DONE, new String[0]), this.getBundle(CONTENT_CUSTOM_INSTALL_DONE, new String[0]));
        this.model.modifyOptionsForContinue(this.wd, this.isFinishPanel());
        this.panel.setBody(this.getBundle("CustomHandleStep_InstallDone_Text", new String[0]), this.model.getCustomHandledComponents());
    }

    private void presentInstallFail(String string) {
        this.component.setHeadAndContent(this.getBundle(HEAD_CUSTOM_INSTALL_FAIL, new String[0]), this.getBundle(CONTENT_CUSTOM_INSTALL_FAIL, new String[0]));
        this.model.modifyOptionsForDoClose(this.wd);
        this.panel.setBody(this.getBundle("CustomHandleStep_InstallFail_Text", string), this.model.getCustomHandledComponents());
    }

    private void presentUninstallDone() {
        this.component.setHeadAndContent(this.getBundle(HEAD_CUSTOM_UNINSTALL_DONE, new String[0]), this.getBundle(CONTENT_CUSTOM_UNINSTALL_DONE, new String[0]));
        this.model.modifyOptionsForContinue(this.wd, this.isFinishPanel());
        this.panel.setBody(this.getBundle("CustomHandleStep_UninstallDone_Text", new String[0]), this.model.getCustomHandledComponents());
    }

    private void presentUninstallFail(String string) {
        this.component.setHeadAndContent(this.getBundle(HEAD_CUSTOM_UNINSTALL_FAIL, new String[0]), this.getBundle(CONTENT_CUSTOM_UNINSTALL_FAIL, new String[0]));
        this.model.modifyOptionsForDoClose(this.wd);
        this.panel.setBody(this.getBundle("CustomHandleStep_UninstallFail_Text", string), this.model.getCustomHandledComponents());
    }

    private void presentInstallNeedsRestart() {
        this.component.setHeadAndContent(this.getBundle(HEAD_CUSTOM_INSTALL_RESTART, new String[0]), this.getBundle(CONTENT_CUSTOM_INSTALL_RESTART, new String[0]));
        this.model.modifyOptionsForContinue(this.wd, this.isFinishPanel());
        if (this.isFinishPanel()) {
            this.panel.setRestartButtonsVisible(true);
        }
        this.panel.setBody(this.getBundle("CustomHandleStep_InstallDone_Text", new String[0]), this.model.getCustomHandledComponents());
    }

    private void presentUninstallNeedsRestart() {
        this.component.setHeadAndContent(this.getBundle(HEAD_CUSTOM_UNINSTALL_RESTART, new String[0]), this.getBundle(CONTENT_CUSTOM_UNINSTALL_RESTART, new String[0]));
        this.model.modifyOptionsForContinue(this.wd, this.isFinishPanel());
        if (this.isFinishPanel()) {
            this.panel.setRestartButtonsVisible(true);
        }
        this.panel.setBody(this.getBundle("CustomHandleStep_UninstallDone_Text", new String[0]), this.model.getCustomHandledComponents());
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.wd = wizardDescriptor;
        this.done = false;
        this.wasStored = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeSettings(WizardDescriptor wizardDescriptor) {
        assert (!WizardDescriptor.PREVIOUS_OPTION.equals(wizardDescriptor.getValue())) : "Cannot invoke Back in this case.";
        if (this.wasStored) {
            return;
        }
        this.wasStored = true;
        if (WizardDescriptor.CANCEL_OPTION.equals(wizardDescriptor.getValue()) || WizardDescriptor.CLOSED_OPTION.equals(wizardDescriptor.getValue()) || WizardDescriptor.NEXT_OPTION.equals(wizardDescriptor.getValue())) {
            this.model.getCustomHandledContainer().removeAll();
            return;
        }
        if (this.restarter == null) {
            if (!WizardDescriptor.FINISH_OPTION.equals(wizardDescriptor.getValue())) return;
            this.model.getCustomHandledContainer().removeAll();
            return;
        }
        final OperationSupport operationSupport = (OperationSupport)this.model.getCustomHandledContainer().getSupport();
        assert (operationSupport != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getCustomHandledContainer().listAll() + " and invalid elements " + this.model.getCustomHandledContainer().listInvalid();
        if (this.panel.restartNow()) {
            try {
                operationSupport.doRestart(this.restarter, null);
                return;
            }
            catch (OperationException operationException) {
                this.log.log(Level.INFO, operationException.getMessage(), operationException);
                return;
            }
        }
        operationSupport.doRestartLater(this.restarter);
        this.model.getCustomHandledContainer().removeAll();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    operationSupport.doRestart(CustomHandleStep.this.restarter, null);
                }
                catch (OperationException operationException) {
                    CustomHandleStep.this.log.log(Level.INFO, operationException.getMessage(), operationException);
                }
            }
        };
        InstallStep.notifyRestartNeeded(runnable, this.getBundle(this.isInstall ? "CustomHandleStep_Install_RestartNeeded" : "CustomHandleStep_Uninstall_RestartNeeded", new String[0]));
    }

    public boolean isValid() {
        return this.done;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        CustomHandleStep customHandleStep = this;
        synchronized (customHandleStep) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private String getBundle(String string, String ... stringArray) {
        return NbBundle.getMessage(CustomHandleStep.class, (String)string, (Object[])stringArray);
    }
}

