#ifndef _EFL_EVENT_INPUT_EO_H_
#define _EFL_EVENT_INPUT_EO_H_

#ifndef _EFL_EVENT_INPUT_EO_CLASS_TYPE
#define _EFL_EVENT_INPUT_EO_CLASS_TYPE

typedef Eo Efl_Event_Input;

#endif

#ifndef _EFL_EVENT_INPUT_EO_TYPES
#define _EFL_EVENT_INPUT_EO_TYPES


#endif
#define EFL_EVENT_INPUT_MIXIN efl_event_input_mixin_get()

EWAPI const Eo_Class *efl_event_input_mixin_get(void);

/** Input device that originated this event.
 *
 * @ingroup Efl_Event_Input
 */
EOAPI Efl_Input_Device *efl_event_device_get(const Eo *obj);

/**
 * @brief Input device that originated this event.
 *
 * @param[in] dev
 *
 * @ingroup Efl_Event_Input
 */
EOAPI void efl_event_device_set(Eo *obj, Efl_Input_Device *dev);

/** Extra flags for this event, may be changed by the user.
 *
 * @ingroup Efl_Event_Input
 */
EOAPI Efl_Event_Flags efl_event_flags_get(const Eo *obj);

/**
 * @brief Extra flags for this event, may be changed by the user.
 *
 * @param[in] flags
 *
 * @ingroup Efl_Event_Input
 */
EOAPI void efl_event_flags_set(Eo *obj, Efl_Event_Flags flags);

/**
 * @brief @c true if @ref efl_event_flags_get indicates the event is on hold.
 *
 * @param[in] val
 *
 * @ingroup Efl_Event_Input
 */
EOAPI void efl_event_processed_set(Eo *obj, Eina_Bool val);

/** @c true if @ref efl_event_flags_get indicates the event is on hold.
 *
 * @ingroup Efl_Event_Input
 */
EOAPI Eina_Bool efl_event_processed_get(const Eo *obj);

/**
 * @brief @c true if @ref efl_event_flags_get indicates the event happened
 * while scrolling.
 *
 * @param[in] val
 *
 * @ingroup Efl_Event_Input
 */
EOAPI void efl_event_scrolling_set(Eo *obj, Eina_Bool val);

/** @c true if @ref efl_event_flags_get indicates the event happened while
 * scrolling.
 *
 * @ingroup Efl_Event_Input
 */
EOAPI Eina_Bool efl_event_scrolling_get(const Eo *obj);

/** @c true if the event was fake, not triggered by real hardware.
 *
 * @ingroup Efl_Event_Input
 */
EOAPI Eina_Bool efl_event_fake_get(const Eo *obj);


#endif
