/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.DateFormat;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DateIndexNameProcessor
extends AbstractProcessor {
    public static final String TYPE = "date_index_name";
    private final String field;
    private final String indexNamePrefix;
    private final String dateRounding;
    private final String indexNameFormat;
    private final DateTimeZone timezone;
    private final List<Function<String, DateTime>> dateFormats;

    DateIndexNameProcessor(String tag, String field, List<Function<String, DateTime>> dateFormats, DateTimeZone timezone, String indexNamePrefix, String dateRounding, String indexNameFormat) {
        super(tag);
        this.field = field;
        this.timezone = timezone;
        this.dateFormats = dateFormats;
        this.indexNamePrefix = indexNamePrefix;
        this.dateRounding = dateRounding;
        this.indexNameFormat = indexNameFormat;
    }

    public void execute(IngestDocument ingestDocument) throws Exception {
        String date = (String)ingestDocument.getFieldValue(this.field, String.class);
        DateTime dateTime = null;
        Exception lastException = null;
        for (Function<String, DateTime> dateParser : this.dateFormats) {
            try {
                dateTime = dateParser.apply(date);
            }
            catch (Exception e) {
                lastException = (Exception)ExceptionsHelper.useOrSuppress(lastException, (Throwable)e);
            }
        }
        if (dateTime == null) {
            throw new IllegalArgumentException("unable to parse date [" + date + "]", lastException);
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)this.indexNameFormat);
        StringBuilder builder = new StringBuilder().append('<').append(this.indexNamePrefix).append('{').append(formatter.print((ReadableInstant)dateTime)).append("||/").append(this.dateRounding).append('{').append(this.indexNameFormat).append('|').append(this.timezone).append('}').append('}').append('>');
        String dynamicIndexName = builder.toString();
        ingestDocument.setFieldValue(IngestDocument.MetaData.INDEX.getFieldName(), (Object)dynamicIndexName);
    }

    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    String getIndexNamePrefix() {
        return this.indexNamePrefix;
    }

    String getDateRounding() {
        return this.dateRounding;
    }

    String getIndexNameFormat() {
        return this.indexNameFormat;
    }

    DateTimeZone getTimezone() {
        return this.timezone;
    }

    List<Function<String, DateTime>> getDateFormats() {
        return this.dateFormats;
    }

    public static final class Factory
    implements Processor.Factory {
        public DateIndexNameProcessor create(Map<String, Processor.Factory> registry, String tag, Map<String, Object> config) throws Exception {
            List<String> dateFormatStrings;
            String localeString = ConfigurationUtils.readOptionalStringProperty((String)DateIndexNameProcessor.TYPE, (String)tag, config, (String)"locale");
            String timezoneString = ConfigurationUtils.readOptionalStringProperty((String)DateIndexNameProcessor.TYPE, (String)tag, config, (String)"timezone");
            DateTimeZone timezone = timezoneString == null ? DateTimeZone.UTC : DateTimeZone.forID((String)timezoneString);
            Locale locale = Locale.ENGLISH;
            if (localeString != null) {
                try {
                    locale = new Locale.Builder().setLanguageTag(localeString).build();
                }
                catch (IllformedLocaleException e) {
                    throw new IllegalArgumentException("Invalid language tag specified: " + localeString);
                }
            }
            if ((dateFormatStrings = ConfigurationUtils.readOptionalList((String)DateIndexNameProcessor.TYPE, (String)tag, config, (String)"date_formats")) == null) {
                dateFormatStrings = Collections.singletonList("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            }
            ArrayList<Function<String, DateTime>> dateFormats = new ArrayList<Function<String, DateTime>>(dateFormatStrings.size());
            for (String format : dateFormatStrings) {
                DateFormat dateFormat = DateFormat.fromString(format);
                dateFormats.add(dateFormat.getFunction(format, timezone, locale));
            }
            String field = ConfigurationUtils.readStringProperty((String)DateIndexNameProcessor.TYPE, (String)tag, config, (String)"field");
            String indexNamePrefix = ConfigurationUtils.readStringProperty((String)DateIndexNameProcessor.TYPE, (String)tag, config, (String)"index_name_prefix", (String)"");
            String dateRounding = ConfigurationUtils.readStringProperty((String)DateIndexNameProcessor.TYPE, (String)tag, config, (String)"date_rounding");
            String indexNameFormat = ConfigurationUtils.readStringProperty((String)DateIndexNameProcessor.TYPE, (String)tag, config, (String)"index_name_format", (String)"yyyy-MM-dd");
            return new DateIndexNameProcessor(tag, field, dateFormats, timezone, indexNamePrefix, dateRounding, indexNameFormat);
        }
    }
}

