/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.nullCheck;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.DeadCodeEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.Nullability;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.NullabilityInterpreter;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.NullabilityValuesKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "deadCodeElimination", "Lorg/jetbrains/kotlin/codegen/optimization/DeadCodeEliminationMethodTransformer;", "isAlwaysFalse", "", "opcode", "", "nullability", "Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/Nullability;", "isAlwaysTrue", "runSingleNullCheckEliminationPass", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "transform", "", "kotlin-compiler"})
public final class RedundantNullCheckMethodTransformer
extends MethodTransformer {
    private final DeadCodeEliminationMethodTransformer deadCodeElimination = new DeadCodeEliminationMethodTransformer();

    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(internalClassName, "internalClassName");
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        while (this.runSingleNullCheckEliminationPass(internalClassName, methodNode)) {
            this.deadCodeElimination.transform(internalClassName, methodNode);
        }
    }

    private final boolean isAlwaysFalse(int opcode, Nullability nullability) {
        return opcode == 198 && Intrinsics.areEqual((Object)nullability, (Object)Nullability.NOT_NULL) || opcode == 199 && Intrinsics.areEqual((Object)nullability, (Object)Nullability.NULL);
    }

    private final boolean isAlwaysTrue(int opcode, Nullability nullability) {
        return opcode == 198 && Intrinsics.areEqual((Object)nullability, (Object)Nullability.NULL) || opcode == 199 && Intrinsics.areEqual((Object)nullability, (Object)Nullability.NOT_NULL);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean runSingleNullCheckEliminationPass(String internalClassName, MethodNode methodNode) {
        void $receiver$iv$iv;
        void $receiver$iv;
        InsnList insnList = methodNode.instructions;
        AbstractInsnNode[] instructions = insnList.toArray();
        Object[] objectArray = instructions;
        Collection destination$iv = new SmartList();
        void $receiver$iv$iv2 = $receiver$iv;
        for (int i = 0; i < ((void)$receiver$iv$iv2).length; ++i) {
            AbstractInsnNode abstractInsnNode;
            AbstractInsnNode it;
            void element$iv$iv = $receiver$iv$iv2[i];
            void element$iv = element$iv$iv;
            AbstractInsnNode it2 = (AbstractInsnNode)element$iv;
            Object $receiver$iv2 = it2;
            AbstractInsnNode abstractInsnNode2 = $receiver$iv2;
            if (!(abstractInsnNode2 instanceof JumpInsnNode)) {
                abstractInsnNode2 = null;
            }
            JumpInsnNode jumpInsnNode = (JumpInsnNode)abstractInsnNode2;
            AbstractInsnNode abstractInsnNode3 = jumpInsnNode != null ? ((it = ($receiver$iv2 = jumpInsnNode)).getOpcode() == 198 || it.getOpcode() == 199 ? $receiver$iv2 : null) : null;
            if (abstractInsnNode3 == null) continue;
            AbstractInsnNode it$iv = abstractInsnNode = abstractInsnNode3;
            destination$iv.add(it$iv);
        }
        SmartList nullCheckIfs = (SmartList)destination$iv;
        if (nullCheckIfs.isEmpty()) {
            return false;
        }
        Frame<V>[] frames2 = MethodTransformer.analyze(internalClassName, methodNode, new NullabilityInterpreter());
        Iterable $receiver$iv3 = nullCheckIfs;
        Iterable iterable = $receiver$iv3;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Pair<JumpInsnNode, Nullability> pair;
            Frame frame;
            Frame top;
            Nullability nullability;
            Object element$iv$iv = element$iv$iv$iv;
            JumpInsnNode insn = (JumpInsnNode)element$iv$iv;
            Frame frame2 = frames2[ArraysKt.indexOf((Object[])instructions, insn)];
            Pair<JumpInsnNode, Nullability> pair2 = frame2 != null && (frame2 = (BasicValue)StackTransformationUtilsKt.top(frame2)) != null ? (Intrinsics.areEqual((Object)(nullability = NullabilityValuesKt.getNullability((BasicValue)((Object)(top = (frame = frame2))))), (Object)Nullability.NULLABLE) ? null : new Pair<JumpInsnNode, Nullability>(insn, nullability)) : null;
            if (pair2 == null) continue;
            Pair<JumpInsnNode, Nullability> it$iv$iv = pair = pair2;
            destination$iv$iv.add(it$iv$iv);
        }
        List redundantNullCheckIfs = (List)destination$iv$iv;
        if (redundantNullCheckIfs.isEmpty()) {
            return false;
        }
        for (Pair pair : redundantNullCheckIfs) {
            Integer n;
            AbstractInsnNode previous;
            JumpInsnNode insn = (JumpInsnNode)pair.component1();
            Nullability nullability = (Nullability)((Object)pair.component2());
            AbstractInsnNode abstractInsnNode = previous = insn.getPrevious();
            Integer n2 = n = abstractInsnNode != null ? Integer.valueOf(abstractInsnNode.getOpcode()) : null;
            if (Intrinsics.areEqual(n, (Object)25) || Intrinsics.areEqual(n, (Object)89)) {
                insnList.remove(previous);
            } else {
                insnList.insert(previous, new InsnNode(87));
            }
            if (this.isAlwaysTrue(insn.getOpcode(), nullability)) {
                insnList.set(insn, new JumpInsnNode(167, insn.label));
                continue;
            }
            if (!this.isAlwaysFalse(insn.getOpcode(), nullability)) continue;
            insnList.remove(insn);
        }
        return true;
    }
}

