/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.command;

import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.command.Command;
import java.util.Vector;

public class Controller {
    private Vector<Command> commands = new Vector();
    private final DiagramHandler handler;
    private int _cursor = -1;

    public Controller(DiagramHandler handler) {
        this.handler = handler;
    }

    public void executeCommand(Command newCommand) {
        Command c_nMinus1;
        Command c_n;
        for (int i = this.commands.size() - 1; i > this._cursor; --i) {
            this.commands.removeElementAt(i);
        }
        this.commands.add(newCommand);
        newCommand.execute(this.handler);
        if (this.commands.size() >= 2 && (c_n = this.commands.elementAt(this.commands.size() - 1)).isMergeableTo(c_nMinus1 = this.commands.elementAt(this.commands.size() - 2))) {
            this.commands.removeElement(c_n);
            this.commands.removeElement(c_nMinus1);
            Command c = c_n.mergeTo(c_nMinus1);
            this.commands.add(c);
        }
        this._cursor = this.commands.size() - 1;
        if (newCommand.isChangingDiagram()) {
            this.handler.setChanged(true);
        }
        CurrentGui.getInstance().getGui().updateGrayedOutMenuItems(this.handler);
    }

    public void undo() {
        if (this.isUndoable()) {
            Command c = this.commands.elementAt(this._cursor);
            c.undo(this.handler);
            --this._cursor;
            if (c.isChangingDiagram()) {
                this.handler.setChanged(true);
            }
        }
        CurrentGui.getInstance().getGui().updateGrayedOutMenuItems(CurrentDiagram.getInstance().getDiagramHandler());
    }

    public void redo() {
        if (this.isRedoable()) {
            Command c = this.commands.elementAt(this._cursor + 1);
            c.redo(this.handler);
            ++this._cursor;
            if (c.isChangingDiagram()) {
                this.handler.setChanged(true);
            }
        }
        CurrentGui.getInstance().getGui().updateGrayedOutMenuItems(CurrentDiagram.getInstance().getDiagramHandler());
    }

    public boolean isEmpty() {
        return this.commands.isEmpty();
    }

    public boolean isUndoable() {
        return this._cursor >= 0;
    }

    public boolean isRedoable() {
        return this._cursor < this.commands.size() - 1;
    }

    public void clear() {
        this.commands = new Vector();
        this._cursor = -1;
    }
}

