/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.command;

import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.DrawPanel;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.command.AddElement;
import com.baselet.gui.command.Command;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class RemoveElement
extends Command {
    private List<GridElement> _entities = new ArrayList<GridElement>();
    private Point origin;
    private boolean _zoom;

    public RemoveElement(GridElement e) {
        this(e, true);
    }

    public RemoveElement(GridElement e, boolean zoom) {
        this._entities.add(e);
        this._zoom = zoom;
    }

    public RemoveElement(List<GridElement> v) {
        this(v, true);
    }

    public RemoveElement(List<GridElement> v, boolean zoom) {
        this._entities.addAll(v);
        this._zoom = zoom;
    }

    @Override
    public void execute(DiagramHandler handler) {
        super.execute(handler);
        if (this._entities.size() == 0) {
            return;
        }
        DrawPanel p = handler.getDrawPanel();
        for (GridElement e : this._entities) {
            handler.getDrawPanel().removeElement(e);
        }
        this.origin = handler.getDrawPanel().getOriginAtDefaultZoom();
        if (this._zoom) {
            DiagramHandler.zoomEntities(handler.getGridSize(), 10, this._entities);
        }
        p.updatePanelAndScrollbars();
        p.repaint();
        p.getSelector().deselectAll();
    }

    @Override
    public void undo(DiagramHandler handler) {
        super.undo(handler);
        if (this._zoom) {
            DiagramHandler.zoomEntities(10, handler.getGridSize(), this._entities);
        }
        int offsetX = this.origin.x - handler.getDrawPanel().getOriginAtDefaultZoom().x;
        int offsetY = this.origin.y - handler.getDrawPanel().getOriginAtDefaultZoom().y;
        offsetX = offsetX * handler.getGridSize() / 10;
        offsetY = offsetY * handler.getGridSize() / 10;
        for (GridElement e : this._entities) {
            new AddElement(e, handler.realignToGrid(e.getRectangle().x + offsetX), handler.realignToGrid(e.getRectangle().y + offsetY), this._zoom).execute(handler);
        }
        handler.getDrawPanel().updatePanelAndScrollbars();
        handler.getDrawPanel().repaint();
    }
}

