#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 1.19.2.1
id: pandoc-1.19.2.1-2xoEYjAO7BB3XVcyaZrk9D
key: pandoc-1.19.2.1-2xoEYjAO7BB3XVcyaZrk9D
license: GPL
copyright: (c) 2006-2017 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: http://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook,
    MediaWiki markup, TWiki markup, Haddock markup, OPML,
    Emacs Org-Mode, txt2tags, Word Docx, ODT, and Textile, and
    it can write Markdown, reStructuredText, XHTML, HTML 5,
    LaTeX, ConTeXt, DocBook, OPML, TEI, OpenDocument, ODT,
    Word docx, RTF, MediaWiki, DokuWiki, ZimWiki, Textile,
    groff man pages, plain text, Emacs Org-Mode, AsciiDoc,
    Haddock markup, EPUB (v2 and v3), FictionBook2, InDesign ICML,
    and several kinds of HTML/javascript slide shows (S5, Slidy,
    Slideous, DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
author: John MacFarlane <jgm@berkeley.edu>
exposed: True
exposed-modules:
    Text.Pandoc Text.Pandoc.Options Text.Pandoc.Pretty
    Text.Pandoc.Shared Text.Pandoc.MediaBag Text.Pandoc.Error
    Text.Pandoc.Readers.HTML Text.Pandoc.Readers.LaTeX
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.MediaWiki Text.Pandoc.Readers.RST
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.DocBook
    Text.Pandoc.Readers.OPML Text.Pandoc.Readers.TeXMath
    Text.Pandoc.Readers.Textile Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.TWiki
    Text.Pandoc.Readers.Txt2Tags Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.Odt Text.Pandoc.Readers.EPUB
    Text.Pandoc.Writers.Native Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.HTML
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.LaTeX
    Text.Pandoc.Writers.ConTeXt Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.CommonMark
    Text.Pandoc.Writers.Haddock Text.Pandoc.Writers.RST
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.ZimWiki Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.Docx
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.TEI Text.Pandoc.PDF Text.Pandoc.UTF8
    Text.Pandoc.Templates Text.Pandoc.XML Text.Pandoc.SelfContained
    Text.Pandoc.Process Text.Pandoc.CSS
hidden-modules: Text.Pandoc.Readers.Docx.Lists
                Text.Pandoc.Readers.Docx.Combine Text.Pandoc.Readers.Docx.Parse
                Text.Pandoc.Readers.Docx.Util Text.Pandoc.Readers.Docx.StyleMap
                Text.Pandoc.Readers.Odt.Base Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils
                Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
                Text.Pandoc.Readers.Org.ExportSettings
                Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
                Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
                Text.Pandoc.Readers.Org.Shared Text.Pandoc.Writers.Shared
                Text.Pandoc.Asciify Text.Pandoc.MIME Text.Pandoc.Emoji
                Text.Pandoc.Parsing Text.Pandoc.UUID Text.Pandoc.ImageSize
                Text.Pandoc.Slides Text.Pandoc.Highlighting Text.Pandoc.Compat.Time
                Paths_pandoc
abi: 06fa404397d2c2af47d9f92c2b929bec
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/pandoc-1.19.2.1
library-dirs: /usr/lib/ghc-8.0.1/site-local/pandoc-1.19.2.1
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-1.19.2.1-2xoEYjAO7BB3XVcyaZrk9D
depends:
    HTTP-4000.3.7-L7ouxpRZ3EI4a0NroZLSRI
    JuicyPixels-3.2.8.1-8BpUIjM1ne1KhnHQeIHler
    SHA-1.6.4.2-GSP9nhHyWNEAImBrL9QfXp
    aeson-1.1.2.0-KxdCZ7gJzCsHXfqqwVMGzQ array-0.5.1.1 base-4.9.0.0
    base64-bytestring-1.0.0.1-In9M41tLtcS9QYt3QpGpNY binary-0.8.3.0
    blaze-html-0.8.1.3-5umpHbJSFbGGX5TQ5mnIPt
    blaze-markup-0.7.1.1-VJaDzmYXPW8F1IHSBweDX bytestring-0.10.8.1
    cmark-0.5.5.1-IYWFaQ0t2aZrAnXPXT78m containers-0.5.7.1
    data-default-0.7.1.1-ZpKfkXGfJa8c8Q6OFbvrr deepseq-1.4.2.0
    directory-1.2.6.2 doctemplates-0.1.0.2-DAetAOWTsF16Sutk3gA00Z
    extensible-exceptions-0.1.1.4-3h0ykvvAO915cRhUyj3rRV
    filemanip-0.3.6.3-37waR2Io5Eq5ppT96AvCIW filepath-1.4.1.0
    ghc-prim-0.5.0.0 haddock-library-1.4.3-7rEGzge05s5BxGssFs5tiB
    hslua-0.4.1-D8QXBMM9Kwg4NVuXtEl8dM
    http-client-0.5.7.0-2oq75h5MpX96GWijxg7br2
    http-client-tls-0.3.5-E1hsVKYBSgY88Tu1BOpFW2
    http-types-0.9.1-3nvMCSru4dgGbycKqlKoUe
    mtl-2.2.1-6qsR1PHUy5lL47Hpoa4jCM
    network-2.6.3.2-GMjPV5zpIjuBSljTanWiH
    network-uri-2.6.1.0-FJ8JXDcVJz8KYX76kkCObd
    old-time-1.1.0.3-IcvdkJUsE9M8t3io8peAEp
    pandoc-types-1.17.0.5-IwUiD9C5eyXAsI6W0qwxTl
    parsec-3.1.11-LsiSww7OPVN4zZBDwUQHXr process-1.4.2.0
    random-1.1-54KmMHXjttlERYcr1mvsAe
    scientific-0.3.4.13-4xwcJxzSIhZ6kELOWf7cDt
    skylighting-0.1.1.5-In58BwSDlcKHhh7V04SiG7
    syb-0.6-C65vWCsht6A8uLstpQIXyj
    tagsoup-0.14.1-5UpYkVoOhOt4iyOyy0sWwj
    temporary-1.2.0.4-2ZGJgvUMoC3CqxertnjRxn
    texmath-0.9.4-1GeuZMaPNFhI27HJQoWNgf
    text-1.2.2.2-9rr3K4o0GAG9P33dGDnV9v time-1.6.0.1
    unordered-containers-0.2.8.0-Njz6QHP7Gk5G9PhT6D28J
    vector-0.12.0.1-FyKxZ6HyOdr5RycjHR2p0f
    xml-1.3.14-9IpHbL0QRqR5eAZpdkwTMQ
    yaml-0.8.23-4eFD3qF41N4Asgvn9AXRLk
    zip-archive-0.3.0.6-JjkOHEal90LKpFodcWqmlO
    zlib-0.6.1.2-1dMv6Gv8Q4W22Ei4thcEsU
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
