#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: scientific
version: 0.3.4.13
id: scientific-0.3.4.13-4xwcJxzSIhZ6kELOWf7cDt
key: scientific-0.3.4.13-4xwcJxzSIhZ6kELOWf7cDt
license: BSD3
maintainer: Bas van Dijk <v.dijk.bas@gmail.com>
homepage: https://github.com/basvandijk/scientific
synopsis: Numbers represented using scientific notation
description:
    @Data.Scientific@ provides the number type '\''Scientific'\''. Scientific numbers are
    arbitrary precision and space efficient. They are represented using
    <http://en.wikipedia.org/wiki/Scientific_notation scientific notation>.
    The implementation uses a coefficient @c :: '\''Integer'\''@ and a base-10 exponent
    @e :: '\''Int'\''@. A scientific number corresponds to the
    '\''Fractional'\'' number: @'\''fromInteger'\'' c * 10 '\''^^'\'' e@.
    .
    Note that since we'\''re using an '\''Int'\'' to represent the exponent these numbers
    aren'\''t truly arbitrary precision. I intend to change the type of the exponent
    to '\''Integer'\'' in a future release.
    .
    The main application of '\''Scientific'\'' is to be used as the target of parsing
    arbitrary precision numbers coming from an untrusted source. The advantages
    over using '\''Rational'\'' for this are that:
    .
    * A '\''Scientific'\'' is more efficient to construct. Rational numbers need to be
    constructed using '\''%'\'' which has to compute the '\''gcd'\'' of the '\''numerator'\'' and
    '\''denominator'\''.
    .
    * '\''Scientific'\'' is safe against numbers with huge exponents. For example:
    @1e1000000000 :: '\''Rational'\''@ will fill up all space and crash your
    program. Scientific works as expected:
    .
    > > read "1e1000000000" :: Scientific
    > 1.0e1000000000
    .
    * Also, the space usage of converting scientific numbers with huge exponents to
    @'\''Integral'\''s@ (like: '\''Int'\'') or @'\''RealFloat'\''s@ (like: '\''Double'\'' or '\''Float'\'')
    will always be bounded by the target type.
category: Data
author: Bas van Dijk
exposed: True
exposed-modules:
    Data.ByteString.Builder.Scientific Data.Scientific
    Data.Text.Lazy.Builder.Scientific
hidden-modules: GHC.Integer.Compat Utils
abi: c78047cf7beb16e500f1a26ff5b546ee
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/scientific-0.3.4.13
library-dirs: /usr/lib/ghc-8.0.1/site-local/scientific-0.3.4.13
data-dir: /usr/share/arm-linux-ghc-8.0.1/scientific-0.3.4.13
hs-libraries: HSscientific-0.3.4.13-4xwcJxzSIhZ6kELOWf7cDt
depends:
    base-4.9.0.0 binary-0.8.3.0 bytestring-0.10.8.1 containers-0.5.7.1
    deepseq-1.4.2.0 ghc-prim-0.5.0.0
    hashable-1.2.6.0-CKFo6Z8S7bXH0jokyKXcu0 integer-gmp-1.0.0.1
    integer-logarithms-1.0.1-BMmDc9fXSmWBX4AQeoakwE
    text-1.2.2.2-9rr3K4o0GAG9P33dGDnV9v
    vector-0.12.0.1-FyKxZ6HyOdr5RycjHR2p0f
haddock-interfaces: /usr/share/doc/haskell-scientific/html/scientific.haddock
haddock-html: /usr/share/doc/haskell-scientific/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
