/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.util.Objects;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.TextLabel;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.CompletelyInsideAreaStrategy;

public class TextElement
extends StyleElement {
    private final TextLabel text;

    protected TextElement(Cascade cascade, TextLabel textLabel) {
        super(cascade, 4.9f);
        this.text = textLabel;
    }

    public static TextElement create(Environment environment) {
        TextLabel textLabel = TextLabel.create(environment, PaintColors.TEXT.get(), false);
        if (textLabel == null) {
            return null;
        }
        Cascade cascade = environment.mc.getCascade(environment.layer);
        return new TextElement(cascade, textLabel);
    }

    public static TextElement createForContent(Environment environment) {
        Cascade cascade = environment.mc.getCascade(environment.layer);
        Keyword keyword = cascade.get("text-position", null, Keyword.class);
        if (keyword != null) {
            return null;
        }
        TextLabel textLabel = TextLabel.create(environment, PaintColors.TEXT.get(), true);
        if (textLabel == null) {
            return null;
        }
        return new TextElement(cascade, textLabel.withPosition(CompletelyInsideAreaStrategy.INSTANCE));
    }

    @Override
    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, StyledMapRenderer styledMapRenderer, boolean bl, boolean bl2, boolean bl3) {
        styledMapRenderer.drawText(osmPrimitive, this.text);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TextElement textElement = (TextElement)object;
        return Objects.equals(this.text, textElement.text);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.text);
    }

    @Override
    public String toString() {
        return "TextElement{" + super.toString() + "text=" + this.text + '}';
    }
}

