/*
 * Decompiled with CFR 0.152.
 */
package me.qmx.jitescript;

import java.util.ArrayList;
import me.qmx.jitescript.CodeBlock;
import me.qmx.jitescript.VisibleAnnotation;
import org.jruby.org.objectweb.asm.tree.LocalVariableNode;
import org.jruby.org.objectweb.asm.tree.MethodNode;
import org.jruby.org.objectweb.asm.tree.TryCatchBlockNode;

public class MethodDefinition {
    private final String methodName;
    private final int modifiers;
    private final String signature;
    private final CodeBlock methodBody;

    public MethodDefinition(String methodName, int modifiers2, String signature, CodeBlock methodBody) {
        this.methodName = methodName;
        this.modifiers = modifiers2;
        this.signature = signature;
        this.methodBody = methodBody;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public CodeBlock getMethodBody() {
        return this.methodBody;
    }

    public String getSignature() {
        return this.signature;
    }

    public MethodNode getMethodNode() {
        MethodNode method = new MethodNode(this.getModifiers(), this.getMethodName(), this.getSignature(), null, null);
        method.visibleAnnotations = new ArrayList();
        method.instructions.add(this.getMethodBody().getInstructionList());
        for (TryCatchBlockNode tryCatchBlockNode : this.getMethodBody().getTryCatchBlockList()) {
            method.tryCatchBlocks.add(tryCatchBlockNode);
        }
        for (LocalVariableNode localVariableNode : this.getMethodBody().getLocalVariableList()) {
            method.localVariables.add(localVariableNode);
        }
        for (VisibleAnnotation annotation2 : this.methodBody.getAnnotations()) {
            method.visibleAnnotations.add(annotation2.getNode());
        }
        return method;
    }
}

