/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiFieldStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;

public class PsiFieldStubImpl
extends StubBase<PsiField>
implements PsiFieldStub {
    private final StringRef myName;
    private final TypeInfo myType;
    private final StringRef myInitializer;
    private final byte myFlags;

    public PsiFieldStubImpl(StubElement parent2, String name2, @NotNull TypeInfo type2, @Nullable String initializer2, byte flags) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiFieldStubImpl", "<init>"));
        }
        this(parent2, StringRef.fromString(name2), type2, StringRef.fromString(initializer2), flags);
    }

    public PsiFieldStubImpl(StubElement parent2, StringRef name2, @NotNull TypeInfo type2, @Nullable StringRef initializer2, byte flags) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiFieldStubImpl", "<init>"));
        }
        super(parent2, PsiFieldStubImpl.isEnumConst(flags) ? JavaStubElementTypes.ENUM_CONSTANT : JavaStubElementTypes.FIELD);
        this.myName = name2;
        this.myType = type2;
        this.myInitializer = initializer2;
        this.myFlags = flags;
    }

    public byte getFlags() {
        return this.myFlags;
    }

    @Override
    @NotNull
    public TypeInfo getType(boolean doResolve) {
        TypeInfo typeInfo = doResolve ? this.myType.applyAnnotations(this) : this.myType;
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiFieldStubImpl", "getType"));
        }
        return typeInfo;
    }

    @Override
    public String getInitializerText() {
        return StringRef.toString(this.myInitializer);
    }

    @Override
    public boolean isEnumConstant() {
        return PsiFieldStubImpl.isEnumConst(this.myFlags);
    }

    private static boolean isEnumConst(byte flags) {
        return BitUtil.isSet(flags, (byte)1);
    }

    @Override
    public boolean isDeprecated() {
        return BitUtil.isSet(this.myFlags, (byte)2);
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return BitUtil.isSet(this.myFlags, (byte)4);
    }

    @Override
    public boolean hasDocComment() {
        return BitUtil.isSet(this.myFlags, (byte)8);
    }

    @Override
    public String getName() {
        return StringRef.toString(this.myName);
    }

    public static byte packFlags(boolean isEnumConst, boolean isDeprecated, boolean hasDeprecatedAnnotation, boolean hasDocComment) {
        byte flags = 0;
        if (isEnumConst) {
            flags = (byte)(flags | 1);
        }
        if (isDeprecated) {
            flags = (byte)(flags | 2);
        }
        if (hasDeprecatedAnnotation) {
            flags = (byte)(flags | 4);
        }
        if (hasDocComment) {
            flags = (byte)(flags | 8);
        }
        return flags;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiFieldStub[");
        if (this.isDeprecated() || this.hasDeprecatedAnnotation()) {
            builder.append("deprecated ");
        }
        if (this.isEnumConstant()) {
            builder.append("enumconst ");
        }
        builder.append(this.myName).append(':').append(this.myType);
        if (this.myInitializer != null) {
            builder.append('=').append(this.myInitializer);
        }
        builder.append(']');
        return builder.toString();
    }
}

