/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaArrayTypeImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassifierTypeImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaPrimitiveTypeImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaWildcardTypeImpl;
import org.jetbrains.kotlin.name.FqName;

public abstract class JavaTypeImpl<Psi extends PsiType>
implements JavaType,
JavaAnnotationOwnerImpl {
    private final Psi psiType;

    public JavaTypeImpl(@NotNull Psi psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeImpl", "<init>"));
        }
        this.psiType = psiType;
    }

    @NotNull
    public Psi getPsi() {
        Psi Psi = this.psiType;
        if (Psi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeImpl", "getPsi"));
        }
        return Psi;
    }

    @Override
    @Nullable
    public PsiAnnotationOwner getAnnotationOwnerPsi() {
        return this.getPsi();
    }

    @NotNull
    public static JavaTypeImpl<?> create(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeImpl", "create"));
        }
        JavaTypeImpl javaTypeImpl = (JavaTypeImpl)psiType.accept(new PsiTypeVisitor<JavaTypeImpl<?>>(){

            @Override
            @Nullable
            public JavaTypeImpl<?> visitType(@NotNull PsiType type2) {
                if (type2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeImpl$1", "visitType"));
                }
                throw new UnsupportedOperationException("Unsupported PsiType: " + type2);
            }

            @Override
            @Nullable
            public JavaTypeImpl<?> visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
                if (primitiveType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primitiveType", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeImpl$1", "visitPrimitiveType"));
                }
                return new JavaPrimitiveTypeImpl(primitiveType);
            }

            @Override
            @Nullable
            public JavaTypeImpl<?> visitArrayType(@NotNull PsiArrayType arrayType) {
                if (arrayType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayType", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeImpl$1", "visitArrayType"));
                }
                return new JavaArrayTypeImpl(arrayType);
            }

            @Override
            @Nullable
            public JavaTypeImpl<?> visitClassType(@NotNull PsiClassType classType) {
                if (classType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeImpl$1", "visitClassType"));
                }
                return new JavaClassifierTypeImpl(classType);
            }

            @Override
            @Nullable
            public JavaTypeImpl<?> visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                if (wildcardType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wildcardType", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeImpl$1", "visitWildcardType"));
                }
                return new JavaWildcardTypeImpl(wildcardType);
            }
        });
        if (javaTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeImpl", "create"));
        }
        return javaTypeImpl;
    }

    @Override
    @NotNull
    public Collection<JavaAnnotation> getAnnotations() {
        Collection<JavaAnnotation> collection = JavaElementUtil.getAnnotations(this);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeImpl", "getAnnotations"));
        }
        return collection;
    }

    @Override
    @Nullable
    public JavaAnnotation findAnnotation(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeImpl", "findAnnotation"));
        }
        return JavaElementUtil.findAnnotation(this, fqName2);
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return false;
    }

    public int hashCode() {
        return this.getPsi().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaTypeImpl && this.getPsi().equals(((JavaTypeImpl)obj).getPsi());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getPsi();
    }
}

