/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publisher;

import java.io.IOException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublisher;
import org.gradle.internal.component.external.model.DefaultIvyModulePublishMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.IvyModulePublishMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;

public class DependencyResolverIvyPublisher
implements IvyPublisher {
    @Override
    public void publish(IvyNormalizedPublication publication, PublicationAwareRepository repository) {
        ModuleVersionPublisher publisher = repository.createPublisher();
        IvyPublicationIdentity projectIdentity = publication.getProjectIdentity();
        ModuleComponentIdentifier moduleVersionIdentifier = DefaultModuleComponentIdentifier.newId((String)projectIdentity.getOrganisation(), (String)projectIdentity.getModule(), (String)projectIdentity.getRevision());
        DefaultIvyModulePublishMetadata publishMetaData = new DefaultIvyModulePublishMetadata(moduleVersionIdentifier, "");
        try {
            for (IvyArtifact publishArtifact : publication.getArtifacts()) {
                publishMetaData.addArtifact(this.createIvyArtifact(publishArtifact), publishArtifact.getFile());
            }
            DefaultIvyArtifactName artifact = new DefaultIvyArtifactName("ivy", "ivy", "xml");
            publishMetaData.addArtifact((IvyArtifactName)artifact, publication.getDescriptorFile());
            publisher.publish((IvyModulePublishMetadata)publishMetaData);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private IvyArtifactName createIvyArtifact(IvyArtifact ivyArtifact) {
        return new DefaultIvyArtifactName(ivyArtifact.getName(), ivyArtifact.getType(), ivyArtifact.getExtension(), ivyArtifact.getClassifier());
    }
}

