/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.model;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.DefaultAttributesSchema;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultLibraryComponentSelector;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.model.ComponentAttributeMatcher;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.LocalComponentDependencyMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.LibraryBinaryDependencySpec;
import org.gradle.platform.base.ModuleDependencySpec;
import org.gradle.platform.base.ProjectDependencySpec;
import org.gradle.platform.base.internal.DefaultModuleDependencySpec;

public class DefaultLibraryLocalComponentMetadata
extends DefaultLocalComponentMetadata {
    private static final String VERSION = "<local component>";
    private static final List<Exclude> EXCLUDE_RULES = Collections.emptyList();
    private static final String CONFIGURATION_COMPILE = "compile";

    public static DefaultLibraryLocalComponentMetadata newResolvedLibraryMetadata(LibraryBinaryIdentifier componentId, Map<String, Iterable<DependencySpec>> dependencies, String defaultProject) {
        DefaultLibraryLocalComponentMetadata metadata = DefaultLibraryLocalComponentMetadata.newDefaultLibraryLocalComponentMetadata(componentId, dependencies.keySet());
        DefaultLibraryLocalComponentMetadata.addDependenciesToMetaData(dependencies, metadata, defaultProject);
        return metadata;
    }

    private static void addDependenciesToMetaData(Map<String, Iterable<DependencySpec>> dependencies, DefaultLibraryLocalComponentMetadata metadata, String defaultProject) {
        for (Map.Entry<String, Iterable<DependencySpec>> entry : dependencies.entrySet()) {
            DefaultLibraryLocalComponentMetadata.addDependenciesToMetadata(metadata, defaultProject, entry.getValue(), entry.getKey());
        }
    }

    public static DefaultLibraryLocalComponentMetadata newResolvingLocalComponentMetadata(LibraryBinaryIdentifier componentId, String usage, Iterable<DependencySpec> dependencies) {
        DefaultLibraryLocalComponentMetadata metadata = DefaultLibraryLocalComponentMetadata.newDefaultLibraryLocalComponentMetadata(componentId, Collections.singleton(usage));
        DefaultLibraryLocalComponentMetadata.addDependenciesToMetadata(metadata, componentId.getProjectPath(), dependencies, usage);
        return metadata;
    }

    private static DefaultLibraryLocalComponentMetadata newDefaultLibraryLocalComponentMetadata(LibraryBinaryIdentifier componentId, Set<String> usages) {
        DefaultLibraryLocalComponentMetadata metaData = new DefaultLibraryLocalComponentMetadata((ModuleVersionIdentifier)DefaultLibraryLocalComponentMetadata.localModuleVersionIdentifierFor(componentId), (ComponentIdentifier)componentId);
        for (String usage : usages) {
            metaData.addConfiguration(usage, String.format("Request metadata: %s", componentId.getDisplayName()), Collections.emptySet(), Collections.singleton(usage), true, true, (AttributeContainerInternal)ImmutableAttributes.EMPTY, true, false);
        }
        return metaData;
    }

    private static void addDependenciesToMetadata(DefaultLibraryLocalComponentMetadata metadata, String defaultProject, Iterable<DependencySpec> value, String configuration) {
        metadata.addDependencies(value, defaultProject, configuration);
    }

    private static DefaultModuleVersionIdentifier localModuleVersionIdentifierFor(LibraryBinaryIdentifier componentId) {
        return new DefaultModuleVersionIdentifier(componentId.getProjectPath(), componentId.getLibraryName(), VERSION);
    }

    private DefaultLibraryLocalComponentMetadata(ModuleVersionIdentifier id, ComponentIdentifier componentIdentifier) {
        super(id, componentIdentifier, "release", (AttributesSchemaInternal)new DefaultAttributesSchema(new ComponentAttributeMatcher()));
    }

    private void addDependencies(Iterable<DependencySpec> dependencies, String projectPath, String usageConfigurationName) {
        for (DependencySpec dependency : dependencies) {
            this.addDependency(dependency, projectPath, usageConfigurationName);
        }
    }

    private void addDependency(DependencySpec dependency, String defaultProject, String usageConfigurationName) {
        LocalOriginDependencyMetadata metadata = dependency instanceof ModuleDependencySpec ? this.moduleDependencyMetadata((ModuleDependencySpec)dependency, usageConfigurationName) : (dependency instanceof ProjectDependencySpec ? this.projectDependencyMetadata((ProjectDependencySpec)dependency, defaultProject, usageConfigurationName) : this.binaryDependencyMetadata((LibraryBinaryDependencySpec)dependency, usageConfigurationName));
        this.addDependency(metadata);
    }

    private LocalOriginDependencyMetadata moduleDependencyMetadata(ModuleDependencySpec moduleDependency, String usageConfigurationName) {
        ModuleVersionSelector requested = this.moduleVersionSelectorFrom(moduleDependency);
        ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector((ModuleVersionSelector)requested);
        return this.dependencyMetadataFor((ComponentSelector)selector, requested, usageConfigurationName, CONFIGURATION_COMPILE);
    }

    private LocalOriginDependencyMetadata projectDependencyMetadata(ProjectDependencySpec projectDependency, String defaultProject, String usageConfigurationName) {
        String projectPath = projectDependency.getProjectPath();
        if (Strings.isNullOrEmpty((String)projectPath)) {
            projectPath = defaultProject;
        }
        String libraryName = projectDependency.getLibraryName();
        DefaultLibraryComponentSelector selector = new DefaultLibraryComponentSelector(projectPath, libraryName);
        DefaultModuleVersionSelector requested = new DefaultModuleVersionSelector(Strings.nullToEmpty((String)projectPath), Strings.nullToEmpty((String)libraryName), this.getId().getVersion());
        return this.dependencyMetadataFor((ComponentSelector)selector, (ModuleVersionSelector)requested, usageConfigurationName, usageConfigurationName);
    }

    private LocalOriginDependencyMetadata binaryDependencyMetadata(LibraryBinaryDependencySpec binarySpec, String usageConfigurationName) {
        String projectPath = binarySpec.getProjectPath();
        String libraryName = binarySpec.getLibraryName();
        DefaultLibraryComponentSelector selector = new DefaultLibraryComponentSelector(projectPath, libraryName, binarySpec.getVariant());
        DefaultModuleVersionSelector requested = new DefaultModuleVersionSelector(projectPath, libraryName, this.getId().getVersion());
        return this.dependencyMetadataFor((ComponentSelector)selector, (ModuleVersionSelector)requested, usageConfigurationName, usageConfigurationName);
    }

    private ModuleVersionSelector moduleVersionSelectorFrom(ModuleDependencySpec module) {
        return new DefaultModuleVersionSelector(module.getGroup(), module.getName(), DefaultModuleDependencySpec.effectiveVersionFor(module.getVersion()));
    }

    private LocalOriginDependencyMetadata dependencyMetadataFor(ComponentSelector selector, ModuleVersionSelector requested, String usageConfigurationName, String mappedUsageConfiguration) {
        return new LocalComponentDependencyMetadata(selector, requested, usageConfigurationName, null, mappedUsageConfiguration, Collections.emptySet(), EXCLUDE_RULES, false, false, true);
    }
}

