/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LightModifierList
extends LightElement
implements PsiModifierList {
    private final Set<String> myModifiers;

    public LightModifierList(PsiModifierListOwner modifierListOwner) {
        this(modifierListOwner.getManager());
        this.copyModifiers(modifierListOwner.getModifierList());
    }

    public LightModifierList(PsiManager manager) {
        this(manager, JavaLanguage.INSTANCE, new String[0]);
    }

    public LightModifierList(PsiManager manager, Language language, String ... modifiers) {
        super(manager, language);
        this.myModifiers = ContainerUtil.newTroveSet(modifiers);
    }

    public void addModifier(String modifier) {
        this.myModifiers.add(modifier);
    }

    public void copyModifiers(PsiModifierList modifierList) {
        if (modifierList == null) {
            return;
        }
        for (String modifier : PsiModifier.MODIFIERS) {
            if (!modifierList.hasExplicitModifier(modifier)) continue;
            this.addModifier(modifier);
        }
    }

    public void clearModifiers() {
        this.myModifiers.clear();
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightModifierList", "hasModifierProperty"));
        }
        return this.myModifiers.contains(name);
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightModifierList", "hasExplicitModifier"));
        }
        return this.myModifiers.contains(name);
    }

    @Override
    public void setModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightModifierList", "setModifierProperty"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void checkSetModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightModifierList", "checkSetModifierProperty"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightModifierList", "getAnnotations"));
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightModifierList", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/light/LightModifierList", "findAnnotation"));
        }
        return null;
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/light/LightModifierList", "addAnnotation"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/light/LightModifierList", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitModifierList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiModifierList";
    }

    @Override
    public String getText() {
        StringBuilder buffer = new StringBuilder();
        for (String modifier : PsiModifier.MODIFIERS) {
            if (!this.hasExplicitModifier(modifier)) continue;
            buffer.append(modifier);
            buffer.append(' ');
        }
        if (buffer.length() > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        return buffer.toString();
    }

    public String[] getModifiers() {
        return ArrayUtil.toStringArray(this.myModifiers);
    }
}

