/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"checkKotlinPackageUsage", "", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin-compiler"})
public final class UtilsKt {
    public static final boolean checkKotlinPackageUsage(@NotNull KotlinCoreEnvironment environment2, @NotNull Collection<? extends KtFile> files2) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(files2, "files");
        if (environment2.getConfiguration().getBoolean(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE)) {
            return true;
        }
        MessageCollector messageCollector = environment2.getConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.NONE);
        FqName kotlinPackage = FqName.topLevel(Name.identifier("kotlin"));
        Iterable $receiver$iv = files2;
        for (Object element$iv : $receiver$iv) {
            KtFile it = (KtFile)element$iv;
            FqName fqName2 = it.getPackageFqName();
            FqName fqName3 = kotlinPackage;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "kotlinPackage");
            if (!FqNamesUtilKt.isSubpackageOf(fqName2, fqName3)) continue;
            KtPackageDirective ktPackageDirective = it.getPackageDirective();
            if (ktPackageDirective == null) {
                Intrinsics.throwNpe();
            }
            messageCollector.report(CompilerMessageSeverity.ERROR, "Only the Kotlin standard library is allowed to use the 'kotlin' package", MessageUtil.psiElementToMessageLocation(ktPackageDirective));
            return false;
        }
        return true;
    }
}

