/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.BuiltInsPackageFragment;
import org.jetbrains.kotlin.codegen.ArgumentAndDeclIndex;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.ClosureGenerationStrategy;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.FunctionReferenceGenerationStrategy;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.MultifileClassPartCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.ClosureContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.context.ScriptContext;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.coroutines.SuspendFunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.inline.CallSiteMarker;
import org.jetbrains.kotlin.codegen.inline.CapturedParamDesc;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.DefaultProcessor;
import org.jetbrains.kotlin.codegen.inline.DefaultSourceMapper;
import org.jetbrains.kotlin.codegen.inline.FictitiousArrayConstructor;
import org.jetbrains.kotlin.codegen.inline.FieldRemapper;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.InlineCacheKt;
import org.jetbrains.kotlin.codegen.inline.InlineCallSiteInfo;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.inline.InlineException;
import org.jetbrains.kotlin.codegen.inline.InlineOnlySmapSkipper;
import org.jetbrains.kotlin.codegen.inline.InlineResult;
import org.jetbrains.kotlin.codegen.inline.InliningContext;
import org.jetbrains.kotlin.codegen.inline.LabelOwner;
import org.jetbrains.kotlin.codegen.inline.LambdaInfo;
import org.jetbrains.kotlin.codegen.inline.LocalVarNodeWrapper;
import org.jetbrains.kotlin.codegen.inline.LocalVarRemapper;
import org.jetbrains.kotlin.codegen.inline.MethodBodyVisitor;
import org.jetbrains.kotlin.codegen.inline.MethodId;
import org.jetbrains.kotlin.codegen.inline.MethodInliner;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.NestedSourceMapper;
import org.jetbrains.kotlin.codegen.inline.ParameterInfo;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.codegen.inline.ParametersBuilder;
import org.jetbrains.kotlin.codegen.inline.PropertyReferenceInfo;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.RootInliningContext;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.inline.SMAPAndMethodNode;
import org.jetbrains.kotlin.codegen.inline.SMAPParser;
import org.jetbrains.kotlin.codegen.inline.SimpleInterval;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;
import org.jetbrains.kotlin.codegen.inline.TypeParameterMappings;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicArrayConstructorsKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportedFromObjectCallableDescriptor;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.LabelResolver;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

public class InlineCodegen
extends CallGenerator {
    private final GenerationState state;
    private final KotlinTypeMapper typeMapper;
    private final FunctionDescriptor functionDescriptor;
    private final JvmMethodSignature jvmSignature;
    private final KtElement callElement;
    private final MethodContext context;
    private final ExpressionCodegen codegen;
    private final boolean asFunctionInline;
    private final int initialFrameSize;
    private final boolean isSameModule;
    private final ParametersBuilder invocationParamBuilder;
    private final Map<Integer, LambdaInfo> expressionMap;
    private final ReifiedTypeInliner reifiedTypeInliner;
    @Nullable
    private final TypeParameterMappings typeParameterMappings;
    private LambdaInfo activeLambda;
    private final SourceMapper sourceMapper;
    private Runnable delayedHiddenWriting;

    public InlineCodegen(@NotNull ExpressionCodegen codegen, @NotNull GenerationState state2, @NotNull FunctionDescriptor function2, @NotNull KtElement callElement, @Nullable TypeParameterMappings typeParameterMappings) {
        if (codegen == null) {
            InlineCodegen.$$$reportNull$$$0(0);
        }
        if (state2 == null) {
            InlineCodegen.$$$reportNull$$$0(1);
        }
        if (function2 == null) {
            InlineCodegen.$$$reportNull$$$0(2);
        }
        if (callElement == null) {
            InlineCodegen.$$$reportNull$$$0(3);
        }
        this.invocationParamBuilder = ParametersBuilder.newBuilder();
        this.expressionMap = new HashMap<Integer, LambdaInfo>();
        assert (InlineUtil.isInline(function2) || InlineUtil.isArrayConstructorWithLambda(function2)) : "InlineCodegen can inline only inline functions and array constructors: " + function2;
        this.state = state2;
        this.typeMapper = state2.getTypeMapper();
        this.codegen = codegen;
        this.callElement = callElement;
        this.functionDescriptor = InlineUtil.isArrayConstructorWithLambda(function2) ? FictitiousArrayConstructor.create((ConstructorDescriptor)function2) : function2.getOriginal();
        this.typeParameterMappings = typeParameterMappings;
        this.reifiedTypeInliner = new ReifiedTypeInliner(typeParameterMappings);
        this.initialFrameSize = codegen.getFrameMap().getCurrentSize();
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(this.functionDescriptor);
        this.context = (MethodContext)InlineCodegen.getContext(this.functionDescriptor, state2, element != null ? (KtFile)element.getContainingFile() : null);
        this.jvmSignature = this.typeMapper.mapSignatureWithGeneric(this.functionDescriptor, this.context.getContextKind());
        this.asFunctionInline = false;
        this.isSameModule = JvmCodegenUtil.isCallInsideSameModuleAsDeclared(this.functionDescriptor, codegen.getContext(), state2.getOutDirectory());
        this.sourceMapper = codegen.getParentCodegen().getOrCreateSourceMapper();
        if (!(this.functionDescriptor instanceof FictitiousArrayConstructor)) {
            MemberScope scope;
            InlineCodegen.reportIncrementalInfo(this.functionDescriptor, codegen.getContext().getFunctionDescriptor().getOriginal(), this.jvmSignature, state2);
            String functionOrAccessorName = this.typeMapper.mapAsmMethod(function2).getName();
            if (!functionOrAccessorName.equals(this.functionDescriptor.getName().asString()) && (scope = InlineCodegen.getMemberScope(this.functionDescriptor)) != null) {
                scope.getContributedFunctions(Name.identifier(functionOrAccessorName), new KotlinLookupLocation(callElement));
            }
        }
    }

    @Nullable
    private static MemberScope getMemberScope(@NotNull FunctionDescriptor functionOrAccessor) {
        CallableMemberDescriptor callableMemberDescriptor;
        DeclarationDescriptor classOrPackageFragment;
        if (functionOrAccessor == null) {
            InlineCodegen.$$$reportNull$$$0(4);
        }
        if ((classOrPackageFragment = (callableMemberDescriptor = JvmCodegenUtil.getDirectMember(functionOrAccessor)).getContainingDeclaration()) instanceof ClassDescriptor) {
            return ((ClassDescriptor)classOrPackageFragment).getUnsubstitutedMemberScope();
        }
        if (classOrPackageFragment instanceof PackageFragmentDescriptor) {
            return ((PackageFragmentDescriptor)classOrPackageFragment).getMemberScope();
        }
        return null;
    }

    @Override
    public void genCallInner(@NotNull Callable callableMethod, @Nullable ResolvedCall<?> resolvedCall2, boolean callDefault, @NotNull ExpressionCodegen codegen) {
        if (callableMethod == null) {
            InlineCodegen.$$$reportNull$$$0(5);
        }
        if (codegen == null) {
            InlineCodegen.$$$reportNull$$$0(6);
        }
        if (!this.state.getInlineCycleReporter().enterIntoInlining(resolvedCall2)) {
            this.generateStub(resolvedCall2, codegen);
            return;
        }
        SMAPAndMethodNode nodeAndSmap = null;
        try {
            nodeAndSmap = InlineCodegen.createMethodNode(this.functionDescriptor, this.jvmSignature, codegen, this.context, callDefault, resolvedCall2);
            this.endCall(this.inlineCall(nodeAndSmap));
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (InlineException e) {
            throw this.throwCompilationException(nodeAndSmap, e, false);
        }
        catch (Exception e) {
            throw this.throwCompilationException(nodeAndSmap, e, true);
        }
        finally {
            this.state.getInlineCycleReporter().exitFromInliningOf(resolvedCall2);
        }
    }

    @NotNull
    private CompilationException throwCompilationException(@Nullable SMAPAndMethodNode nodeAndSmap, @NotNull Exception e, boolean generateNodeText) {
        if (e == null) {
            InlineCodegen.$$$reportNull$$$0(7);
        }
        CallableMemberDescriptor contextDescriptor = (CallableMemberDescriptor)this.codegen.getContext().getContextDescriptor();
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(contextDescriptor);
        MethodNode node = nodeAndSmap != null ? nodeAndSmap.getNode() : null;
        throw new CompilationException("Couldn't inline method call '" + this.functionDescriptor.getName() + "' into\n" + DescriptorRenderer.DEBUG_TEXT.render(contextDescriptor) + "\n" + (element != null ? element.getText() : "<no source>") + (generateNodeText ? "\nCause: " + InlineCodegenUtil.getNodeText(node) : ""), e, this.callElement);
    }

    private void generateStub(@Nullable ResolvedCall<?> resolvedCall2, @NotNull ExpressionCodegen codegen) {
        if (codegen == null) {
            InlineCodegen.$$$reportNull$$$0(8);
        }
        this.leaveTemps();
        assert (resolvedCall2 != null);
        String message = "Call is part of inline cycle: " + resolvedCall2.getCall().getCallElement().getText();
        AsmUtil.genThrow(codegen.v, "java/lang/UnsupportedOperationException", message);
    }

    private void endCall(@NotNull InlineResult result2) {
        if (result2 == null) {
            InlineCodegen.$$$reportNull$$$0(9);
        }
        this.leaveTemps();
        this.codegen.propagateChildReifiedTypeParametersUsages(result2.getReifiedTypeParametersUsages());
        this.state.getFactory().removeClasses(result2.calcClassesToRemove());
        this.codegen.markLineNumberAfterInlineIfNeeded();
    }

    @NotNull
    static SMAPAndMethodNode createMethodNode(final @NotNull FunctionDescriptor functionDescriptor, @NotNull JvmMethodSignature jvmSignature, @NotNull ExpressionCodegen codegen, @NotNull CodegenContext context, boolean callDefault, @Nullable ResolvedCall<?> resolvedCall2) {
        if (functionDescriptor == null) {
            InlineCodegen.$$$reportNull$$$0(10);
        }
        if (jvmSignature == null) {
            InlineCodegen.$$$reportNull$$$0(11);
        }
        if (codegen == null) {
            InlineCodegen.$$$reportNull$$$0(12);
        }
        if (context == null) {
            InlineCodegen.$$$reportNull$$$0(13);
        }
        if (InlineCodegenUtil.isSpecialEnumMethod(functionDescriptor)) {
            assert (resolvedCall2 != null) : "Resolved call for " + functionDescriptor + " should be not null";
            Map<TypeParameterDescriptor, KotlinType> arguments2 = resolvedCall2.getTypeArguments();
            assert (arguments2.size() == 1) : "Resolved call for " + functionDescriptor + " should have 1 type argument";
            MethodNode node = InlineCodegenUtil.createSpecialEnumMethodBody(codegen, functionDescriptor.getName().asString(), arguments2.keySet().iterator().next().getDefaultType(), codegen.getState().getTypeMapper());
            SMAPAndMethodNode sMAPAndMethodNode = new SMAPAndMethodNode(node, SMAPParser.parseOrCreateDefault(null, null, "fake", -1, -1));
            if (sMAPAndMethodNode == null) {
                InlineCodegen.$$$reportNull$$$0(14);
            }
            return sMAPAndMethodNode;
        }
        if (CoroutineCodegenUtilKt.isBuiltInSuspendCoroutineOrReturnInJvm(functionDescriptor)) {
            SMAPAndMethodNode sMAPAndMethodNode = new SMAPAndMethodNode(CoroutineCodegenUtilKt.createMethodNodeForSuspendCoroutineOrReturn(functionDescriptor, codegen.getState().getTypeMapper()), SMAPParser.parseOrCreateDefault(null, null, "fake", -1, -1));
            if (sMAPAndMethodNode == null) {
                InlineCodegen.$$$reportNull$$$0(15);
            }
            return sMAPAndMethodNode;
        }
        final GenerationState state2 = codegen.getState();
        final Method asmMethod = callDefault ? state2.getTypeMapper().mapDefaultMethod(functionDescriptor, context.getContextKind()) : jvmSignature.getAsmMethod();
        MethodId methodId = new MethodId(DescriptorUtils.getFqNameSafe(functionDescriptor.getContainingDeclaration()), asmMethod);
        final CallableMemberDescriptor directMember = InlineCodegen.getDirectMemberAndCallableFromObject(functionDescriptor);
        if (!InlineCodegen.isBuiltInArrayIntrinsic(functionDescriptor) && !(directMember instanceof DeserializedCallableMemberDescriptor)) {
            SMAPAndMethodNode sMAPAndMethodNode = InlineCodegen.doCreateMethodNodeFromSource(functionDescriptor, jvmSignature, codegen, context, callDefault, state2, asmMethod);
            if (sMAPAndMethodNode == null) {
                InlineCodegen.$$$reportNull$$$0(16);
            }
            return sMAPAndMethodNode;
        }
        SMAPAndMethodNode resultInCache = InlineCacheKt.getOrPut(state2.getInlineCache().getMethodNodeById(), methodId, new Function0<SMAPAndMethodNode>(){

            @Override
            public SMAPAndMethodNode invoke() {
                SMAPAndMethodNode result2 = InlineCodegen.doCreateMethodNodeFromCompiled(directMember, state2, asmMethod);
                if (result2 == null) {
                    throw new IllegalStateException("Couldn't obtain compiled function body for " + functionDescriptor);
                }
                return result2;
            }
        });
        SMAPAndMethodNode sMAPAndMethodNode = resultInCache.copyWithNewNode(InlineCodegen.cloneMethodNode(resultInCache.getNode()));
        if (sMAPAndMethodNode == null) {
            InlineCodegen.$$$reportNull$$$0(17);
        }
        return sMAPAndMethodNode;
    }

    @NotNull
    private static CallableMemberDescriptor getDirectMemberAndCallableFromObject(@NotNull FunctionDescriptor functionDescriptor) {
        CallableMemberDescriptor directMember;
        if (functionDescriptor == null) {
            InlineCodegen.$$$reportNull$$$0(18);
        }
        if ((directMember = JvmCodegenUtil.getDirectMember(functionDescriptor)) instanceof ImportedFromObjectCallableDescriptor) {
            Object TCallable = ((ImportedFromObjectCallableDescriptor)((Object)directMember)).getCallableFromObject();
            if (TCallable == null) {
                InlineCodegen.$$$reportNull$$$0(19);
            }
            return TCallable;
        }
        CallableMemberDescriptor callableMemberDescriptor = directMember;
        if (callableMemberDescriptor == null) {
            InlineCodegen.$$$reportNull$$$0(20);
        }
        return callableMemberDescriptor;
    }

    @NotNull
    private static MethodNode cloneMethodNode(@NotNull MethodNode methodNode) {
        if (methodNode == null) {
            InlineCodegen.$$$reportNull$$$0(21);
        }
        methodNode.instructions.resetLabels();
        MethodNode result2 = new MethodNode(327680, methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, ArrayUtil.toStringArray(methodNode.exceptions));
        methodNode.accept(result2);
        MethodNode methodNode2 = result2;
        if (methodNode2 == null) {
            InlineCodegen.$$$reportNull$$$0(22);
        }
        return methodNode2;
    }

    @Nullable
    private static SMAPAndMethodNode doCreateMethodNodeFromCompiled(@NotNull CallableMemberDescriptor callableDescriptor, final @NotNull GenerationState state2, @NotNull Method asmMethod) {
        if (callableDescriptor == null) {
            InlineCodegen.$$$reportNull$$$0(23);
        }
        if (state2 == null) {
            InlineCodegen.$$$reportNull$$$0(24);
        }
        if (asmMethod == null) {
            InlineCodegen.$$$reportNull$$$0(25);
        }
        if (InlineCodegen.isBuiltInArrayIntrinsic(callableDescriptor)) {
            ClassId classId = IntrinsicArrayConstructorsKt.getClassId();
            byte[] bytes = InlineCacheKt.getOrPut(state2.getInlineCache().getClassBytes(), classId, new Function0<byte[]>(){

                @Override
                public byte[] invoke() {
                    return IntrinsicArrayConstructorsKt.getBytecode();
                }
            });
            return InlineCodegenUtil.getMethodNode(bytes, asmMethod.getName(), asmMethod.getDescriptor(), classId);
        }
        assert (callableDescriptor instanceof DeserializedCallableMemberDescriptor) : "Not a deserialized function or proper: " + callableDescriptor;
        KotlinTypeMapper.ContainingClassesInfo containingClasses = state2.getTypeMapper().getContainingClassesForDeserializedCallable((DeserializedCallableMemberDescriptor)callableDescriptor);
        final ClassId containerId = containingClasses.getImplClassId();
        byte[] bytes = InlineCacheKt.getOrPut(state2.getInlineCache().getClassBytes(), containerId, new Function0<byte[]>(){

            @Override
            public byte[] invoke() {
                VirtualFile file2 = InlineCodegenUtil.findVirtualFile(state2, containerId);
                if (file2 == null) {
                    throw new IllegalStateException("Couldn't find declaration file for " + containerId);
                }
                try {
                    return file2.contentsToByteArray();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return InlineCodegenUtil.getMethodNode(bytes, asmMethod.getName(), asmMethod.getDescriptor(), containerId);
    }

    @NotNull
    private static SMAPAndMethodNode doCreateMethodNodeFromSource(@NotNull FunctionDescriptor callableDescriptor, @NotNull JvmMethodSignature jvmSignature, @NotNull ExpressionCodegen codegen, @NotNull CodegenContext context, boolean callDefault, @NotNull GenerationState state2, @NotNull Method asmMethod) {
        SMAP smap;
        PsiElement element;
        if (callableDescriptor == null) {
            InlineCodegen.$$$reportNull$$$0(26);
        }
        if (jvmSignature == null) {
            InlineCodegen.$$$reportNull$$$0(27);
        }
        if (codegen == null) {
            InlineCodegen.$$$reportNull$$$0(28);
        }
        if (context == null) {
            InlineCodegen.$$$reportNull$$$0(29);
        }
        if (state2 == null) {
            InlineCodegen.$$$reportNull$$$0(30);
        }
        if (asmMethod == null) {
            InlineCodegen.$$$reportNull$$$0(31);
        }
        if (!((element = DescriptorToSourceUtils.descriptorToDeclaration(callableDescriptor)) instanceof KtNamedFunction) && !(element instanceof KtPropertyAccessor)) {
            throw new IllegalStateException("Couldn't find declaration for function " + callableDescriptor);
        }
        KtDeclarationWithBody inliningFunction = (KtDeclarationWithBody)element;
        MethodNode node = new MethodNode(327680, AsmUtil.getMethodAsmFlags(callableDescriptor, context.getContextKind(), state2) | (callDefault ? 8 : 0), asmMethod.getName(), asmMethod.getDescriptor(), null, null);
        MethodVisitor maxCalcAdapter = InlineCodegenUtil.wrapWithMaxLocalCalc(node);
        CodegenContext parentContext = context.getParentContext();
        assert (parentContext != null) : "Context has no parent: " + context;
        MethodContext methodContext = parentContext.intoFunction(callableDescriptor);
        if (callDefault) {
            Type implementationOwner = state2.getTypeMapper().mapImplementationOwner(callableDescriptor);
            FakeMemberCodegen parentCodegen = new FakeMemberCodegen(codegen.getParentCodegen(), inliningFunction, (FieldOwnerContext)methodContext.getParentContext(), implementationOwner.getInternalName());
            if (!(element instanceof KtNamedFunction)) {
                throw new IllegalStateException("Propertiy accessors with default parameters not supported " + callableDescriptor);
            }
            FunctionCodegen.generateDefaultImplBody(methodContext, callableDescriptor, maxCalcAdapter, DefaultParameterValueLoader.DEFAULT, (KtNamedFunction)inliningFunction, parentCodegen, asmMethod);
            smap = InlineCodegen.createSMAPWithDefaultMapping(inliningFunction, parentCodegen.getOrCreateSourceMapper().getResultMappings());
        } else {
            smap = InlineCodegen.generateMethodBody(maxCalcAdapter, callableDescriptor, methodContext, inliningFunction, jvmSignature, codegen, null);
        }
        maxCalcAdapter.visitMaxs(-1, -1);
        maxCalcAdapter.visitEnd();
        SMAPAndMethodNode sMAPAndMethodNode = new SMAPAndMethodNode(node, smap);
        if (sMAPAndMethodNode == null) {
            InlineCodegen.$$$reportNull$$$0(32);
        }
        return sMAPAndMethodNode;
    }

    private static boolean isBuiltInArrayIntrinsic(@NotNull CallableMemberDescriptor callableDescriptor) {
        if (callableDescriptor == null) {
            InlineCodegen.$$$reportNull$$$0(33);
        }
        if (callableDescriptor instanceof FictitiousArrayConstructor) {
            return true;
        }
        String name = callableDescriptor.getName().asString();
        return (name.equals("arrayOf") || name.equals("emptyArray")) && callableDescriptor.getContainingDeclaration() instanceof BuiltInsPackageFragment;
    }

    @NotNull
    private InlineResult inlineCall(@NotNull SMAPAndMethodNode nodeAndSmap) {
        if (nodeAndSmap == null) {
            InlineCodegen.$$$reportNull$$$0(34);
        }
        assert (this.delayedHiddenWriting == null) : "'putHiddenParamsIntoLocals' should be called after 'processAndPutHiddenParameters(true)'";
        DefaultSourceMapper defaultSourceMapper = this.codegen.getParentCodegen().getOrCreateSourceMapper();
        defaultSourceMapper.setCallSiteMarker(new CallSiteMarker(this.codegen.getLastLineNumber()));
        MethodNode node = nodeAndSmap.getNode();
        ReifiedTypeParametersUsages reificationResult = this.reifiedTypeInliner.reifyInstructions(node);
        this.generateClosuresBodies();
        this.putClosureParametersOnStack();
        InlineCodegenUtil.addInlineMarker(this.codegen.v, true);
        Parameters parameters2 = this.invocationParamBuilder.buildParameters();
        RootInliningContext info = new RootInliningContext(this.expressionMap, this.state, this.codegen.getInlineNameGenerator().subGenerator(this.jvmSignature.getAsmMethod().getName()), this.callElement, this.getInlineCallSiteInfo(), this.reifiedTypeInliner, this.typeParameterMappings);
        MethodInliner inliner = new MethodInliner(node, parameters2, info, new FieldRemapper(null, null, parameters2), this.isSameModule, "Method inlining " + this.callElement.getText(), InlineCodegen.createNestedSourceMapper(nodeAndSmap, this.sourceMapper), ((InliningContext)info).getCallSiteInfo(), AnnotationUtilKt.isInlineOnly(this.functionDescriptor) ? new InlineOnlySmapSkipper(this.codegen) : null);
        LocalVarRemapper remapper = new LocalVarRemapper(parameters2, this.initialFrameSize);
        MethodNode adapter = InlineCodegenUtil.createEmptyMethodNode();
        adapter.visitInsn(0);
        InlineResult result2 = inliner.doInline(adapter, remapper, true, LabelOwner.SKIP_ALL);
        result2.getReifiedTypeParametersUsages().mergeAll(reificationResult);
        CallableMemberDescriptor descriptor2 = InlineCodegen.getLabelOwnerDescriptor(this.codegen.getContext());
        final Set<String> labels = InlineCodegen.getDeclarationLabels(DescriptorToSourceUtils.descriptorToDeclaration(descriptor2), descriptor2);
        LabelOwner labelOwner = new LabelOwner(){

            @Override
            public boolean isMyLabel(@NotNull String name) {
                if (name == null) {
                    4.$$$reportNull$$$0(0);
                }
                return labels.contains(name);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$4", "isMyLabel"));
            }
        };
        List<MethodInliner.PointForExternalFinallyBlocks> infos = MethodInliner.processReturns(adapter, labelOwner, true, null);
        this.generateAndInsertFinallyBlocks(adapter, infos, ((StackValue.Local)remapper.remap((int)(parameters2.getArgsSizeOnStack() + 1)).value).index);
        InlineCodegen.removeStaticInitializationTrigger(adapter);
        if (!InlineCodegenUtil.isFinallyMarkerRequired(this.codegen.getContext())) {
            InlineCodegenUtil.removeFinallyMarkers(adapter);
        }
        adapter.accept(new MethodBodyVisitor(this.codegen.v));
        InlineCodegenUtil.addInlineMarker(this.codegen.v, false);
        defaultSourceMapper.setCallSiteMarker(null);
        InlineResult inlineResult = result2;
        if (inlineResult == null) {
            InlineCodegen.$$$reportNull$$$0(35);
        }
        return inlineResult;
    }

    @NotNull
    private static CallableMemberDescriptor getLabelOwnerDescriptor(@NotNull MethodContext context) {
        if (context == null) {
            InlineCodegen.$$$reportNull$$$0(36);
        }
        if (context.getParentContext() instanceof ClosureContext && ((ClosureContext)context.getParentContext()).getOriginalSuspendLambdaDescriptor() != null) {
            FunctionDescriptor functionDescriptor = ((ClosureContext)context.getParentContext()).getOriginalSuspendLambdaDescriptor();
            if (functionDescriptor == null) {
                InlineCodegen.$$$reportNull$$$0(37);
            }
            return functionDescriptor;
        }
        CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)context.getContextDescriptor();
        if (callableMemberDescriptor == null) {
            InlineCodegen.$$$reportNull$$$0(38);
        }
        return callableMemberDescriptor;
    }

    private static void removeStaticInitializationTrigger(@NotNull MethodNode methodNode) {
        if (methodNode == null) {
            InlineCodegen.$$$reportNull$$$0(39);
        }
        InsnList insnList = methodNode.instructions;
        AbstractInsnNode insn = insnList.getFirst();
        while (insn != null) {
            if (MultifileClassPartCodegen.isStaticInitTrigger(insn)) {
                AbstractInsnNode clinitTriggerCall = insn;
                insn = insn.getNext();
                insnList.remove(clinitTriggerCall);
                continue;
            }
            insn = insn.getNext();
        }
    }

    @NotNull
    private InlineCallSiteInfo getInlineCallSiteInfo() {
        MethodContext context = this.codegen.getContext();
        MemberCodegen parentCodegen = this.codegen.getParentCodegen();
        while (context instanceof InlineLambdaContext) {
            CodegenContext closureContext = context.getParentContext();
            assert (closureContext instanceof ClosureContext) : "Parent context of inline lambda should be closure context";
            assert (closureContext.getParentContext() instanceof MethodContext) : "Closure context should appear in method context";
            context = (MethodContext)closureContext.getParentContext();
            assert (parentCodegen instanceof FakeMemberCodegen) : "Parent codegen of inlined lambda should be FakeMemberCodegen";
            parentCodegen = ((FakeMemberCodegen)parentCodegen).delegate;
        }
        JvmMethodSignature signature = this.typeMapper.mapSignatureSkipGeneric(context.getFunctionDescriptor(), context.getContextKind());
        InlineCallSiteInfo inlineCallSiteInfo = new InlineCallSiteInfo(parentCodegen.getClassName(), signature.getAsmMethod().getName(), signature.getAsmMethod().getDescriptor());
        if (inlineCallSiteInfo == null) {
            InlineCodegen.$$$reportNull$$$0(40);
        }
        return inlineCallSiteInfo;
    }

    private void generateClosuresBodies() {
        for (LambdaInfo info : this.expressionMap.values()) {
            info.setNode(this.generateLambdaBody(info));
        }
    }

    @NotNull
    private SMAPAndMethodNode generateLambdaBody(@NotNull LambdaInfo info) {
        if (info == null) {
            InlineCodegen.$$$reportNull$$$0(41);
        }
        KtExpression declaration = info.getFunctionWithBodyOrCallableReference();
        FunctionDescriptor descriptor2 = info.getFunctionDescriptor();
        ClassContext closureContext = info.isPropertyReference() ? this.codegen.getContext().intoAnonymousClass(info.getClassDescriptor(), this.codegen, OwnerKind.IMPLEMENTATION) : this.codegen.getContext().intoClosure(descriptor2, this.codegen, this.typeMapper);
        MethodContext context = closureContext.intoInlinedLambda(descriptor2, info.isCrossInline, info.isPropertyReference());
        JvmMethodSignature jvmMethodSignature = this.typeMapper.mapSignatureSkipGeneric(descriptor2);
        Method asmMethod = jvmMethodSignature.getAsmMethod();
        MethodNode methodNode = new MethodNode(327680, AsmUtil.getMethodAsmFlags(descriptor2, context.getContextKind(), this.state), asmMethod.getName(), asmMethod.getDescriptor(), null, null);
        MethodVisitor adapter = InlineCodegenUtil.wrapWithMaxLocalCalc(methodNode);
        SMAP smap = InlineCodegen.generateMethodBody(adapter, descriptor2, context, declaration, jvmMethodSignature, this.codegen, info);
        adapter.visitMaxs(-1, -1);
        SMAPAndMethodNode sMAPAndMethodNode = new SMAPAndMethodNode(methodNode, smap);
        if (sMAPAndMethodNode == null) {
            InlineCodegen.$$$reportNull$$$0(42);
        }
        return sMAPAndMethodNode;
    }

    @NotNull
    private static SMAP generateMethodBody(@NotNull MethodVisitor adapter, @NotNull FunctionDescriptor descriptor2, @NotNull MethodContext context, @NotNull KtExpression expression, @NotNull JvmMethodSignature jvmMethodSignature, @NotNull ExpressionCodegen codegen, @Nullable LambdaInfo lambdaInfo) {
        FunctionGenerationStrategy.CodegenBased strategy;
        if (adapter == null) {
            InlineCodegen.$$$reportNull$$$0(43);
        }
        if (descriptor2 == null) {
            InlineCodegen.$$$reportNull$$$0(44);
        }
        if (context == null) {
            InlineCodegen.$$$reportNull$$$0(45);
        }
        if (expression == null) {
            InlineCodegen.$$$reportNull$$$0(46);
        }
        if (jvmMethodSignature == null) {
            InlineCodegen.$$$reportNull$$$0(47);
        }
        if (codegen == null) {
            InlineCodegen.$$$reportNull$$$0(48);
        }
        boolean isLambda = lambdaInfo != null;
        GenerationState state2 = codegen.getState();
        FakeMemberCodegen parentCodegen = new FakeMemberCodegen(codegen.getParentCodegen(), expression, (FieldOwnerContext)context.getParentContext(), isLambda ? codegen.getParentCodegen().getClassName() : state2.getTypeMapper().mapImplementationOwner(descriptor2).getInternalName());
        if (expression instanceof KtCallableReferenceExpression) {
            Type receiverType;
            KtCallableReferenceExpression callableReferenceExpression = (KtCallableReferenceExpression)expression;
            KtExpression receiverExpression = callableReferenceExpression.getReceiverExpression();
            Type type2 = receiverType = receiverExpression != null && codegen.getBindingContext().getType(receiverExpression) != null ? codegen.getState().getTypeMapper().mapType(codegen.getBindingContext().getType(receiverExpression)) : null;
            if (isLambda && lambdaInfo.isPropertyReference()) {
                Type asmType = state2.getTypeMapper().mapClass(lambdaInfo.getClassDescriptor());
                PropertyReferenceInfo info = lambdaInfo.getPropertyReferenceInfo();
                strategy = new PropertyReferenceCodegen.PropertyReferenceGenerationStrategy(true, info.getGetFunction(), info.getTarget(), asmType, receiverType, lambdaInfo.expression, state2, true);
            } else {
                strategy = new FunctionReferenceGenerationStrategy(state2, descriptor2, CallUtilKt.getResolvedCallWithAssert(callableReferenceExpression.getCallableReference(), codegen.getBindingContext()), receiverType, null, true);
            }
        } else {
            strategy = expression instanceof KtFunctionLiteral ? new ClosureGenerationStrategy(state2, (KtDeclarationWithBody)expression) : (descriptor2.isSuspend() && expression instanceof KtFunction ? new SuspendFunctionGenerationStrategy(state2, CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(descriptor2), (KtFunction)expression) : new FunctionGenerationStrategy.FunctionDefault(state2, (KtDeclarationWithBody)expression));
        }
        FunctionCodegen.generateMethodBody(adapter, descriptor2, context, jvmMethodSignature, strategy, parentCodegen);
        if (isLambda) {
            codegen.propagateChildReifiedTypeParametersUsages(parentCodegen.getReifiedTypeParametersUsages());
        }
        SMAP sMAP = InlineCodegen.createSMAPWithDefaultMapping(expression, parentCodegen.getOrCreateSourceMapper().getResultMappings());
        if (sMAP == null) {
            InlineCodegen.$$$reportNull$$$0(49);
        }
        return sMAP;
    }

    private static SMAP createSMAPWithDefaultMapping(@NotNull KtExpression declaration, @NotNull List<FileMapping> mappings) {
        if (declaration == null) {
            InlineCodegen.$$$reportNull$$$0(50);
        }
        if (mappings == null) {
            InlineCodegen.$$$reportNull$$$0(51);
        }
        PsiFile containingFile = declaration.getContainingFile();
        Integer lineNumbers = CodegenUtil.getLineNumberForElement(containingFile, true);
        assert (lineNumbers != null) : "Couldn't extract line count in " + containingFile;
        return new SMAP(mappings);
    }

    @Override
    public void afterParameterPut(@NotNull Type type2, @Nullable StackValue stackValue, int parameterIndex) {
        if (type2 == null) {
            InlineCodegen.$$$reportNull$$$0(52);
        }
        this.putArgumentOrCapturedToLocalVal(type2, stackValue, -1, parameterIndex);
    }

    private void putArgumentOrCapturedToLocalVal(@NotNull Type type2, @Nullable StackValue stackValue, int capturedParamIndex, int parameterIndex) {
        if (type2 == null) {
            InlineCodegen.$$$reportNull$$$0(53);
        }
        if (!this.asFunctionInline && Type.VOID_TYPE != type2) {
            ParameterInfo info;
            StackValue remappedValue;
            boolean couldBeRemapped = !InlineCodegen.shouldPutValue(type2, stackValue);
            StackValue stackValue2 = remappedValue = couldBeRemapped ? stackValue : null;
            if (capturedParamIndex >= 0) {
                CapturedParamDesc capturedParamInfoInLambda = this.activeLambda.getCapturedVars().get(capturedParamIndex);
                info = this.invocationParamBuilder.addCapturedParam(capturedParamInfoInLambda, capturedParamInfoInLambda.getFieldName(), false);
                info.setRemapValue(remappedValue);
            } else {
                info = this.invocationParamBuilder.addNextValueParameter(type2, false, remappedValue, parameterIndex);
            }
            this.recordParameterValueInLocalVal(false, info);
        }
    }

    private static boolean shouldPutValue(@NotNull Type type2, @Nullable StackValue stackValue) {
        if (type2 == null) {
            InlineCodegen.$$$reportNull$$$0(54);
        }
        if (stackValue == null) {
            return true;
        }
        if (AsmUtil.isPrimitive(type2) != AsmUtil.isPrimitive(stackValue.type)) {
            return true;
        }
        if (stackValue instanceof StackValue.Local) {
            return false;
        }
        StackValue field = stackValue;
        if (stackValue instanceof StackValue.FieldForSharedVar) {
            field = ((StackValue.FieldForSharedVar)stackValue).receiver;
        }
        if (field instanceof StackValue.Field) {
            DeclarationDescriptor varDescriptor = ((StackValue.Field)field).descriptor;
            return !(varDescriptor instanceof ParameterDescriptor) || !InlineUtil.isInlineLambdaParameter((ParameterDescriptor)varDescriptor) || !InlineUtil.isInline(varDescriptor.getContainingDeclaration());
        }
        return true;
    }

    private Runnable recordParameterValueInLocalVal(boolean delayedWritingToLocals, final ParameterInfo ... infos) {
        if (infos == null) {
            InlineCodegen.$$$reportNull$$$0(55);
        }
        final int[] index2 = new int[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            ParameterInfo info = infos[i];
            index2[i] = !info.isSkippedOrRemapped() ? this.codegen.getFrameMap().enterTemp(info.getType()) : -1;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (int i = infos.length - 1; i >= 0; --i) {
                    ParameterInfo info = infos[i];
                    if (info.isSkippedOrRemapped()) continue;
                    Type type2 = info.type;
                    StackValue.Local local = StackValue.local(index2[i], type2);
                    local.store(StackValue.onStack(type2), ((InlineCodegen)InlineCodegen.this).codegen.v);
                    if (!(info instanceof CapturedParamInfo)) continue;
                    info.setRemapValue(local);
                    ((CapturedParamInfo)info).setSynthetic(true);
                }
            }
        };
        if (delayedWritingToLocals) {
            return runnable;
        }
        runnable.run();
        return null;
    }

    @Override
    public void processAndPutHiddenParameters(boolean justProcess) {
        if ((AsmUtil.getMethodAsmFlags(this.functionDescriptor, this.context.getContextKind(), this.state) & 8) == 0) {
            this.invocationParamBuilder.addNextParameter(AsmTypes.OBJECT_TYPE, false);
        }
        for (JvmMethodParameterSignature param : this.jvmSignature.getValueParameters()) {
            if (param.getKind() == JvmMethodParameterKind.VALUE) break;
            this.invocationParamBuilder.addNextParameter(param.getAsmType(), false);
        }
        this.invocationParamBuilder.markValueParametersStart();
        List<ParameterInfo> hiddenParameters = this.invocationParamBuilder.buildParameters().getParameters();
        this.delayedHiddenWriting = this.recordParameterValueInLocalVal(justProcess, hiddenParameters.toArray(new ParameterInfo[hiddenParameters.size()]));
    }

    private void leaveTemps() {
        List<ParameterInfo> infos = this.invocationParamBuilder.listAllParams();
        ListIterator<ParameterInfo> iterator2 = infos.listIterator(infos.size());
        while (iterator2.hasPrevious()) {
            ParameterInfo param = iterator2.previous();
            if (param.isSkippedOrRemapped() && !CapturedParamInfo.isSynthetic(param)) continue;
            this.codegen.getFrameMap().leaveTemp(param.type);
        }
    }

    private static boolean isInliningParameter(@NotNull KtExpression expression, @NotNull ValueParameterDescriptor valueParameterDescriptor) {
        if (expression == null) {
            InlineCodegen.$$$reportNull$$$0(56);
        }
        if (valueParameterDescriptor == null) {
            InlineCodegen.$$$reportNull$$$0(57);
        }
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(expression);
        return InlineUtil.isInlineLambdaParameter(valueParameterDescriptor) && InlineCodegen.isInlinableParameterExpression(deparenthesized);
    }

    private static boolean isInlinableParameterExpression(@Nullable KtExpression deparenthesized) {
        return deparenthesized instanceof KtLambdaExpression || deparenthesized instanceof KtNamedFunction || deparenthesized instanceof KtCallableReferenceExpression;
    }

    private LambdaInfo rememberClosure(@NotNull KtExpression expression, @NotNull Type type2, @NotNull ValueParameterDescriptor parameter) {
        if (expression == null) {
            InlineCodegen.$$$reportNull$$$0(58);
        }
        if (type2 == null) {
            InlineCodegen.$$$reportNull$$$0(59);
        }
        if (parameter == null) {
            InlineCodegen.$$$reportNull$$$0(60);
        }
        KtExpression lambda2 = KtPsiUtil.deparenthesize(expression);
        assert (InlineCodegen.isInlinableParameterExpression(lambda2)) : "Couldn't find inline expression in " + expression.getText();
        LambdaInfo info = new LambdaInfo(lambda2, this.typeMapper, parameter.isCrossinline(), this.getBoundCallableReferenceReceiver(expression) != null);
        ParameterInfo closureInfo = this.invocationParamBuilder.addNextValueParameter(type2, true, null, parameter.getIndex());
        closureInfo.setLambda(info);
        this.expressionMap.put(closureInfo.getIndex(), info);
        return info;
    }

    @NotNull
    public static Set<String> getDeclarationLabels(@Nullable PsiElement lambdaOrFun, @NotNull DeclarationDescriptor descriptor2) {
        Name label;
        if (descriptor2 == null) {
            InlineCodegen.$$$reportNull$$$0(61);
        }
        HashSet<String> result2 = new HashSet<String>();
        if (lambdaOrFun != null && (label = LabelResolver.INSTANCE.getLabelNameIfAny(lambdaOrFun)) != null) {
            result2.add(label.asString());
        }
        if (!ExpressionTypingUtils.isFunctionLiteral(descriptor2)) {
            if (!descriptor2.getName().isSpecial()) {
                result2.add(descriptor2.getName().asString());
            }
            result2.add("$$$$$ROOT$$$$$");
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            InlineCodegen.$$$reportNull$$$0(62);
        }
        return hashSet;
    }

    private void putClosureParametersOnStack() {
        for (LambdaInfo next : this.expressionMap.values()) {
            if (next.isBoundCallableReference()) continue;
            this.putClosureParametersOnStack(next, null);
        }
    }

    private void putClosureParametersOnStack(@NotNull LambdaInfo next, @Nullable StackValue functionReferenceReceiver) {
        if (next == null) {
            InlineCodegen.$$$reportNull$$$0(63);
        }
        this.activeLambda = next;
        this.codegen.pushClosureOnStack(next.getClassDescriptor(), true, this, functionReferenceReceiver);
        this.activeLambda = null;
    }

    @NotNull
    public static CodegenContext getContext(@NotNull DeclarationDescriptor descriptor2, @NotNull GenerationState state2, @Nullable KtFile sourceFile) {
        if (descriptor2 == null) {
            InlineCodegen.$$$reportNull$$$0(64);
        }
        if (state2 == null) {
            InlineCodegen.$$$reportNull$$$0(65);
        }
        if (descriptor2 instanceof PackageFragmentDescriptor) {
            PackageContext packageContext = new PackageContext((PackageFragmentDescriptor)descriptor2, state2.getRootContext(), null, sourceFile);
            if (packageContext == null) {
                InlineCodegen.$$$reportNull$$$0(66);
            }
            return packageContext;
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        assert (container2 != null) : "No container for descriptor: " + descriptor2;
        CodegenContext parent2 = InlineCodegen.getContext(container2, state2, sourceFile);
        if (descriptor2 instanceof ScriptDescriptor) {
            List<ScriptDescriptor> earlierScripts = state2.getReplSpecific().getEarlierScriptsForReplInterpreter();
            ScriptContext scriptContext = parent2.intoScript((ScriptDescriptor)descriptor2, earlierScripts == null ? Collections.emptyList() : earlierScripts, (ClassDescriptor)descriptor2, state2.getTypeMapper());
            if (scriptContext == null) {
                InlineCodegen.$$$reportNull$$$0(67);
            }
            return scriptContext;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            OwnerKind kind = DescriptorUtils.isInterface(descriptor2) ? OwnerKind.DEFAULT_IMPLS : OwnerKind.IMPLEMENTATION;
            ClassContext classContext = parent2.intoClass((ClassDescriptor)descriptor2, kind, state2);
            if (classContext == null) {
                InlineCodegen.$$$reportNull$$$0(68);
            }
            return classContext;
        }
        if (descriptor2 instanceof FunctionDescriptor) {
            MethodContext methodContext = parent2.intoFunction((FunctionDescriptor)descriptor2);
            if (methodContext == null) {
                InlineCodegen.$$$reportNull$$$0(69);
            }
            return methodContext;
        }
        throw new IllegalStateException("Couldn't build context for " + descriptor2);
    }

    @Override
    public void genValueAndPut(@NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull KtExpression argumentExpression, @NotNull Type parameterType, int parameterIndex) {
        if (valueParameterDescriptor == null) {
            InlineCodegen.$$$reportNull$$$0(70);
        }
        if (argumentExpression == null) {
            InlineCodegen.$$$reportNull$$$0(71);
        }
        if (parameterType == null) {
            InlineCodegen.$$$reportNull$$$0(72);
        }
        if (InlineCodegen.isInliningParameter(argumentExpression, valueParameterDescriptor)) {
            LambdaInfo lambdaInfo = this.rememberClosure(argumentExpression, parameterType, valueParameterDescriptor);
            KtExpression receiver = this.getBoundCallableReferenceReceiver(argumentExpression);
            if (receiver != null) {
                this.putClosureParametersOnStack(lambdaInfo, this.codegen.gen(receiver));
            }
        } else {
            StackValue value = this.codegen.gen(argumentExpression);
            this.putValueIfNeeded(parameterType, value, valueParameterDescriptor.getIndex());
        }
    }

    private KtExpression getBoundCallableReferenceReceiver(@NotNull KtExpression argumentExpression) {
        DoubleColonLHS lhs;
        KtExpression receiverExpression;
        KtExpression deparenthesized;
        if (argumentExpression == null) {
            InlineCodegen.$$$reportNull$$$0(73);
        }
        if ((deparenthesized = KtPsiUtil.deparenthesize(argumentExpression)) instanceof KtCallableReferenceExpression && (receiverExpression = ((KtCallableReferenceExpression)deparenthesized).getReceiverExpression()) != null && (lhs = this.state.getBindingContext().get(BindingContext.DOUBLE_COLON_LHS, receiverExpression)) instanceof DoubleColonLHS.Expression) {
            return receiverExpression;
        }
        return null;
    }

    @Override
    public void putValueIfNeeded(@NotNull Type parameterType, @NotNull StackValue value) {
        if (parameterType == null) {
            InlineCodegen.$$$reportNull$$$0(74);
        }
        if (value == null) {
            InlineCodegen.$$$reportNull$$$0(75);
        }
        this.putValueIfNeeded(parameterType, value, -1);
    }

    private void putValueIfNeeded(@NotNull Type parameterType, @NotNull StackValue value, int index2) {
        if (parameterType == null) {
            InlineCodegen.$$$reportNull$$$0(76);
        }
        if (value == null) {
            InlineCodegen.$$$reportNull$$$0(77);
        }
        if (InlineCodegen.shouldPutValue(parameterType, value)) {
            value.put(parameterType, this.codegen.v);
        }
        this.afterParameterPut(parameterType, value, index2);
    }

    @Override
    public void putCapturedValueOnStack(@NotNull StackValue stackValue, @NotNull Type valueType, int paramIndex) {
        if (stackValue == null) {
            InlineCodegen.$$$reportNull$$$0(78);
        }
        if (valueType == null) {
            InlineCodegen.$$$reportNull$$$0(79);
        }
        if (InlineCodegen.shouldPutValue(stackValue.type, stackValue)) {
            stackValue.put(stackValue.type, this.codegen.v);
        }
        this.putArgumentOrCapturedToLocalVal(stackValue.type, stackValue, paramIndex, paramIndex);
    }

    private void generateAndInsertFinallyBlocks(@NotNull MethodNode intoNode, @NotNull List<MethodInliner.PointForExternalFinallyBlocks> insertPoints, int offsetForFinallyLocalVar) {
        if (intoNode == null) {
            InlineCodegen.$$$reportNull$$$0(80);
        }
        if (insertPoints == null) {
            InlineCodegen.$$$reportNull$$$0(81);
        }
        if (!this.codegen.hasFinallyBlocks()) {
            return;
        }
        HashMap<AbstractInsnNode, MethodInliner.PointForExternalFinallyBlocks> extensionPoints = new HashMap<AbstractInsnNode, MethodInliner.PointForExternalFinallyBlocks>();
        for (MethodInliner.PointForExternalFinallyBlocks insertPoint : insertPoints) {
            extensionPoints.put(insertPoint.beforeIns, insertPoint);
        }
        DefaultProcessor processor = new DefaultProcessor(intoNode, offsetForFinallyLocalVar);
        int curFinallyDepth = 0;
        for (AbstractInsnNode curInstr = intoNode.instructions.getFirst(); curInstr != null; curInstr = curInstr.getNext()) {
            MethodInliner.PointForExternalFinallyBlocks extension;
            processor.processInstruction(curInstr, true);
            if (InlineCodegenUtil.isFinallyStart(curInstr)) {
                curFinallyDepth = InlineCodegenUtil.getConstant(curInstr.getPrevious());
            }
            if ((extension = (MethodInliner.PointForExternalFinallyBlocks)extensionPoints.get(curInstr)) == null) continue;
            Label start = new Label();
            MethodNode finallyNode = InlineCodegenUtil.createEmptyMethodNode();
            finallyNode.visitLabel(start);
            ExpressionCodegen finallyCodegen = new ExpressionCodegen(finallyNode, this.codegen.getFrameMap(), this.codegen.getReturnType(), this.codegen.getContext(), this.codegen.getState(), this.codegen.getParentCodegen());
            finallyCodegen.addBlockStackElementsForNonLocalReturns(this.codegen.getBlockStackElements(), curFinallyDepth);
            FrameMap frameMap = finallyCodegen.getFrameMap();
            FrameMap.Mark mark = frameMap.mark();
            int marker = -1;
            Set<LocalVarNodeWrapper> intervals = processor.getLocalVarsMetaInfo().getCurrentIntervals();
            for (LocalVarNodeWrapper interval : intervals) {
                marker = Math.max(interval.getNode().index + 1, marker);
            }
            while (frameMap.getCurrentSize() < Math.max(processor.getNextFreeLocalIndex(), offsetForFinallyLocalVar + marker)) {
                frameMap.enterTemp(Type.INT_TYPE);
            }
            finallyCodegen.generateFinallyBlocksIfNeeded(extension.returnType, extension.finallyIntervalEnd.getLabel());
            InlineCodegenUtil.insertNodeBefore(finallyNode, intoNode, curInstr);
            SimpleInterval splitBy = new SimpleInterval((LabelNode)start.info, extension.finallyIntervalEnd);
            processor.getTryBlocksMetaInfo().splitCurrentIntervals(splitBy, true);
            mark.dropTo();
        }
        processor.substituteTryBlockNodes(intoNode);
    }

    @NotNull
    public static SourceMapper createNestedSourceMapper(@NotNull SMAPAndMethodNode nodeAndSmap, @NotNull SourceMapper parent2) {
        if (nodeAndSmap == null) {
            InlineCodegen.$$$reportNull$$$0(82);
        }
        if (parent2 == null) {
            InlineCodegen.$$$reportNull$$$0(83);
        }
        NestedSourceMapper nestedSourceMapper = new NestedSourceMapper(parent2, nodeAndSmap.getSortedRanges(), nodeAndSmap.getClassSMAP().getSourceInfo());
        if (nestedSourceMapper == null) {
            InlineCodegen.$$$reportNull$$$0(84);
        }
        return nestedSourceMapper;
    }

    static void reportIncrementalInfo(@NotNull FunctionDescriptor sourceDescriptor, @NotNull FunctionDescriptor targetDescriptor, @NotNull JvmMethodSignature jvmSignature, @NotNull GenerationState state2) {
        IncrementalCache incrementalCache;
        if (sourceDescriptor == null) {
            InlineCodegen.$$$reportNull$$$0(85);
        }
        if (targetDescriptor == null) {
            InlineCodegen.$$$reportNull$$$0(86);
        }
        if (jvmSignature == null) {
            InlineCodegen.$$$reportNull$$$0(87);
        }
        if (state2 == null) {
            InlineCodegen.$$$reportNull$$$0(88);
        }
        if ((incrementalCache = state2.getIncrementalCacheForThisTarget()) == null) {
            return;
        }
        String classFilePath = InlineCodegenUtilsKt.getClassFilePath(sourceDescriptor, state2.getTypeMapper(), incrementalCache);
        String sourceFilePath = InlineCodegenUtilsKt.getSourceFilePath(targetDescriptor);
        Method method = jvmSignature.getAsmMethod();
        incrementalCache.registerInline(classFilePath, method.getName() + method.getDescriptor(), sourceFilePath);
    }

    @Override
    public void reorderArgumentsIfNeeded(@NotNull List<ArgumentAndDeclIndex> actualArgsWithDeclIndex, @NotNull List<? extends Type> valueParameterTypes) {
        if (actualArgsWithDeclIndex == null) {
            InlineCodegen.$$$reportNull$$$0(89);
        }
        if (valueParameterTypes == null) {
            InlineCodegen.$$$reportNull$$$0(90);
        }
    }

    @Override
    public void putHiddenParamsIntoLocals() {
        assert (this.delayedHiddenWriting != null) : "processAndPutHiddenParameters(true) should be called before putHiddenParamsIntoLocals";
        this.delayedHiddenWriting.run();
        this.delayedHiddenWriting = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 32: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 49: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 84: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 32: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 49: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 84: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 1: 
            case 24: 
            case 30: 
            case 65: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionOrAccessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableMethod";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 11: 
            case 27: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmSignature";
                break;
            }
            case 13: 
            case 29: 
            case 36: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 32: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 49: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/inline/InlineCodegen";
                break;
            }
            case 21: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodNode";
                break;
            }
            case 23: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableDescriptor";
                break;
            }
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asmMethod";
                break;
            }
            case 34: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeAndSmap";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 44: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 46: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmMethodSignature";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 57: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameterDescriptor";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentExpression";
                break;
            }
            case 72: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackValue";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueType";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intoNode";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertPoints";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDescriptor";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDescriptor";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualArgsWithDeclIndex";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameterTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/inline/InlineCodegen";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodNode";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectMemberAndCallableFromObject";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneMethodNode";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateMethodNodeFromSource";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineCall";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelOwnerDescriptor";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineCallSiteInfo";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLambdaBody";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMethodBody";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationLabels";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "createNestedSourceMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMemberScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "genCallInner";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "throwCompilationException";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateStub";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "endCall";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createMethodNode";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 32: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 49: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 84: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDirectMemberAndCallableFromObject";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "cloneMethodNode";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doCreateMethodNodeFromCompiled";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doCreateMethodNodeFromSource";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isBuiltInArrayIntrinsic";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "inlineCall";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getLabelOwnerDescriptor";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "removeStaticInitializationTrigger";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "generateLambdaBody";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodBody";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createSMAPWithDefaultMapping";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "afterParameterPut";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "putArgumentOrCapturedToLocalVal";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "shouldPutValue";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "recordParameterValueInLocalVal";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isInliningParameter";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "rememberClosure";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationLabels";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "putClosureParametersOnStack";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "genValueAndPut";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getBoundCallableReferenceReceiver";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "putValueIfNeeded";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "putCapturedValueOnStack";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "generateAndInsertFinallyBlocks";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "createNestedSourceMapper";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "reportIncrementalInfo";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "reorderArgumentsIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 32: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 49: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 84: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FakeMemberCodegen
    extends MemberCodegen {
        private final MemberCodegen delegate;
        private final String className;

        public FakeMemberCodegen(@NotNull MemberCodegen wrapped, @NotNull KtElement declaration, @NotNull FieldOwnerContext codegenContext, @NotNull String className2) {
            if (wrapped == null) {
                FakeMemberCodegen.$$$reportNull$$$0(0);
            }
            if (declaration == null) {
                FakeMemberCodegen.$$$reportNull$$$0(1);
            }
            if (codegenContext == null) {
                FakeMemberCodegen.$$$reportNull$$$0(2);
            }
            if (className2 == null) {
                FakeMemberCodegen.$$$reportNull$$$0(3);
            }
            super(wrapped, declaration, codegenContext);
            this.delegate = wrapped;
            this.className = className2;
        }

        @Override
        protected void generateDeclaration() {
            throw new IllegalStateException();
        }

        @Override
        protected void generateBody() {
            throw new IllegalStateException();
        }

        @Override
        protected void generateKotlinMetadataAnnotation() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public NameGenerator getInlineNameGenerator() {
            NameGenerator nameGenerator2 = this.delegate.getInlineNameGenerator();
            if (nameGenerator2 == null) {
                FakeMemberCodegen.$$$reportNull$$$0(4);
            }
            return nameGenerator2;
        }

        @Override
        @NotNull
        public String getClassName() {
            String string = this.className;
            if (string == null) {
                FakeMemberCodegen.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapped";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegenContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInlineNameGenerator";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

