/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.ParameterInfo;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class LocalVarRemapper {
    private final Parameters params;
    private final int actualParamsSize;
    private final StackValue[] remapValues;
    private final int additionalShift;

    public LocalVarRemapper(@NotNull Parameters params, int additionalShift) {
        if (params == null) {
            LocalVarRemapper.$$$reportNull$$$0(0);
        }
        this.additionalShift = additionalShift;
        this.params = params;
        this.remapValues = new StackValue[params.getArgsSizeOnStack()];
        int realSize = 0;
        for (ParameterInfo info : params) {
            Integer shift = params.getDeclarationSlot(info);
            if (!info.isSkippedOrRemapped()) {
                this.remapValues[shift.intValue()] = StackValue.local(realSize, AsmTypes.OBJECT_TYPE);
                realSize += info.getType().getSize();
                continue;
            }
            StackValue stackValue = this.remapValues[shift.intValue()] = info.isRemapped() ? info.getRemapValue() : null;
            if (!CapturedParamInfo.isSynthetic(info)) continue;
            realSize += info.getType().getSize();
        }
        this.actualParamsSize = realSize;
    }

    @NotNull
    private RemapInfo doRemap(int index2) {
        int remappedIndex;
        if (index2 < this.params.getArgsSizeOnStack()) {
            ParameterInfo info = this.params.getParameterByDeclarationSlot(index2);
            StackValue remapped = this.remapValues[index2];
            if (info.isSkipped || remapped == null) {
                RemapInfo remapInfo = new RemapInfo(info);
                if (remapInfo == null) {
                    LocalVarRemapper.$$$reportNull$$$0(1);
                }
                return remapInfo;
            }
            if (info.isRemapped()) {
                RemapInfo remapInfo = new RemapInfo(remapped, info, RemapStatus.REMAPPED);
                if (remapInfo == null) {
                    LocalVarRemapper.$$$reportNull$$$0(2);
                }
                return remapInfo;
            }
            remappedIndex = ((StackValue.Local)remapped).index;
        } else {
            remappedIndex = this.actualParamsSize - this.params.getArgsSizeOnStack() + index2;
        }
        RemapInfo remapInfo = new RemapInfo(StackValue.local(remappedIndex + this.additionalShift, AsmTypes.OBJECT_TYPE), null, RemapStatus.SHIFT);
        if (remapInfo == null) {
            LocalVarRemapper.$$$reportNull$$$0(3);
        }
        return remapInfo;
    }

    @NotNull
    public RemapInfo remap(int index2) {
        RemapInfo info = this.doRemap(index2);
        if (RemapStatus.FAIL == info.status) {
            assert (info.parameterInfo != null) : "Parameter info should be not null";
            throw new RuntimeException("Trying to access skipped parameter: " + info.parameterInfo.type + " at " + index2);
        }
        RemapInfo remapInfo = info;
        if (remapInfo == null) {
            LocalVarRemapper.$$$reportNull$$$0(4);
        }
        return remapInfo;
    }

    public void visitIincInsn(int var, int increment, @NotNull MethodVisitor mv) {
        if (mv == null) {
            LocalVarRemapper.$$$reportNull$$$0(5);
        }
        RemapInfo remap = this.remap(var);
        assert (remap.value instanceof StackValue.Local) : "Remapped value should be a local: " + remap.value;
        mv.visitIincInsn(((StackValue.Local)remap.value).index, increment);
    }

    public void visitLocalVariable(@NotNull String name, @NotNull String desc, @Nullable String signature, @NotNull Label start, @NotNull Label end, int index2, MethodVisitor mv) {
        if (name == null) {
            LocalVarRemapper.$$$reportNull$$$0(6);
        }
        if (desc == null) {
            LocalVarRemapper.$$$reportNull$$$0(7);
        }
        if (start == null) {
            LocalVarRemapper.$$$reportNull$$$0(8);
        }
        if (end == null) {
            LocalVarRemapper.$$$reportNull$$$0(9);
        }
        RemapInfo info = this.doRemap(index2);
        if (RemapStatus.SHIFT == info.status) {
            mv.visitLocalVariable(name, desc, signature, start, end, ((StackValue.Local)info.value).index);
        }
    }

    public void visitVarInsn(int opcode, int var, @NotNull InstructionAdapter mv) {
        if (mv == null) {
            LocalVarRemapper.$$$reportNull$$$0(10);
        }
        RemapInfo remapInfo = this.remap(var);
        StackValue value = remapInfo.value;
        if (value instanceof StackValue.Local) {
            boolean isStore = InlineCodegenUtil.isStoreInstruction(opcode);
            if (remapInfo.parameterInfo != null) {
                opcode = value.type.getOpcode(isStore ? 54 : 21);
            }
            mv.visitVarInsn(opcode, ((StackValue.Local)value).index);
            if (remapInfo.parameterInfo != null && !isStore) {
                StackValue.coerce(value.type, remapInfo.parameterInfo.type, mv);
            }
        } else {
            assert (remapInfo.parameterInfo != null) : "Non local value should have parameter info";
            value.put(remapInfo.parameterInfo.type, mv);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mv";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doRemap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "remap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitIincInsn";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitLocalVariable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitVarInsn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RemapInfo {
        public final StackValue value;
        public final ParameterInfo parameterInfo;
        public final RemapStatus status;

        public RemapInfo(@NotNull StackValue value, @Nullable ParameterInfo parameterInfo, @NotNull RemapStatus remapStatus) {
            if (value == null) {
                RemapInfo.$$$reportNull$$$0(0);
            }
            if (remapStatus == null) {
                RemapInfo.$$$reportNull$$$0(1);
            }
            this.value = value;
            this.parameterInfo = parameterInfo;
            this.status = remapStatus;
        }

        public RemapInfo(@NotNull ParameterInfo parameterInfo) {
            if (parameterInfo == null) {
                RemapInfo.$$$reportNull$$$0(2);
            }
            this.value = null;
            this.parameterInfo = parameterInfo;
            this.status = RemapStatus.FAIL;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "remapStatus";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameterInfo";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum RemapStatus {
        SHIFT,
        REMAPPED,
        FAIL;

    }
}

