/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.initializer;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;

public final class InitializerUtils {
    private InitializerUtils() {
    }

    @NotNull
    public static JsStatement generateInitializerForProperty(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor2, @NotNull JsExpression value) {
        if (context == null) {
            InitializerUtils.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            InitializerUtils.$$$reportNull$$$0(1);
        }
        if (value == null) {
            InitializerUtils.$$$reportNull$$$0(2);
        }
        JsStatement jsStatement = TranslationUtils.assignmentToBackingField(context, descriptor2, value).makeStmt();
        if (jsStatement == null) {
            InitializerUtils.$$$reportNull$$$0(3);
        }
        return jsStatement;
    }

    @Nullable
    public static JsStatement generateInitializerForDelegate(@NotNull PropertyDescriptor descriptor2, @NotNull JsExpression value) {
        if (descriptor2 == null) {
            InitializerUtils.$$$reportNull$$$0(4);
        }
        if (value == null) {
            InitializerUtils.$$$reportNull$$$0(5);
        }
        String name = descriptor2.getName().asString();
        return JsAstUtils.defineSimpleProperty(Namer.getDelegateName(name), value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/initializer/InitializerUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/initializer/InitializerUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateInitializerForProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateInitializerForProperty";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateInitializerForDelegate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

