/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.FilteringIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.BindingContextSuppressCache;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticsElementsCache;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;
import org.jetbrains.kotlin.resolve.diagnostics.SimpleDiagnostics;

public class DiagnosticsWithSuppression
implements Diagnostics {
    private final KotlinSuppressCache kotlinSuppressCache;
    private final Collection<Diagnostic> diagnostics;
    private final DiagnosticsElementsCache elementsCache;

    public DiagnosticsWithSuppression(@NotNull BindingContext context, @NotNull Collection<Diagnostic> diagnostics) {
        if (context == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(0);
        }
        if (diagnostics == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(1);
        }
        this.diagnostics = diagnostics;
        this.kotlinSuppressCache = new BindingContextSuppressCache(context);
        this.elementsCache = new DiagnosticsElementsCache(this, this.kotlinSuppressCache.getFilter());
    }

    @Override
    @NotNull
    public Diagnostics noSuppression() {
        SimpleDiagnostics simpleDiagnostics = new SimpleDiagnostics(this.diagnostics);
        if (simpleDiagnostics == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(2);
        }
        return simpleDiagnostics;
    }

    @Override
    @NotNull
    public Iterator<Diagnostic> iterator() {
        FilteringIterator filteringIterator = new FilteringIterator(this.diagnostics.iterator(), new Condition<Diagnostic>(){

            @Override
            public boolean value(Diagnostic diagnostic) {
                return DiagnosticsWithSuppression.this.kotlinSuppressCache.getFilter().invoke(diagnostic);
            }
        });
        if (filteringIterator == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(3);
        }
        return filteringIterator;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> all() {
        List<Diagnostic> list2 = CollectionsKt.filter(this.diagnostics, this.kotlinSuppressCache.getFilter());
        if (list2 == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> forElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(5);
        }
        Collection<Diagnostic> collection = this.elementsCache.getDiagnostics(psiElement);
        if (collection == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Override
    public boolean isEmpty() {
        return this.all().isEmpty();
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker() {
        throw new IllegalStateException("Trying to obtain modification tracker for readonly DiagnosticsWithSuppression.");
    }

    @NotNull
    public Collection<Diagnostic> getDiagnostics() {
        Collection<Diagnostic> collection = this.diagnostics;
        if (collection == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostics";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "noSuppression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "all";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "forElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagnostics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

