/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackagePartProvider;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.ChainedMemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.KotlinMetadataFinder;
import org.jetbrains.kotlin.serialization.deserialization.MetadataPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPackageFragment;", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializedPackageFragment;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "packagePartProvider", "Lorg/jetbrains/kotlin/descriptors/PackagePartProvider;", "finder", "Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/descriptors/PackagePartProvider;Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;)V", "classDataFinder", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "getClassDataFinder", "()Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "computeMemberScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "hasTopLevelClass", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "readProto", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$PackageFragment;", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl;", "stream", "Ljava/io/InputStream;", "Companion", "kotlin-compiler"})
public final class MetadataPackageFragment
extends DeserializedPackageFragment {
    @NotNull
    private final ClassDataFinder classDataFinder;
    private final PackagePartProvider packagePartProvider;
    private final KotlinMetadataFinder finder;
    @NotNull
    private static final String DOT_METADATA_FILE_EXTENSION = ".kotlin_metadata";
    @NotNull
    private static final String METADATA_FILE_EXTENSION = "kotlin_metadata";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ClassDataFinder getClassDataFinder() {
        return this.classDataFinder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected MemberScope computeMemberScope() {
        String string = this.getFqName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "fqName.asString()");
        List<String> packageParts = this.packagePartProvider.findMetadataPackageParts(string);
        ArrayList<DeserializedPackageMemberScope> scopes = new ArrayList<DeserializedPackageMemberScope>();
        for (String partName : packageParts) {
            void nameResolver;
            void proto;
            InputStream stream2;
            if (this.finder.findMetadata(new ClassId(this.getFqName(), Name.identifier(partName))) == null) {
                continue;
            }
            Pair<ProtoBuf.PackageFragment, NameResolverImpl> pair = this.readProto(stream2);
            ProtoBuf.PackageFragment packageFragment = pair.component1();
            NameResolverImpl nameResolverImpl = pair.component2();
            pair = null;
            PackageFragmentDescriptor packageFragmentDescriptor = this;
            ProtoBuf.Package package_ = proto.getPackage();
            Intrinsics.checkExpressionValueIsNotNull(package_, "proto.`package`");
            scopes.add(new DeserializedPackageMemberScope(packageFragmentDescriptor, package_, (NameResolver)nameResolver, null, this.getComponents(), computeMemberScope.1.INSTANCE));
        }
        PackageFragmentDescriptor packageFragmentDescriptor = this;
        ProtoBuf.Package package_ = ProtoBuf.Package.getDefaultInstance();
        Intrinsics.checkExpressionValueIsNotNull(package_, "ProtoBuf.Package.getDefaultInstance()");
        ProtoBuf.StringTable stringTable = ProtoBuf.StringTable.getDefaultInstance();
        Intrinsics.checkExpressionValueIsNotNull(stringTable, "ProtoBuf.StringTable.getDefaultInstance()");
        ProtoBuf.QualifiedNameTable qualifiedNameTable = ProtoBuf.QualifiedNameTable.getDefaultInstance();
        Intrinsics.checkExpressionValueIsNotNull(qualifiedNameTable, "ProtoBuf.QualifiedNameTable.getDefaultInstance()");
        scopes.add(new DeserializedPackageMemberScope(this, packageFragmentDescriptor, package_, new NameResolverImpl(stringTable, qualifiedNameTable), null, this.getComponents(), computeMemberScope.3.INSTANCE){
            final /* synthetic */ MetadataPackageFragment this$0;

            protected boolean hasClass(@NotNull Name name) {
                Intrinsics.checkParameterIsNotNull(name, "name");
                return this.this$0.hasTopLevelClass(name);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        });
        return ChainedMemberScope.Companion.create("Metadata scope", (List<? extends MemberScope>)scopes);
    }

    @Override
    public boolean hasTopLevelClass(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return true;
    }

    private final Pair<ProtoBuf.PackageFragment, NameResolverImpl> readProto(InputStream stream2) {
        BuiltInsBinaryVersion version = BuiltInsBinaryVersion.Companion.readFrom(stream2);
        if (!version.isCompatible()) {
            throw (Throwable)new UnsupportedOperationException("Kotlin metadata definition format version is not supported: " + ("expected " + BuiltInsBinaryVersion.INSTANCE + ", actual " + version + ". ") + "Please update Kotlin");
        }
        ProtoBuf.PackageFragment message = ProtoBuf.PackageFragment.parseFrom(stream2, BuiltInSerializerProtocol.INSTANCE.getExtensionRegistry());
        ProtoBuf.StringTable stringTable = message.getStrings();
        Intrinsics.checkExpressionValueIsNotNull(stringTable, "message.strings");
        ProtoBuf.QualifiedNameTable qualifiedNameTable = message.getQualifiedNames();
        Intrinsics.checkExpressionValueIsNotNull(qualifiedNameTable, "message.qualifiedNames");
        NameResolverImpl nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
        return new Pair<ProtoBuf.PackageFragment, NameResolverImpl>(message, nameResolver);
    }

    public MetadataPackageFragment(@NotNull FqName fqName2, @NotNull StorageManager storageManager, @NotNull ModuleDescriptor module, @NotNull PackagePartProvider packagePartProvider, @NotNull KotlinMetadataFinder finder) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(module, "module");
        Intrinsics.checkParameterIsNotNull(packagePartProvider, "packagePartProvider");
        Intrinsics.checkParameterIsNotNull(finder, "finder");
        super(fqName2, storageManager, module);
        this.packagePartProvider = packagePartProvider;
        this.finder = finder;
        this.classDataFinder = new ClassDataFinder(this){
            final /* synthetic */ MetadataPackageFragment this$0;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ClassDataWithSource findClassData(@NotNull ClassId classId) {
                ClassDataWithSource classDataWithSource;
                Object v1;
                void nameResolver;
                Serializable serializable;
                block4: {
                    void message;
                    Intrinsics.checkParameterIsNotNull(classId, "classId");
                    ClassId topLevelClassId2 = SequencesKt.last(SequencesKt.generateSequence(classId, (Function1)classDataFinder.topLevelClassId.1.INSTANCE));
                    InputStream inputStream = MetadataPackageFragment.access$getFinder$p(this.this$0).findMetadata(topLevelClassId2);
                    if (inputStream == null) {
                        return null;
                    }
                    InputStream stream2 = inputStream;
                    serializable = MetadataPackageFragment.access$readProto(this.this$0, stream2);
                    ProtoBuf.PackageFragment packageFragment = (ProtoBuf.PackageFragment)serializable.component1();
                    NameResolverImpl nameResolverImpl = (NameResolverImpl)serializable.component2();
                    serializable = null;
                    Iterable $receiver$iv = message.getClass_List();
                    for (T element$iv : $receiver$iv) {
                        ProtoBuf.Class classProto = (ProtoBuf.Class)element$iv;
                        if (!Intrinsics.areEqual(nameResolver.getClassId(classProto.getFqName()), classId)) continue;
                        v1 = element$iv;
                        break block4;
                    }
                    v1 = null;
                }
                ProtoBuf.Class clazz = v1;
                if (clazz != null) {
                    Serializable classProto = serializable = clazz;
                    ClassData classData = new ClassData((NameResolver)nameResolver, (ProtoBuf.Class)classProto);
                    SourceElement sourceElement = SourceElement.NO_SOURCE;
                    Intrinsics.checkExpressionValueIsNotNull(sourceElement, "SourceElement.NO_SOURCE");
                    classDataWithSource = new ClassDataWithSource(classData, sourceElement);
                } else {
                    classDataWithSource = null;
                }
                return classDataWithSource;
            }
            {
                this.this$0 = metadataPackageFragment;
            }
        };
    }

    static {
        DOT_METADATA_FILE_EXTENSION = DOT_METADATA_FILE_EXTENSION;
        METADATA_FILE_EXTENSION = METADATA_FILE_EXTENSION;
    }

    @NotNull
    public static final /* synthetic */ KotlinMetadataFinder access$getFinder$p(MetadataPackageFragment $this) {
        return $this.finder;
    }

    @NotNull
    public static final /* synthetic */ Pair access$readProto(MetadataPackageFragment $this, @NotNull InputStream stream2) {
        return $this.readProto(stream2);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPackageFragment$Companion;", "", "()V", "DOT_METADATA_FILE_EXTENSION", "", "getDOT_METADATA_FILE_EXTENSION", "()Ljava/lang/String;", "METADATA_FILE_EXTENSION", "getMETADATA_FILE_EXTENSION", "kotlin-compiler"})
    public static final class Companion {
        @NotNull
        public final String getDOT_METADATA_FILE_EXTENSION() {
            return DOT_METADATA_FILE_EXTENSION;
        }

        @NotNull
        public final String getMETADATA_FILE_EXTENSION() {
            return METADATA_FILE_EXTENSION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

