/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartOverlay;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.modules.profiler.snaptracer.impl.swing.ColorIcon;
import org.netbeans.modules.profiler.snaptracer.impl.swing.LabelRenderer;
import org.netbeans.modules.profiler.snaptracer.impl.swing.LegendFont;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;

final class TimelineUnitsOverlay
extends ChartOverlay {
    private final TimelineChart chart;
    private final LabelRenderer painter;
    private Model model;

    TimelineUnitsOverlay(TimelineChart timelineChart) {
        this.chart = timelineChart;
        this.painter = new LabelRenderer();
        this.painter.setFont(new LegendFont());
        int n = this.painter.getFont().getSize() - 3;
        ColorIcon.setup(n, n, LegendFont.FOREGROUND_COLOR, LegendFont.BACKGROUND_COLOR);
    }

    void setupModel(Model model) {
        this.model = model;
    }

    private boolean hasValues() {
        return ((SynchronousXYItemsModel)this.chart.getItemsModel()).getTimeline().getTimestampsCount() > 0;
    }

    private void setupPainter(String string, Color color) {
        this.painter.setText(string);
        this.painter.setIcon(color == null ? null : ColorIcon.fromColor(color));
    }

    public void paint(Graphics graphics) {
        if (this.model == null || !this.hasValues()) {
            return;
        }
        int n = this.getWidth();
        this.model.prefetch();
        int n2 = this.chart.getRowsCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            TimelineChart.Row row = this.chart.getRow(i);
            ChartContext chartContext = row.getContext();
            int n4 = Utils.checkedInt((double)chartContext.getViewportOffsetY());
            int n5 = chartContext.getViewportHeight();
            Color[] colorArray = this.model.getColors(row);
            int n6 = n - 2;
            int n7 = n4;
            for (n3 = colorArray.length - 1; n3 >= 0; --n3) {
                this.setupPainter(this.model.getMaxUnits(row)[n3], colorArray[n3]);
                this.paint(graphics, n6 -= this.painter.getPreferredSize().width, n7);
                n6 -= 10;
            }
            n6 = n - 2;
            n7 = -1;
            for (n3 = colorArray.length - 1; n3 >= 0; --n3) {
                this.setupPainter(this.model.getMinUnits(row)[n3], colorArray[n3]);
                Dimension dimension = this.painter.getPreferredSize();
                n6 -= dimension.width;
                if (n7 == -1) {
                    n7 = n4 + n5 - dimension.height - 1;
                }
                this.paint(graphics, n6, n7);
                n6 -= 10;
            }
        }
    }

    private void paint(Graphics graphics, int n, int n2) {
        this.painter.setLocation(n, n2 + 1);
        this.painter.setForeground(LegendFont.BACKGROUND_COLOR);
        this.painter.paint(graphics);
        this.painter.setLocation(n, n2);
        this.painter.setForeground(LegendFont.FOREGROUND_COLOR);
        if (this.painter.getIcon() != null) {
            this.painter.setIcon(ColorIcon.BOTTOM_SHADOW);
        }
        this.painter.paint(graphics);
    }

    public void invalidate() {
    }

    public void update(Graphics graphics) {
    }

    static interface Model {
        public void prefetch();

        public Color[] getColors(TimelineChart.Row var1);

        public String[] getMinUnits(TimelineChart.Row var1);

        public String[] getMaxUnits(TimelineChart.Row var1);
    }
}

