/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.controller.MenuItemEnabledListener;
import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.FoldAction;
import freemind.controller.actions.generated.instance.HookNodeAction;
import freemind.controller.actions.generated.instance.NewNodeAction;
import freemind.controller.actions.generated.instance.NodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.HookRegistration;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeHookAction;
import freemind.modes.mindmapmode.actions.xml.ActionHandler;
import freemind.modes.mindmapmode.hooks.MindMapNodeHookAdapter;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class JumpLastEditLocation
extends MindMapNodeHookAdapter {
    @Override
    public void invoke(MindMapNode pNode) {
        super.invoke(pNode);
        try {
            JumpLastEditLocationRegistration base = (JumpLastEditLocationRegistration)this.getPluginBaseClass();
            MindMapNode node = base.getLastEditLocation(pNode);
            if (node == null) {
                return;
            }
            this.logger.fine("Selecting " + node + " as last edit location.");
            this.getMindMapController().select(node, Tools.getVectorWithSingleElement(node));
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
        }
    }

    public static class JumpLastEditLocationRegistration
    implements HookRegistration,
    ActionHandler,
    MenuItemEnabledListener {
        private static final String PLUGIN_NAME = "accessories/plugins/JumpLastEditLocation.properties";
        private MindMapController controller;
        private MindMap mMap;
        private Logger logger;
        private Vector mLastEditLocations = new Vector();

        public MindMapNode getLastEditLocation(MindMapNode pCurrentNode) {
            int size = this.mLastEditLocations.size();
            if (size == 0) {
                return null;
            }
            String id = this.controller.getNodeID(pCurrentNode);
            int index = this.mLastEditLocations.lastIndexOf(id);
            while (true) {
                if (index < 0) {
                    index = size - 1;
                } else if (--index < 0) {
                    index = 0;
                }
                id = (String)this.mLastEditLocations.elementAt(index);
                try {
                    pCurrentNode = this.controller.getNodeFromID(id);
                    return pCurrentNode;
                }
                catch (Exception e) {
                    Resources.getInstance().logException(e);
                    if (index > 0) continue;
                    return null;
                }
                break;
            }
        }

        public JumpLastEditLocationRegistration(ModeController controller, MindMap map) {
            this.controller = (MindMapController)controller;
            this.mMap = map;
            this.logger = controller.getFrame().getLogger(this.getClass().getName());
        }

        @Override
        public void register() {
            this.controller.getActionFactory().registerHandler(this);
        }

        @Override
        public void deRegister() {
            this.controller.getActionFactory().deregisterHandler(this);
        }

        @Override
        public void executeAction(XmlAction action) {
            this.detectFormatChanges(action);
        }

        private void detectFormatChanges(XmlAction doAction) {
            block8: {
                HookNodeAction hookAction;
                block7: {
                    if (!(doAction instanceof CompoundAction)) break block7;
                    CompoundAction compAction = (CompoundAction)doAction;
                    for (XmlAction childAction : compAction.getListChoiceList()) {
                        this.detectFormatChanges(childAction);
                    }
                    break block8;
                }
                if (!(doAction instanceof NodeAction) || doAction instanceof FoldAction) break block8;
                if (doAction instanceof HookNodeAction && Tools.safeEquals((hookAction = (HookNodeAction)doAction).getHookName(), PLUGIN_NAME)) {
                    return;
                }
                String lastLocation = ((NodeAction)doAction).getNode();
                if (doAction instanceof NewNodeAction) {
                    NewNodeAction newNodeAction = (NewNodeAction)doAction;
                    lastLocation = newNodeAction.getNewId();
                }
                if (this.mLastEditLocations.size() > 0 && Tools.safeEquals((Object)lastLocation, this.mLastEditLocations.lastElement())) {
                    return;
                }
                this.mLastEditLocations.add(lastLocation);
                if (this.mLastEditLocations.size() > 10) {
                    this.mLastEditLocations.remove(0);
                }
                try {
                    this.logger.fine("New last edit location: " + lastLocation + " from " + this.controller.marshall(doAction));
                }
                catch (Exception e) {
                    Resources.getInstance().logException(e);
                    this.logger.warning("Not able to marshall the action " + doAction.getClass() + " as " + doAction);
                }
            }
        }

        @Override
        public void startTransaction(String name) {
        }

        @Override
        public void endTransaction(String name) {
        }

        @Override
        public boolean isEnabled(JMenuItem pItem, Action pAction) {
            String hookName = ((NodeHookAction)pAction).getHookName();
            if (PLUGIN_NAME.equals(hookName)) {
                return !this.mLastEditLocations.isEmpty();
            }
            return true;
        }
    }
}

