/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.layer.gpx.GpxDrawHelper;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateParser;

public class GPXSettingsPanel
extends JPanel
implements PreferenceTabbedPane.ValidationListener {
    private static final int WAYPOINT_LABEL_CUSTOM = 6;
    private static final String[] LABEL_PATTERN_TEMPLATE = new String[]{"?{ '{name} ({desc})' | '{name} ({cmt})' | '{name}' | '{desc}' | '{cmt}' }", "{name}", "{desc}", "{special:everything}", "?{ '{name}' | '{desc}' | '{formattedWaypointOffset}' }", " "};
    private static final String[] LABEL_PATTERN_DESC = new String[]{I18n.tr("Auto", new Object[0]), I18n.trc("gpx_field", "Name"), I18n.trc("gpx_field", "Desc(ription)"), I18n.tr("Everything", new Object[0]), I18n.tr("Name or offset", new Object[0]), I18n.tr("None", new Object[0]), I18n.tr("Custom", new Object[0])};
    private final JRadioButton drawRawGpsLinesGlobal = new JRadioButton(I18n.tr("Use global settings", new Object[0]));
    private final JRadioButton drawRawGpsLinesAll = new JRadioButton(I18n.tr("All", new Object[0]));
    private final JRadioButton drawRawGpsLinesLocal = new JRadioButton(I18n.tr("Local files", new Object[0]));
    private final JRadioButton drawRawGpsLinesNone = new JRadioButton(I18n.tr("None", new Object[0]));
    private transient ActionListener drawRawGpsLinesActionListener;
    private final JosmTextField drawRawGpsMaxLineLength = new JosmTextField(8);
    private final JosmTextField drawRawGpsMaxLineLengthLocal = new JosmTextField(8);
    private final JosmTextField drawLineWidth = new JosmTextField(2);
    private final JCheckBox forceRawGpsLines = new JCheckBox(I18n.tr("Force lines if no segments imported", new Object[0]));
    private final JCheckBox largeGpsPoints = new JCheckBox(I18n.tr("Draw large GPS points", new Object[0]));
    private final JCheckBox hdopCircleGpsPoints = new JCheckBox(I18n.tr("Draw a circle from HDOP value", new Object[0]));
    private final JRadioButton colorTypeVelocity = new JRadioButton(I18n.tr("Velocity (red = slow, green = fast)", new Object[0]));
    private final JRadioButton colorTypeDirection = new JRadioButton(I18n.tr("Direction (red = west, yellow = north, green = east, blue = south)", new Object[0]));
    private final JRadioButton colorTypeDilution = new JRadioButton(I18n.tr("Dilution of Position (red = high, green = low, if available)", new Object[0]));
    private final JRadioButton colorTypeTime = new JRadioButton(I18n.tr("Track date", new Object[0]));
    private final JRadioButton colorTypeHeatMap = new JRadioButton(I18n.tr("Heat Map (dark = few, bright = many)", new Object[0]));
    private final JRadioButton colorTypeNone = new JRadioButton(I18n.tr("Single Color (can be customized for named layers)", new Object[0]));
    private final JRadioButton colorTypeGlobal = new JRadioButton(I18n.tr("Use global settings", new Object[0]));
    private final JosmComboBox<String> colorTypeVelocityTune = new JosmComboBox<String>(new String[]{I18n.tr("Car", new Object[0]), I18n.tr("Bicycle", new Object[0]), I18n.tr("Foot", new Object[0])});
    private final JosmComboBox<String> colorTypeHeatMapTune = new JosmComboBox<String>(new String[]{I18n.trc("Heat map", "User Normal"), I18n.trc("Heat map", "User Light"), I18n.trc("Heat map", "Traffic Lights"), I18n.trc("Heat map", "Inferno"), I18n.trc("Heat map", "Viridis"), I18n.trc("Heat map", "Wood"), I18n.trc("Heat map", "Heat")});
    private final JCheckBox colorTypeHeatMapPoints = new JCheckBox(I18n.tr("Use points instead of lines for heat map", new Object[0]));
    private final JSlider colorTypeHeatMapGain = new JSlider();
    private final JSlider colorTypeHeatMapLowerLimit = new JSlider();
    private final JCheckBox makeAutoMarkers = new JCheckBox(I18n.tr("Create markers when reading GPX", new Object[0]));
    private final JCheckBox drawGpsArrows = new JCheckBox(I18n.tr("Draw Direction Arrows", new Object[0]));
    private final JCheckBox drawGpsArrowsFast = new JCheckBox(I18n.tr("Fast drawing (looks uglier)", new Object[0]));
    private final JosmTextField drawGpsArrowsMinDist = new JosmTextField(8);
    private final JCheckBox colorDynamic = new JCheckBox(I18n.tr("Dynamic color range based on data limits", new Object[0]));
    private final JosmComboBox<String> waypointLabel = new JosmComboBox<String>(LABEL_PATTERN_DESC);
    private final JosmTextField waypointLabelPattern = new JosmTextField();
    private final JosmComboBox<String> audioWaypointLabel = new JosmComboBox<String>(LABEL_PATTERN_DESC);
    private final JosmTextField audioWaypointLabelPattern = new JosmTextField();
    private final JCheckBox useGpsAntialiasing = new JCheckBox(I18n.tr("Smooth GPX graphics (antialiasing)", new Object[0]));
    private final JCheckBox drawLineWithAlpha = new JCheckBox(I18n.tr("Draw with Opacity (alpha blending) ", new Object[0]));
    private String layerName;
    private final boolean local;
    private final boolean nonlocal;

    public GPXSettingsPanel(String string, boolean bl, boolean bl2) {
        super(new GridBagLayout());
        this.local = bl;
        this.nonlocal = bl2;
        this.layerName = "layer " + string;
        this.initComponents();
        this.loadPreferences();
    }

    public GPXSettingsPanel() {
        super(new GridBagLayout());
        this.initComponents();
        this.local = false;
        this.nonlocal = false;
        this.loadPreferences();
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.makeAutoMarkers.setToolTipText(I18n.tr("Automatically make a marker layer from any waypoints when opening a GPX layer.", new Object[0]));
        ExpertToggleAction.addVisibilitySwitcher(this.makeAutoMarkers);
        this.add((Component)this.makeAutoMarkers, GBC.eol().insets(20, 0, 0, 5));
        ButtonGroup buttonGroup = new ButtonGroup();
        if (this.layerName != null) {
            buttonGroup.add(this.drawRawGpsLinesGlobal);
        }
        buttonGroup.add(this.drawRawGpsLinesNone);
        buttonGroup.add(this.drawRawGpsLinesLocal);
        buttonGroup.add(this.drawRawGpsLinesAll);
        JLabel jLabel = new JLabel(I18n.tr("Draw lines between raw GPS points", new Object[0]));
        this.add((Component)jLabel, GBC.eol().insets(20, 0, 0, 0));
        if (this.layerName != null) {
            this.add((Component)this.drawRawGpsLinesGlobal, GBC.eol().insets(40, 0, 0, 0));
        }
        this.add((Component)this.drawRawGpsLinesNone, GBC.eol().insets(40, 0, 0, 0));
        if (this.layerName == null || this.local) {
            this.add((Component)this.drawRawGpsLinesLocal, GBC.eol().insets(40, 0, 0, 0));
        }
        if (this.layerName == null || this.nonlocal) {
            this.add((Component)this.drawRawGpsLinesAll, GBC.eol().insets(40, 0, 0, 0));
        }
        ExpertToggleAction.addVisibilitySwitcher(jLabel);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsLinesGlobal);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsLinesNone);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsLinesLocal);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsLinesAll);
        this.drawRawGpsLinesActionListener = actionEvent -> {
            boolean bl = this.drawRawGpsLinesNone.isSelected() || this.drawRawGpsLinesGlobal.isSelected();
            this.forceRawGpsLines.setEnabled(!bl);
            this.drawRawGpsMaxLineLength.setEnabled(!bl && !this.drawRawGpsLinesLocal.isSelected());
            this.drawRawGpsMaxLineLengthLocal.setEnabled(!bl);
            this.drawGpsArrows.setEnabled(!bl);
            this.drawGpsArrowsFast.setEnabled(this.drawGpsArrows.isSelected() && this.drawGpsArrows.isEnabled());
            this.drawGpsArrowsMinDist.setEnabled(this.drawGpsArrows.isSelected() && this.drawGpsArrows.isEnabled());
        };
        this.drawRawGpsLinesGlobal.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesNone.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesLocal.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesAll.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsMaxLineLengthLocal.setToolTipText(I18n.tr("Maximum length (in meters) to draw lines for local files. Set to ''-1'' to draw all lines.", new Object[0]));
        jLabel = new JLabel(I18n.tr("Maximum length for local files (meters)", new Object[0]));
        this.add((Component)jLabel, GBC.std().insets(40, 0, 0, 0));
        this.add((Component)this.drawRawGpsMaxLineLengthLocal, GBC.eol().fill(2).insets(5, 0, 0, 5));
        ExpertToggleAction.addVisibilitySwitcher(jLabel);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsMaxLineLengthLocal);
        this.drawRawGpsMaxLineLength.setToolTipText(I18n.tr("Maximum length (in meters) to draw lines. Set to ''-1'' to draw all lines.", new Object[0]));
        jLabel = new JLabel(I18n.tr("Maximum length (meters)", new Object[0]));
        this.add((Component)jLabel, GBC.std().insets(40, 0, 0, 0));
        this.add((Component)this.drawRawGpsMaxLineLength, GBC.eol().fill(2).insets(5, 0, 0, 5));
        ExpertToggleAction.addVisibilitySwitcher(jLabel);
        ExpertToggleAction.addVisibilitySwitcher(this.drawRawGpsMaxLineLength);
        this.forceRawGpsLines.setToolTipText(I18n.tr("Force drawing of lines if the imported data contain no line information.", new Object[0]));
        this.add((Component)this.forceRawGpsLines, GBC.eop().insets(40, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.forceRawGpsLines);
        this.drawGpsArrows.addActionListener(actionEvent -> {
            this.drawGpsArrowsFast.setEnabled(this.drawGpsArrows.isSelected() && this.drawGpsArrows.isEnabled());
            this.drawGpsArrowsMinDist.setEnabled(this.drawGpsArrows.isSelected() && this.drawGpsArrows.isEnabled());
        });
        this.drawGpsArrows.setToolTipText(I18n.tr("Draw direction arrows for lines, connecting GPS points.", new Object[0]));
        this.add((Component)this.drawGpsArrows, GBC.eop().insets(20, 0, 0, 0));
        this.drawGpsArrowsFast.setToolTipText(I18n.tr("Draw the direction arrows using table lookups instead of complex math.", new Object[0]));
        this.add((Component)this.drawGpsArrowsFast, GBC.eop().insets(40, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.drawGpsArrowsFast);
        this.drawGpsArrowsMinDist.setToolTipText(I18n.tr("Do not draw arrows if they are not at least this distance away from the last one.", new Object[0]));
        this.add((Component)new JLabel(I18n.tr("Minimum distance (pixels)", new Object[0])), GBC.std().insets(40, 0, 0, 0));
        this.add((Component)this.drawGpsArrowsMinDist, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.hdopCircleGpsPoints.setToolTipText(I18n.tr("Draw a circle from HDOP value.", new Object[0]));
        this.add((Component)this.hdopCircleGpsPoints, GBC.eop().insets(20, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.hdopCircleGpsPoints);
        this.largeGpsPoints.setToolTipText(I18n.tr("Draw larger dots for the GPS points.", new Object[0]));
        this.add((Component)this.largeGpsPoints, GBC.eop().insets(20, 0, 0, 0));
        this.drawLineWidth.setToolTipText(I18n.tr("Width of drawn GPX line (0 for default)", new Object[0]));
        this.add((Component)new JLabel(I18n.tr("Drawing width of GPX lines", new Object[0])), GBC.std().insets(20, 0, 0, 0));
        this.add((Component)this.drawLineWidth, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.useGpsAntialiasing.setToolTipText(I18n.tr("Apply antialiasing to the GPX lines resulting in a smoother appearance.", new Object[0]));
        this.add((Component)this.useGpsAntialiasing, GBC.eop().insets(20, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.useGpsAntialiasing);
        this.drawLineWithAlpha.setToolTipText(I18n.tr("Apply dynamic alpha-blending and adjust width based on zoom level for all GPX lines.", new Object[0]));
        this.add((Component)this.drawLineWithAlpha, GBC.eop().insets(20, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.drawLineWithAlpha);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        if (this.layerName != null) {
            buttonGroup2.add(this.colorTypeGlobal);
        }
        buttonGroup2.add(this.colorTypeNone);
        buttonGroup2.add(this.colorTypeVelocity);
        buttonGroup2.add(this.colorTypeDirection);
        buttonGroup2.add(this.colorTypeDilution);
        buttonGroup2.add(this.colorTypeTime);
        buttonGroup2.add(this.colorTypeHeatMap);
        this.colorTypeNone.setToolTipText(I18n.tr("All points and track segments will have the same color. Can be customized in Layer Manager.", new Object[0]));
        this.colorTypeVelocity.setToolTipText(I18n.tr("Colors points and track segments by velocity.", new Object[0]));
        this.colorTypeDirection.setToolTipText(I18n.tr("Colors points and track segments by direction.", new Object[0]));
        this.colorTypeDilution.setToolTipText(I18n.tr("Colors points and track segments by dilution of position (HDOP). Your capture device needs to log that information.", new Object[0]));
        this.colorTypeTime.setToolTipText(I18n.tr("Colors points and track segments by its timestamp.", new Object[0]));
        this.colorTypeHeatMap.setToolTipText(I18n.tr("Collected points and track segments for a position and displayed as heat map.", new Object[0]));
        this.colorTypeVelocityTune.setToolTipText(I18n.tr("Allows to tune the track coloring for different average speeds.", new Object[0]));
        this.colorTypeHeatMapTune.setToolTipText(I18n.tr("Selects the color schema for heat map.", new Object[0]));
        JLabel jLabel2 = new JLabel();
        this.add(Box.createVerticalGlue(), GBC.eol().insets(0, 20, 0, 0));
        this.add((Component)new JLabel(I18n.tr("Track and Point Coloring", new Object[0])), GBC.eol().insets(20, 0, 0, 0));
        if (this.layerName != null) {
            this.add((Component)this.colorTypeGlobal, GBC.eol().insets(40, 0, 0, 0));
        }
        this.add((Component)this.colorTypeNone, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeVelocity, GBC.std().insets(40, 0, 0, 0));
        this.add(this.colorTypeVelocityTune, GBC.eop().fill(2).insets(5, 0, 0, 5));
        this.add((Component)this.colorTypeDirection, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeDilution, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeTime, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeHeatMap, GBC.std().insets(40, 0, 0, 0));
        this.add((Component)jLabel2, GBC.std().insets(5, 0, 0, 5));
        this.add(this.colorTypeHeatMapTune, GBC.eol().fill(2).insets(5, 0, 0, 5));
        JLabel jLabel3 = new JLabel(I18n.tr("Overlay gain adjustment", new Object[0]));
        JLabel jLabel4 = new JLabel(I18n.tr("Lower limit of visibility", new Object[0]));
        this.add((Component)jLabel3, GBC.std().insets(80, 0, 0, 0));
        this.add((Component)this.colorTypeHeatMapGain, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.add((Component)jLabel4, GBC.std().insets(80, 0, 0, 0));
        this.add((Component)this.colorTypeHeatMapLowerLimit, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.add((Component)this.colorTypeHeatMapPoints, GBC.eol().insets(60, 0, 0, 0));
        this.colorTypeHeatMapGain.setToolTipText(I18n.tr("Adjust the gain of overlay blending.", new Object[0]));
        this.colorTypeHeatMapGain.setOrientation(0);
        this.colorTypeHeatMapGain.setPaintLabels(true);
        this.colorTypeHeatMapGain.setMinimum(-10);
        this.colorTypeHeatMapGain.setMaximum(10);
        this.colorTypeHeatMapGain.setMinorTickSpacing(1);
        this.colorTypeHeatMapGain.setMajorTickSpacing(5);
        this.colorTypeHeatMapLowerLimit.setToolTipText(I18n.tr("Draw all GPX traces that exceed this threshold.", new Object[0]));
        this.colorTypeHeatMapLowerLimit.setOrientation(0);
        this.colorTypeHeatMapLowerLimit.setMinimum(0);
        this.colorTypeHeatMapLowerLimit.setMaximum(254);
        this.colorTypeHeatMapLowerLimit.setPaintLabels(true);
        this.colorTypeHeatMapLowerLimit.setMinorTickSpacing(10);
        this.colorTypeHeatMapLowerLimit.setMajorTickSpacing(100);
        this.colorTypeHeatMapPoints.setToolTipText(I18n.tr("Render engine uses points with simulated position error instead of lines. ", new Object[0]));
        Object object = buttonGroup2.getElements();
        while (object.hasMoreElements()) {
            object.nextElement().addChangeListener(changeEvent -> {
                this.colorTypeVelocityTune.setEnabled(this.colorTypeVelocity.isSelected());
                this.colorTypeHeatMapTune.setEnabled(this.colorTypeHeatMap.isSelected());
                this.colorTypeHeatMapPoints.setEnabled(this.colorTypeHeatMap.isSelected());
                this.colorTypeHeatMapGain.setEnabled(this.colorTypeHeatMap.isSelected());
                this.colorTypeHeatMapLowerLimit.setEnabled(this.colorTypeHeatMap.isSelected());
                jLabel3.setEnabled(this.colorTypeHeatMap.isSelected());
                jLabel4.setEnabled(this.colorTypeHeatMap.isSelected());
                this.colorDynamic.setEnabled(this.colorTypeVelocity.isSelected() || this.colorTypeDilution.isSelected());
            });
        }
        this.colorTypeHeatMapTune.addActionListener(actionEvent -> {
            Dimension dimension = this.colorTypeHeatMapTune.getPreferredSize();
            if (null != dimension) {
                int n = (int)dimension.getHeight();
                Color color = null != this.layerName ? GpxDrawHelper.DEFAULT_COLOR.getChildColor(this.layerName).get() : (Color)GpxDrawHelper.DEFAULT_COLOR.getDefaultValue();
                jLabel2.setIcon(GpxDrawHelper.getColorMapImageIcon(color, this.colorTypeHeatMapTune.getSelectedIndex(), n));
            }
        });
        ExpertToggleAction.addVisibilitySwitcher(this.colorTypeDirection);
        ExpertToggleAction.addVisibilitySwitcher(this.colorTypeDilution);
        ExpertToggleAction.addVisibilitySwitcher(this.colorTypeHeatMapLowerLimit);
        ExpertToggleAction.addVisibilitySwitcher(jLabel4);
        this.colorDynamic.setToolTipText(I18n.tr("Colors points and track segments by data limits.", new Object[0]));
        this.add((Component)this.colorDynamic, GBC.eop().insets(40, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(this.colorDynamic);
        if (this.layerName == null) {
            jLabel = new JLabel(I18n.tr("Waypoint labelling", new Object[0]));
            this.add((Component)jLabel, GBC.std().insets(20, 0, 0, 0));
            jLabel.setLabelFor(this.waypointLabel);
            this.add(this.waypointLabel, GBC.eol().fill(2).insets(5, 0, 0, 5));
            this.waypointLabel.addActionListener(actionEvent -> GPXSettingsPanel.updateWaypointPattern(this.waypointLabel, this.waypointLabelPattern));
            GPXSettingsPanel.updateWaypointLabelCombobox(this.waypointLabel, this.waypointLabelPattern, Marker.TemplateEntryProperty.forMarker(this.layerName));
            this.add((Component)this.waypointLabelPattern, GBC.eol().fill(2).insets(20, 0, 0, 5));
            ExpertToggleAction.addVisibilitySwitcher(jLabel);
            ExpertToggleAction.addVisibilitySwitcher(this.waypointLabel);
            ExpertToggleAction.addVisibilitySwitcher(this.waypointLabelPattern);
            object = Box.createVerticalGlue();
            this.add((Component)object, GBC.eol().insets(0, 20, 0, 0));
            ExpertToggleAction.addVisibilitySwitcher((Component)object);
            jLabel = new JLabel(I18n.tr("Audio waypoint labelling", new Object[0]));
            this.add((Component)jLabel, GBC.std().insets(20, 0, 0, 0));
            jLabel.setLabelFor(this.audioWaypointLabel);
            this.add(this.audioWaypointLabel, GBC.eol().fill(2).insets(5, 0, 0, 5));
            this.audioWaypointLabel.addActionListener(actionEvent -> GPXSettingsPanel.updateWaypointPattern(this.audioWaypointLabel, this.audioWaypointLabelPattern));
            GPXSettingsPanel.updateWaypointLabelCombobox(this.audioWaypointLabel, this.audioWaypointLabelPattern, Marker.TemplateEntryProperty.forAudioMarker(this.layerName));
            this.add((Component)this.audioWaypointLabelPattern, GBC.eol().fill(2).insets(20, 0, 0, 5));
            ExpertToggleAction.addVisibilitySwitcher(jLabel);
            ExpertToggleAction.addVisibilitySwitcher(this.audioWaypointLabel);
            ExpertToggleAction.addVisibilitySwitcher(this.audioWaypointLabelPattern);
        }
        this.add(Box.createVerticalGlue(), GBC.eol().fill(1));
    }

    public final void loadPreferences() {
        this.makeAutoMarkers.setSelected(Main.pref.getBoolean("marker.makeautomarkers", true));
        if (this.layerName != null && Main.pref.get("draw.rawgps.lines." + this.layerName).isEmpty() && Main.pref.get("draw.rawgps.lines.local." + this.layerName).isEmpty()) {
            this.drawRawGpsLinesGlobal.setSelected(true);
        } else {
            Boolean bl = Main.pref.getBoolean("draw.rawgps.lines.local", this.layerName, true);
            if (Main.pref.getBoolean("draw.rawgps.lines", this.layerName, true)) {
                this.drawRawGpsLinesAll.setSelected(true);
            } else if (bl.booleanValue()) {
                this.drawRawGpsLinesLocal.setSelected(true);
            } else {
                this.drawRawGpsLinesNone.setSelected(true);
            }
        }
        this.drawRawGpsMaxLineLengthLocal.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.max-line-length.local", this.layerName, -1)));
        this.drawRawGpsMaxLineLength.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.max-line-length", this.layerName, 200)));
        this.drawLineWidth.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.linewidth", this.layerName, 0)));
        this.drawLineWithAlpha.setSelected(Main.pref.getBoolean("draw.rawgps.lines.alpha-blend", this.layerName, false));
        this.forceRawGpsLines.setSelected(Main.pref.getBoolean("draw.rawgps.lines.force", this.layerName, false));
        this.drawGpsArrows.setSelected(Main.pref.getBoolean("draw.rawgps.direction", this.layerName, false));
        this.drawGpsArrowsFast.setSelected(Main.pref.getBoolean("draw.rawgps.alternatedirection", this.layerName, false));
        this.drawGpsArrowsMinDist.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.min-arrow-distance", this.layerName, 40)));
        this.hdopCircleGpsPoints.setSelected(Main.pref.getBoolean("draw.rawgps.hdopcircle", this.layerName, false));
        this.largeGpsPoints.setSelected(Main.pref.getBoolean("draw.rawgps.large", this.layerName, false));
        this.useGpsAntialiasing.setSelected(Main.pref.getBoolean("mappaint.gpx.use-antialiasing", false));
        this.drawRawGpsLinesActionListener.actionPerformed(null);
        if (this.layerName != null && Main.pref.get("draw.rawgps.colors." + this.layerName).isEmpty()) {
            this.colorTypeGlobal.setSelected(true);
            this.colorDynamic.setSelected(false);
            this.colorDynamic.setEnabled(false);
            this.colorTypeHeatMapPoints.setSelected(false);
            this.colorTypeHeatMapGain.setValue(0);
            this.colorTypeHeatMapLowerLimit.setValue(0);
        } else {
            int n = Main.pref.getInteger("draw.rawgps.colors", this.layerName, 0);
            switch (n) {
                case 0: {
                    this.colorTypeNone.setSelected(true);
                    break;
                }
                case 1: {
                    this.colorTypeVelocity.setSelected(true);
                    break;
                }
                case 2: {
                    this.colorTypeDilution.setSelected(true);
                    break;
                }
                case 3: {
                    this.colorTypeDirection.setSelected(true);
                    break;
                }
                case 4: {
                    this.colorTypeTime.setSelected(true);
                    break;
                }
                case 5: {
                    this.colorTypeHeatMap.setSelected(true);
                    break;
                }
                default: {
                    Main.warn("Unknown color type: " + n);
                }
            }
            int n2 = Main.pref.getInteger("draw.rawgps.colorTracksTune", this.layerName, 45);
            this.colorTypeVelocityTune.setSelectedIndex(n2 == 10 ? 2 : (n2 == 20 ? 1 : 0));
            this.colorTypeHeatMapTune.setSelectedIndex(Main.pref.getInteger("draw.rawgps.heatmap.colormap", this.layerName, 0));
            this.colorDynamic.setSelected(Main.pref.getBoolean("draw.rawgps.colors.dynamic", this.layerName, false));
            this.colorTypeHeatMapPoints.setSelected(Main.pref.getBoolean("draw.rawgps.heatmap.use-points", this.layerName, false));
            this.colorTypeHeatMapGain.setValue(Main.pref.getInteger("draw.rawgps.heatmap.gain", this.layerName, 0));
            this.colorTypeHeatMapLowerLimit.setValue(Main.pref.getInteger("draw.rawgps.heatmap.lower-limit", this.layerName, 0));
        }
    }

    public boolean savePreferences(String string, boolean bl) {
        String string2 = ".layer " + string;
        if (string == null) {
            string2 = "";
        }
        Main.pref.put("marker.makeautomarkers" + string2, this.makeAutoMarkers.isSelected());
        if (this.drawRawGpsLinesGlobal.isSelected()) {
            Main.pref.put("draw.rawgps.lines" + string2, null);
            Main.pref.put("draw.rawgps.max-line-length" + string2, null);
            Main.pref.put("draw.rawgps.lines.local" + string2, null);
            Main.pref.put("draw.rawgps.max-line-length.local" + string2, null);
            Main.pref.put("draw.rawgps.lines.force" + string2, null);
            Main.pref.put("draw.rawgps.direction" + string2, null);
            Main.pref.put("draw.rawgps.alternatedirection" + string2, null);
            Main.pref.put("draw.rawgps.min-arrow-distance" + string2, null);
        } else {
            if (string == null || !bl) {
                Main.pref.put("draw.rawgps.lines" + string2, this.drawRawGpsLinesAll.isSelected());
                Main.pref.put("draw.rawgps.max-line-length" + string2, this.drawRawGpsMaxLineLength.getText());
            }
            if (string == null || bl) {
                Main.pref.put("draw.rawgps.lines.local" + string2, this.drawRawGpsLinesAll.isSelected() || this.drawRawGpsLinesLocal.isSelected());
                Main.pref.put("draw.rawgps.max-line-length.local" + string2, this.drawRawGpsMaxLineLengthLocal.getText());
            }
            Main.pref.put("draw.rawgps.lines.force" + string2, this.forceRawGpsLines.isSelected());
            Main.pref.put("draw.rawgps.direction" + string2, this.drawGpsArrows.isSelected());
            Main.pref.put("draw.rawgps.alternatedirection" + string2, this.drawGpsArrowsFast.isSelected());
            Main.pref.put("draw.rawgps.min-arrow-distance" + string2, this.drawGpsArrowsMinDist.getText());
        }
        Main.pref.put("draw.rawgps.hdopcircle" + string2, this.hdopCircleGpsPoints.isSelected());
        Main.pref.put("draw.rawgps.large" + string2, this.largeGpsPoints.isSelected());
        Main.pref.put("draw.rawgps.linewidth" + string2, this.drawLineWidth.getText());
        Main.pref.put("draw.rawgps.lines.alpha-blend" + string2, this.drawLineWithAlpha.isSelected());
        Main.pref.put("mappaint.gpx.use-antialiasing", this.useGpsAntialiasing.isSelected());
        Marker.TemplateEntryProperty.forMarker(string).put(this.waypointLabelPattern.getText());
        Marker.TemplateEntryProperty.forAudioMarker(string).put(this.audioWaypointLabelPattern.getText());
        if (this.colorTypeGlobal.isSelected()) {
            Main.pref.put("draw.rawgps.colors" + string2, null);
            Main.pref.put("draw.rawgps.colors.dynamic" + string2, null);
            Main.pref.put("draw.rawgps.colorTracksTunec" + string2, null);
            return false;
        }
        if (this.colorTypeVelocity.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 1);
        } else if (this.colorTypeDilution.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 2);
        } else if (this.colorTypeDirection.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 3);
        } else if (this.colorTypeTime.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 4);
        } else if (this.colorTypeHeatMap.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 5);
        } else {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 0);
        }
        Main.pref.put("draw.rawgps.colors.dynamic" + string2, this.colorDynamic.isSelected());
        int n = this.colorTypeVelocityTune.getSelectedIndex();
        Main.pref.putInteger("draw.rawgps.colorTracksTune" + string2, n == 2 ? 10 : (n == 1 ? 20 : 45));
        Main.pref.putInteger("draw.rawgps.heatmap.colormap" + string2, this.colorTypeHeatMapTune.getSelectedIndex());
        Main.pref.put("draw.rawgps.heatmap.use-points" + string2, this.colorTypeHeatMapPoints.isSelected());
        Main.pref.putInteger("draw.rawgps.heatmap.gain" + string2, this.colorTypeHeatMapGain.getValue());
        Main.pref.putInteger("draw.rawgps.heatmap.lower-limit" + string2, this.colorTypeHeatMapLowerLimit.getValue());
        return false;
    }

    public boolean savePreferences() {
        return this.savePreferences(null, false);
    }

    private static void updateWaypointLabelCombobox(JosmComboBox<String> josmComboBox, JosmTextField josmTextField, Marker.TemplateEntryProperty templateEntryProperty) {
        String string = templateEntryProperty.getAsString();
        boolean bl = false;
        for (int i = 0; i < LABEL_PATTERN_TEMPLATE.length; ++i) {
            if (!LABEL_PATTERN_TEMPLATE[i].equals(string)) continue;
            josmComboBox.setSelectedIndex(i);
            bl = true;
            break;
        }
        if (!bl) {
            josmComboBox.setSelectedIndex(6);
            josmTextField.setEnabled(true);
            josmTextField.setText(string);
        }
    }

    private static void updateWaypointPattern(JosmComboBox<String> josmComboBox, JosmTextField josmTextField) {
        if (josmComboBox.getSelectedIndex() == 6) {
            josmTextField.setEnabled(true);
        } else {
            josmTextField.setEnabled(false);
            josmTextField.setText(LABEL_PATTERN_TEMPLATE[josmComboBox.getSelectedIndex()]);
        }
    }

    @Override
    public boolean validatePreferences() {
        TemplateParser templateParser = new TemplateParser(this.waypointLabelPattern.getText());
        try {
            templateParser.parse();
        }
        catch (ParseError parseError) {
            Main.warn(parseError);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Incorrect waypoint label pattern: {0}", parseError.getMessage()), I18n.tr("Incorrect pattern", new Object[0]), 0);
            this.waypointLabelPattern.requestFocus();
            return false;
        }
        templateParser = new TemplateParser(this.audioWaypointLabelPattern.getText());
        try {
            templateParser.parse();
        }
        catch (ParseError parseError) {
            Main.warn(parseError);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Incorrect audio waypoint label pattern: {0}", parseError.getMessage()), I18n.tr("Incorrect pattern", new Object[0]), 0);
            this.audioWaypointLabelPattern.requestFocus();
            return false;
        }
        return true;
    }
}

