/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.children;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.ParentFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.children.ChildrenAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.children.ParentToChildrenAggregator;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;

public class ChildrenAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.Bytes.ParentChild, ChildrenAggregationBuilder> {
    public static final String NAME = "children";
    private String parentType;
    private final String childType;
    private Query parentFilter;
    private Query childFilter;

    public ChildrenAggregationBuilder(String name, String childType) {
        super(name, ValuesSourceType.BYTES, ValueType.STRING);
        if (childType == null) {
            throw new IllegalArgumentException("[childType] must not be null: [" + name + "]");
        }
        this.childType = childType;
    }

    public ChildrenAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.BYTES, ValueType.STRING);
        this.childType = in.readString();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.childType);
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.Bytes.ParentChild, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.Bytes.ParentChild> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new ChildrenAggregatorFactory(this.name, config, this.parentType, this.childFilter, this.parentFilter, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    protected ValuesSourceConfig<ValuesSource.Bytes.ParentChild> resolveConfig(SearchContext context) {
        ValuesSourceConfig<ValuesSource.Bytes.ParentChild> config = new ValuesSourceConfig<ValuesSource.Bytes.ParentChild>(ValuesSourceType.BYTES);
        DocumentMapper childDocMapper = context.mapperService().documentMapper(this.childType);
        if (childDocMapper != null) {
            ParentFieldMapper parentFieldMapper = childDocMapper.parentFieldMapper();
            if (!parentFieldMapper.active()) {
                throw new IllegalArgumentException("[children] no [_parent] field not configured that points to a parent type");
            }
            this.parentType = parentFieldMapper.type();
            DocumentMapper parentDocMapper = context.mapperService().documentMapper(this.parentType);
            if (parentDocMapper != null) {
                this.parentFilter = parentDocMapper.typeFilter();
                this.childFilter = childDocMapper.typeFilter();
                ParentChildIndexFieldData parentChildIndexFieldData = (ParentChildIndexFieldData)context.fieldData().getForField(parentFieldMapper.fieldType());
                config.fieldContext(new FieldContext(parentFieldMapper.fieldType().name(), parentChildIndexFieldData, parentFieldMapper.fieldType()));
            } else {
                config.unmapped(true);
            }
        } else {
            config.unmapped(true);
        }
        return config;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ParentToChildrenAggregator.TYPE_FIELD.getPreferredName(), this.childType);
        return builder;
    }

    public static ChildrenAggregationBuilder parse(String aggregationName, QueryParseContext context) throws IOException {
        XContentParser.Token token;
        String childType = null;
        String currentFieldName = null;
        XContentParser parser = context.parser();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("type".equals(currentFieldName)) {
                    childType = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].", new Object[0]);
        }
        if (childType == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing [child_type] field for children aggregation [" + aggregationName + "]", new Object[0]);
        }
        return new ChildrenAggregationBuilder(aggregationName, childType);
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.childType);
    }

    @Override
    protected boolean innerEquals(Object obj) {
        ChildrenAggregationBuilder other = (ChildrenAggregationBuilder)obj;
        return Objects.equals(this.childType, other.childType);
    }

    @Override
    public String getType() {
        return NAME;
    }
}

