/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.j3d.TextureManager;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Wall;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ground3D
extends Object3DBranch {
    private final float originX;
    private final float originY;
    private final float width;
    private final float depth;

    public Ground3D(Home home, float f, float f2, float f3, float f4, boolean bl) {
        this.setUserData(home);
        this.originX = f;
        this.originY = f2;
        this.width = f3;
        this.depth = f4;
        Appearance appearance = new Appearance();
        appearance.setCapability(1);
        appearance.setCapability(3);
        appearance.setCapability(7);
        appearance.setCapability(10);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setCapability(1);
        appearance.setTransparencyAttributes(transparencyAttributes);
        Shape3D shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setCapability(13);
        shape3D.setCapability(12);
        shape3D.setCapability(14);
        this.setCapability(12);
        this.addChild((Node)shape3D);
        this.update(bl);
    }

    @Override
    public void update() {
        this.update(false);
    }

    /*
     * WARNING - void declaration
     */
    private void update(boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        final Home home = (Home)this.getUserData();
        Shape3D shape3D = (Shape3D)this.getChild(0);
        int n = shape3D.numGeometries();
        final Appearance appearance = shape3D.getAppearance();
        HomeTexture homeTexture = home.getEnvironment().getGroundTexture();
        if (homeTexture == null) {
            int n2 = home.getEnvironment().getGroundColor();
            appearance.setMaterial(this.getMaterial(n2, n2, 0.0f));
            appearance.setTexture(null);
            appearance.getTransparencyAttributes().setTransparencyMode(4);
        } else {
            appearance.setMaterial(this.getMaterial(DEFAULT_COLOR, DEFAULT_COLOR, 0.0f));
            appearance.setTextureAttributes(this.getTextureAttributes(homeTexture, true));
            TextureManager textureManager = TextureManager.getInstance();
            textureManager.loadTexture(homeTexture.getImage(), bl, new TextureManager.TextureObserver(){

                public void textureUpdated(Texture texture) {
                    appearance.setTexture(Ground3D.this.getHomeTextureClone(texture, home));
                    TransparencyAttributes transparencyAttributes = appearance.getTransparencyAttributes();
                    transparencyAttributes.setTransparencyMode(TextureManager.getInstance().isTextureTransparent(texture) ? 1 : 4);
                }
            });
        }
        Area area = new Area();
        Comparator<Level> comparator = new Comparator<Level>(){

            @Override
            public int compare(Level level, Level level2) {
                return -Float.compare(level.getElevation(), level2.getElevation());
            }
        };
        TreeMap<Level, Area> treeMap = new TreeMap<Level, Area>(comparator);
        TreeMap<Level, Area> treeMap2 = new TreeMap<Level, Area>(comparator);
        for (Room object72 : home.getRooms()) {
            void var15_27;
            Level level = object72.getLevel();
            if (level != null && !level.isViewable() || !object72.isFloorVisible() || ((float[][])(object4 = object72.getPoints())).length <= 2) continue;
            Object var15_28 = null;
            if (level == null || level.getElevation() <= 0.0f && level.isViewableAndVisible()) {
                Area area2 = new Area(this.getShape((float[][])object4));
                area.add(area2);
                this.updateUndergroundAreas(treeMap2, object72.getLevel(), (float[][])object4, area2);
            }
            this.updateUndergroundAreas(treeMap, object72.getLevel(), (float[][])object4, (Area)var15_27);
        }
        for (HomePieceOfFurniture homePieceOfFurniture : home.getFurniture()) {
            if (!(homePieceOfFurniture.getGroundElevation() < 0.0f) || homePieceOfFurniture.getLevel() != null && !homePieceOfFurniture.getLevel().isViewable()) continue;
            if (homePieceOfFurniture.getStaircaseCutOutShape() == null) {
                this.updateUndergroundAreas(treeMap, homePieceOfFurniture.getLevel(), homePieceOfFurniture.getPoints(), null);
                continue;
            }
            this.updateUndergroundAreas(treeMap, homePieceOfFurniture.getLevel(), null, ModelManager.getInstance().getAreaOnFloor(homePieceOfFurniture));
        }
        HashMap hashMap = new HashMap();
        for (Wall wall : home.getWalls()) {
            if (wall.getLevel() != null && !wall.getLevel().isViewable()) continue;
            this.updateUndergroundAreas(hashMap, wall.getLevel(), wall.getPoints(), null);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object4 = this.getAreaPoints((Area)entry.getValue()).iterator();
            while (object4.hasNext()) {
                float[][] fArray = (float[][])object4.next();
                if (new Room(fArray).isClockwise()) continue;
                this.updateUndergroundAreas(treeMap, (Level)entry.getKey(), fArray, null);
            }
        }
        TreeMap<Level, Area> treeMap3 = new TreeMap<Level, Area>(comparator);
        HashMap<Level, Area> hashMap2 = new HashMap<Level, Area>();
        for (Map.Entry entry : treeMap.entrySet()) {
            object3 = (Level)entry.getKey();
            object2 = (Area)entry.getValue();
            Area area3 = (Area)((Area)object2).clone();
            treeMap3.put((Level)object3, (Area)((Area)object2).clone());
            hashMap2.put((Level)object3, new Area());
            for (Map.Entry entry2 : treeMap.entrySet()) {
                if (!(((Level)entry2.getKey()).getElevation() < ((Level)object3).getElevation())) continue;
                for (float[][] fArray : this.getAreaPoints((Area)entry2.getValue())) {
                    if (new Room(fArray).isClockwise()) continue;
                    Area area4 = new Area(this.getShape(fArray));
                    ((Area)object2).subtract(area4);
                    ((Area)treeMap3.get(object3)).add(area4);
                }
            }
            object = this.getAreaPoints((Area)object2).iterator();
            while (object.hasNext()) {
                Map.Entry entry2;
                entry2 = (Map.Entry)((float[][])object.next());
                if (new Room((float[][])entry2).isClockwise()) {
                    Iterator<float[][]> iterator = new Area(this.getShape((float[][])entry2));
                    ((Area)((Object)iterator)).exclusiveOr(area3);
                    ((Area)((Object)iterator)).subtract(area3);
                    ((Area)hashMap2.get(object3)).add((Area)((Object)iterator));
                    continue;
                }
                area.add(new Area(this.getShape((float[][])entry2)));
            }
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            object3 = (Level)entry.getKey();
            object2 = (Area)entry.getValue();
            Area area5 = (Area)treeMap2.get(object3);
            if (area5 == null) continue;
            ((Area)object2).subtract(area5);
        }
        object4 = new Area(this.getShape(new float[][]{{this.originX, this.originY}, {this.originX, this.originY + this.depth}, {this.originX + this.width, this.originY + this.depth}, {this.originX + this.width, this.originY}}));
        Rectangle2D rectangle2D = area.getBounds2D();
        if (!((Area)object4).getBounds2D().equals(rectangle2D)) {
            void var15_38;
            object3 = object4;
            if (area.isEmpty()) {
                Rectangle2D.Float float_ = new Rectangle2D.Float(Math.max(-5000.0f, this.originX), Math.max(-5000.0f, this.originY), 0.0f, 0.0f);
                float_.add(Math.min(5000.0f, this.originX + this.width), Math.min(5000.0f, this.originY + this.depth));
            } else {
                rectangle2D.add(Math.max(rectangle2D.getMinX() - 5000.0, (double)this.originX), Math.max(rectangle2D.getMinY() - 5000.0, (double)this.originY));
                rectangle2D.add(Math.min(rectangle2D.getMaxX() + 5000.0, (double)(this.originX + this.width)), Math.min(rectangle2D.getMaxY() + 5000.0, (double)(this.originY + this.depth)));
            }
            object4 = new Area((Shape)var15_38);
            ((Area)object3).subtract((Area)object4);
            this.addAreaGeometry(shape3D, homeTexture, (Area)object3, 0.0f);
        }
        ((Area)object4).subtract(area);
        treeMap.put(new Level("Ground", 0.0f, 0.0f, 0.0f), (Area)object4);
        float f = 0.0f;
        for (Map.Entry entry : treeMap.entrySet()) {
            object = (Level)entry.getKey();
            float f2 = ((Level)object).getElevation();
            this.addAreaGeometry(shape3D, homeTexture, (Area)entry.getValue(), f2);
            if (f - f2 > 0.0f) {
                for (float[][] fArray : this.getAreaPoints((Area)treeMap3.get(object))) {
                    this.addAreaSidesGeometry(shape3D, homeTexture, fArray, f2, f - f2);
                }
                this.addAreaGeometry(shape3D, homeTexture, (Area)hashMap2.get(object), f);
            }
            f = f2;
        }
        for (int i = n - 1; i >= 0; --i) {
            shape3D.removeGeometry(i);
        }
    }

    private List<float[][]> getAreaPoints(Area area) {
        ArrayList<float[][]> arrayList = new ArrayList<float[][]>();
        ArrayList<float[]> arrayList2 = new ArrayList<float[]>();
        float[] fArray = null;
        PathIterator pathIterator = area.getPathIterator(null, 1.0);
        while (!pathIterator.isDone()) {
            float[] fArray2 = new float[2];
            if (pathIterator.currentSegment(fArray2) == 4) {
                if (((float[])arrayList2.get(0))[0] == fArray[0] && ((float[])arrayList2.get(0))[1] == fArray[1]) {
                    arrayList2.remove(arrayList2.size() - 1);
                }
                if (arrayList2.size() > 2) {
                    arrayList.add((float[][])arrayList2.toArray((T[])new float[arrayList2.size()][]));
                }
                arrayList2.clear();
                fArray = null;
            } else {
                if (fArray == null || fArray2[0] != fArray[0] || fArray2[1] != fArray[1]) {
                    arrayList2.add(fArray2);
                }
                fArray = fArray2;
            }
            pathIterator.next();
        }
        return arrayList;
    }

    private void updateUndergroundAreas(Map<Level, Area> map, Level level, float[][] fArray, Area area) {
        if (level != null && level.getElevation() < 0.0f) {
            Area area2 = map.get(level);
            if (area2 == null) {
                area2 = new Area();
                map.put(level, area2);
            }
            area2.add(area != null ? area : new Area(this.getShape(fArray)));
        }
    }

    private void addAreaGeometry(Shape3D shape3D, HomeTexture homeTexture, Area area, float f) {
        List<float[][]> list = this.getAreaPoints(area, 1.0f, false);
        if (!list.isEmpty()) {
            int n = 0;
            int[] nArray = new int[list.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = list.get(i).length;
                n += nArray[i];
            }
            Point3f[] point3fArray = new Point3f[n];
            TexCoord2f[] texCoord2fArray = homeTexture != null ? new TexCoord2f[n] : null;
            int n2 = 0;
            for (float[][] fArray : list) {
                int n3 = 0;
                while (n3 < fArray.length) {
                    float[] fArray2 = fArray[n3];
                    point3fArray[n2] = new Point3f(fArray2[0], f, fArray2[1]);
                    if (homeTexture != null) {
                        texCoord2fArray[n2] = new TexCoord2f(fArray2[0] - this.originX, this.originY - fArray2[1]);
                    }
                    ++n3;
                    ++n2;
                }
            }
            GeometryInfo geometryInfo = new GeometryInfo(5);
            geometryInfo.setCoordinates(point3fArray);
            if (homeTexture != null) {
                geometryInfo.setTextureCoordinateParams(1, 2);
                geometryInfo.setTextureCoordinates(0, texCoord2fArray);
            }
            geometryInfo.setStripCounts(nArray);
            new NormalGenerator(0.0).generateNormals(geometryInfo);
            shape3D.addGeometry((Geometry)geometryInfo.getIndexedGeometryArray());
        }
    }

    private void addAreaSidesGeometry(Shape3D shape3D, HomeTexture homeTexture, float[][] fArray, float f, float f2) {
        Point3f[] point3fArray = new Point3f[fArray.length * 4];
        TexCoord2f[] texCoord2fArray = homeTexture != null ? new TexCoord2f[point3fArray.length] : null;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray2 = fArray[i];
            float[] fArray3 = fArray[i < fArray.length - 1 ? i + 1 : 0];
            point3fArray[n++] = new Point3f(fArray2[0], f, fArray2[1]);
            point3fArray[n++] = new Point3f(fArray2[0], f + f2, fArray2[1]);
            point3fArray[n++] = new Point3f(fArray3[0], f + f2, fArray3[1]);
            point3fArray[n++] = new Point3f(fArray3[0], f, fArray3[1]);
            if (homeTexture == null) continue;
            float f3 = (float)Point2D.distance(fArray2[0], fArray2[1], fArray3[0], fArray3[1]);
            texCoord2fArray[n - 4] = new TexCoord2f(fArray2[0], f);
            texCoord2fArray[n - 3] = new TexCoord2f(fArray2[0], f + f2);
            texCoord2fArray[n - 2] = new TexCoord2f(fArray2[0] - f3, f + f2);
            texCoord2fArray[n - 1] = new TexCoord2f(fArray2[0] - f3, f);
        }
        GeometryInfo geometryInfo = new GeometryInfo(2);
        geometryInfo.setCoordinates(point3fArray);
        if (homeTexture != null) {
            geometryInfo.setTextureCoordinateParams(1, 2);
            geometryInfo.setTextureCoordinates(0, texCoord2fArray);
        }
        new NormalGenerator(0.0).generateNormals(geometryInfo);
        shape3D.addGeometry((Geometry)geometryInfo.getIndexedGeometryArray());
    }
}

