/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.net.ssl.SSLHandshakeException;
import sun.security.ssl.Debug;
import sun.security.ssl.JsseJce;
import sun.security.util.KeyUtil;

final class DHCrypt {
    private BigInteger modulus;
    private BigInteger base;
    private PrivateKey privateKey;
    private BigInteger publicValue;
    private static int MAX_FAILOVER_TIMES = 2;

    DHCrypt(int keyLength, SecureRandom random) {
        this(keyLength, (DHParameterSpec)ParametersHolder.definedParams.get(keyLength), random);
    }

    DHCrypt(BigInteger modulus, BigInteger base, SecureRandom random) {
        this(modulus.bitLength(), new DHParameterSpec(modulus, base), random);
    }

    private DHCrypt(int keyLength, DHParameterSpec params, SecureRandom random) {
        try {
            KeyPairGenerator kpg = JsseJce.getKeyPairGenerator("DiffieHellman");
            if (params != null) {
                kpg.initialize(params, random);
            } else {
                kpg.initialize(keyLength, random);
            }
            DHPublicKeySpec spec = this.generateDHPublicKeySpec(kpg);
            if (spec == null) {
                throw new RuntimeException("Could not generate DH keypair");
            }
            this.publicValue = spec.getY();
            this.modulus = spec.getP();
            this.base = spec.getG();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not generate DH keypair", e);
        }
    }

    static DHPublicKeySpec getDHPublicKeySpec(PublicKey key) {
        if (key instanceof DHPublicKey) {
            DHPublicKey dhKey = (DHPublicKey)key;
            DHParameterSpec params = dhKey.getParams();
            return new DHPublicKeySpec(dhKey.getY(), params.getP(), params.getG());
        }
        try {
            KeyFactory factory = JsseJce.getKeyFactory("DH");
            return factory.getKeySpec(key, DHPublicKeySpec.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    BigInteger getModulus() {
        return this.modulus;
    }

    BigInteger getBase() {
        return this.base;
    }

    BigInteger getPublicKey() {
        return this.publicValue;
    }

    SecretKey getAgreedSecret(BigInteger peerPublicValue, boolean keyIsValidated) throws SSLHandshakeException {
        try {
            KeyFactory kf = JsseJce.getKeyFactory("DiffieHellman");
            DHPublicKeySpec spec = new DHPublicKeySpec(peerPublicValue, this.modulus, this.base);
            PublicKey publicKey = kf.generatePublic(spec);
            KeyAgreement ka = JsseJce.getKeyAgreement("DiffieHellman");
            if (!keyIsValidated && !KeyUtil.isOracleJCEProvider(ka.getProvider().getName())) {
                try {
                    KeyUtil.validate(spec);
                }
                catch (InvalidKeyException ike) {
                    throw new SSLHandshakeException(ike.getMessage());
                }
            }
            ka.init(this.privateKey);
            ka.doPhase(publicKey, true);
            return ka.generateSecret("TlsPremasterSecret");
        }
        catch (GeneralSecurityException e) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(e);
        }
    }

    void checkConstraints(AlgorithmConstraints constraints, BigInteger peerPublicValue) throws SSLHandshakeException {
        try {
            KeyFactory kf = JsseJce.getKeyFactory("DiffieHellman");
            DHPublicKeySpec spec = new DHPublicKeySpec(peerPublicValue, this.modulus, this.base);
            DHPublicKey publicKey = (DHPublicKey)kf.generatePublic(spec);
            if (!constraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), publicKey)) {
                throw new SSLHandshakeException("DHPublicKey does not comply to algorithm constraints");
            }
        }
        catch (GeneralSecurityException gse) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not generate DHPublicKey").initCause(gse);
        }
    }

    private DHPublicKeySpec generateDHPublicKeySpec(KeyPairGenerator kpg) throws GeneralSecurityException {
        boolean doExtraValiadtion = !KeyUtil.isOracleJCEProvider(kpg.getProvider().getName());
        for (int i = 0; i <= MAX_FAILOVER_TIMES; ++i) {
            KeyPair kp = kpg.generateKeyPair();
            this.privateKey = kp.getPrivate();
            DHPublicKeySpec spec = DHCrypt.getDHPublicKeySpec(kp.getPublic());
            if (doExtraValiadtion) {
                try {
                    KeyUtil.validate(spec);
                }
                catch (InvalidKeyException ivke) {
                    if (i != MAX_FAILOVER_TIMES) continue;
                    throw ivke;
                }
            }
            return spec;
        }
        return null;
    }

    private static class ParametersHolder {
        private static final boolean debugIsOn = Debug.getInstance("ssl") != null && Debug.isOn("sslctx");
        private static final BigInteger g2 = BigInteger.valueOf(2L);
        private static final BigInteger p512 = new BigInteger("D87780E15FF50B4ABBE89870188B049406B5BEA98AB23A0241D88EA75B7755E669C08093D3F0CA7FC3A5A25CF067DCB9A43DD89D1D90921C6328884461E0B6D3", 16);
        private static final BigInteger p768 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A63A3620FFFFFFFFFFFFFFFF", 16);
        private static final BigInteger p1024 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF", 16);
        private static final BigInteger p2048 = new BigInteger("FFFFFFFFFFFFFFFFADF85458A2BB4A9AAFDC5620273D3CF1D8B9C583CE2D3695A9E13641146433FBCC939DCE249B3EF97D2FE363630C75D8F681B202AEC4617AD3DF1ED5D5FD65612433F51F5F066ED0856365553DED1AF3B557135E7F57C935984F0C70E0E68B77E2A689DAF3EFE8721DF158A136ADE73530ACCA4F483A797ABC0AB182B324FB61D108A94BB2C8E3FBB96ADAB760D7F4681D4F42A3DE394DF4AE56EDE76372BB190B07A7C8EE0A6D709E02FCE1CDF7E2ECC03404CD28342F619172FE9CE98583FF8E4F1232EEF28183C3FE3B1B4C6FAD733BB5FCBC2EC22005C58EF1837D1683B2C6F34A26C1B2EFFA886B423861285C97FFFFFFFFFFFFFFFF", 16);
        private static final BigInteger[] supportedPrimes = new BigInteger[]{p512, p768, p1024, p2048};
        private static final int PRIME_CERTAINTY = 120;
        private static final String PROPERTY_NAME = "jdk.tls.server.defaultDHEParameters";
        private static final Pattern spacesPattern = Pattern.compile("\\s+");
        private static final Pattern syntaxPattern = Pattern.compile("(\\{[0-9A-Fa-f]+,[0-9A-Fa-f]+\\})(,\\{[0-9A-Fa-f]+,[0-9A-Fa-f]+\\})*");
        private static final Pattern paramsPattern = Pattern.compile("\\{([0-9A-Fa-f]+),([0-9A-Fa-f]+)\\}");
        private static final Map<Integer, DHParameterSpec> definedParams;

        private ParametersHolder() {
        }

        static {
            String property = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Security.getProperty(ParametersHolder.PROPERTY_NAME);
                }
            });
            if (property != null && !property.isEmpty()) {
                if (property.length() >= 2 && property.charAt(0) == '\"' && property.charAt(property.length() - 1) == '\"') {
                    property = property.substring(1, property.length() - 1);
                }
                property = property.trim();
            }
            if (property != null && !property.isEmpty()) {
                Matcher spacesMatcher = spacesPattern.matcher(property);
                property = spacesMatcher.replaceAll("");
                if (debugIsOn) {
                    System.out.println("The Security Property jdk.tls.server.defaultDHEParameters: " + property);
                }
            }
            HashMap<Integer, DHParameterSpec> defaultParams = new HashMap<Integer, DHParameterSpec>();
            if (property != null && !property.isEmpty()) {
                Matcher syntaxMatcher = syntaxPattern.matcher(property);
                if (syntaxMatcher.matches()) {
                    Matcher paramsFinder = paramsPattern.matcher(property);
                    while (paramsFinder.find()) {
                        String primeModulus = paramsFinder.group(1);
                        BigInteger p = new BigInteger(primeModulus, 16);
                        if (!p.isProbablePrime(120)) {
                            if (!debugIsOn) continue;
                            System.out.println("Prime modulus p in Security Property, jdk.tls.server.defaultDHEParameters, is not a prime: " + primeModulus);
                            continue;
                        }
                        String baseGenerator = paramsFinder.group(2);
                        BigInteger g = new BigInteger(baseGenerator, 16);
                        DHParameterSpec spec = new DHParameterSpec(p, g);
                        int primeLen = p.bitLength();
                        defaultParams.put(primeLen, spec);
                    }
                } else if (debugIsOn) {
                    System.out.println("Invalid Security Property, jdk.tls.server.defaultDHEParameters, definition");
                }
            }
            for (BigInteger p : supportedPrimes) {
                int primeLen = p.bitLength();
                DHParameterSpec value = (DHParameterSpec)defaultParams.get(primeLen);
                if (value != null) continue;
                defaultParams.put(primeLen, new DHParameterSpec(p, g2));
            }
            definedParams = Collections.unmodifiableMap(defaultParams);
        }
    }
}

