/*
 * Decompiled with CFR 0.152.
 */
package sun.util.logging;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.util.logging.LoggingSupport;

public class PlatformLogger {
    private static final int OFF = Integer.MAX_VALUE;
    private static final int SEVERE = 1000;
    private static final int WARNING = 900;
    private static final int INFO = 800;
    private static final int CONFIG = 700;
    private static final int FINE = 500;
    private static final int FINER = 400;
    private static final int FINEST = 300;
    private static final int ALL = Integer.MIN_VALUE;
    private static final Level DEFAULT_LEVEL = Level.INFO;
    private static boolean loggingEnabled = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            String string = System.getProperty("java.util.logging.config.class");
            String string2 = System.getProperty("java.util.logging.config.file");
            return string != null || string2 != null;
        }
    });
    private static Map<String, WeakReference<PlatformLogger>> loggers;
    private volatile LoggerProxy loggerProxy;
    private volatile JavaLoggerProxy javaLoggerProxy;

    public static synchronized PlatformLogger getLogger(String string) {
        PlatformLogger platformLogger = null;
        WeakReference<PlatformLogger> weakReference = loggers.get(string);
        if (weakReference != null) {
            platformLogger = (PlatformLogger)weakReference.get();
        }
        if (platformLogger == null) {
            platformLogger = new PlatformLogger(string);
            loggers.put(string, new WeakReference<PlatformLogger>(platformLogger));
        }
        return platformLogger;
    }

    public static synchronized void redirectPlatformLoggers() {
        if (loggingEnabled || !LoggingSupport.isAvailable()) {
            return;
        }
        loggingEnabled = true;
        for (Map.Entry<String, WeakReference<PlatformLogger>> entry : loggers.entrySet()) {
            WeakReference<PlatformLogger> weakReference = entry.getValue();
            PlatformLogger platformLogger = (PlatformLogger)weakReference.get();
            if (platformLogger == null) continue;
            platformLogger.redirectToJavaLoggerProxy();
        }
    }

    private void redirectToJavaLoggerProxy() {
        JavaLoggerProxy javaLoggerProxy;
        DefaultLoggerProxy defaultLoggerProxy = (DefaultLoggerProxy)DefaultLoggerProxy.class.cast(this.loggerProxy);
        this.javaLoggerProxy = javaLoggerProxy = new JavaLoggerProxy(defaultLoggerProxy.name, defaultLoggerProxy.level);
        this.loggerProxy = javaLoggerProxy;
    }

    private PlatformLogger(String string) {
        if (loggingEnabled) {
            this.javaLoggerProxy = new JavaLoggerProxy(string);
            this.loggerProxy = this.javaLoggerProxy;
        } else {
            this.loggerProxy = new DefaultLoggerProxy(string);
        }
    }

    public boolean isEnabled() {
        return this.loggerProxy.isEnabled();
    }

    public String getName() {
        return this.loggerProxy.name;
    }

    public boolean isLoggable(Level level) {
        if (level == null) {
            throw new NullPointerException();
        }
        JavaLoggerProxy javaLoggerProxy = this.javaLoggerProxy;
        return javaLoggerProxy != null ? javaLoggerProxy.isLoggable(level) : this.loggerProxy.isLoggable(level);
    }

    public Level level() {
        return this.loggerProxy.getLevel();
    }

    public void setLevel(Level level) {
        this.loggerProxy.setLevel(level);
    }

    public void severe(String string) {
        this.loggerProxy.doLog(Level.SEVERE, string);
    }

    public void severe(String string, Throwable throwable) {
        this.loggerProxy.doLog(Level.SEVERE, string, throwable);
    }

    public void severe(String string, Object ... objectArray) {
        this.loggerProxy.doLog(Level.SEVERE, string, objectArray);
    }

    public void warning(String string) {
        this.loggerProxy.doLog(Level.WARNING, string);
    }

    public void warning(String string, Throwable throwable) {
        this.loggerProxy.doLog(Level.WARNING, string, throwable);
    }

    public void warning(String string, Object ... objectArray) {
        this.loggerProxy.doLog(Level.WARNING, string, objectArray);
    }

    public void info(String string) {
        this.loggerProxy.doLog(Level.INFO, string);
    }

    public void info(String string, Throwable throwable) {
        this.loggerProxy.doLog(Level.INFO, string, throwable);
    }

    public void info(String string, Object ... objectArray) {
        this.loggerProxy.doLog(Level.INFO, string, objectArray);
    }

    public void config(String string) {
        this.loggerProxy.doLog(Level.CONFIG, string);
    }

    public void config(String string, Throwable throwable) {
        this.loggerProxy.doLog(Level.CONFIG, string, throwable);
    }

    public void config(String string, Object ... objectArray) {
        this.loggerProxy.doLog(Level.CONFIG, string, objectArray);
    }

    public void fine(String string) {
        this.loggerProxy.doLog(Level.FINE, string);
    }

    public void fine(String string, Throwable throwable) {
        this.loggerProxy.doLog(Level.FINE, string, throwable);
    }

    public void fine(String string, Object ... objectArray) {
        this.loggerProxy.doLog(Level.FINE, string, objectArray);
    }

    public void finer(String string) {
        this.loggerProxy.doLog(Level.FINER, string);
    }

    public void finer(String string, Throwable throwable) {
        this.loggerProxy.doLog(Level.FINER, string, throwable);
    }

    public void finer(String string, Object ... objectArray) {
        this.loggerProxy.doLog(Level.FINER, string, objectArray);
    }

    public void finest(String string) {
        this.loggerProxy.doLog(Level.FINEST, string);
    }

    public void finest(String string, Throwable throwable) {
        this.loggerProxy.doLog(Level.FINEST, string, throwable);
    }

    public void finest(String string, Object ... objectArray) {
        this.loggerProxy.doLog(Level.FINEST, string, objectArray);
    }

    static {
        try {
            Class.forName("sun.util.logging.PlatformLogger$DefaultLoggerProxy", false, PlatformLogger.class.getClassLoader());
            Class.forName("sun.util.logging.PlatformLogger$JavaLoggerProxy", false, PlatformLogger.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalError(classNotFoundException);
        }
        loggers = new HashMap<String, WeakReference<PlatformLogger>>();
    }

    private static final class JavaLoggerProxy
    extends LoggerProxy {
        private final Object javaLogger;

        JavaLoggerProxy(String string) {
            this(string, null);
        }

        JavaLoggerProxy(String string, Level level) {
            super(string);
            this.javaLogger = LoggingSupport.getLogger(string);
            if (level != null) {
                LoggingSupport.setLevel(this.javaLogger, level.javaLevel);
            }
        }

        @Override
        void doLog(Level level, String string) {
            LoggingSupport.log(this.javaLogger, level.javaLevel, string);
        }

        @Override
        void doLog(Level level, String string, Throwable throwable) {
            LoggingSupport.log(this.javaLogger, level.javaLevel, string, throwable);
        }

        @Override
        void doLog(Level level, String string, Object ... objectArray) {
            if (!this.isLoggable(level)) {
                return;
            }
            int n = objectArray != null ? objectArray.length : 0;
            Object[] objectArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = String.valueOf(objectArray[i]);
            }
            LoggingSupport.log(this.javaLogger, level.javaLevel, string, objectArray2);
        }

        @Override
        boolean isEnabled() {
            return LoggingSupport.isLoggable(this.javaLogger, Level.OFF.javaLevel);
        }

        @Override
        Level getLevel() {
            Object object = LoggingSupport.getLevel(this.javaLogger);
            if (object == null) {
                return null;
            }
            try {
                return Level.valueOf(LoggingSupport.getLevelName(object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Level.valueOf(LoggingSupport.getLevelValue(object));
            }
        }

        @Override
        void setLevel(Level level) {
            LoggingSupport.setLevel(this.javaLogger, level == null ? null : level.javaLevel);
        }

        @Override
        boolean isLoggable(Level level) {
            return LoggingSupport.isLoggable(this.javaLogger, level.javaLevel);
        }

        static {
            for (Level level : Level.values()) {
                level.javaLevel = LoggingSupport.parseLevel(level.name());
            }
        }
    }

    private static final class DefaultLoggerProxy
    extends LoggerProxy {
        volatile Level effectiveLevel;
        volatile Level level = null;
        private static final String formatString = LoggingSupport.getSimpleFormat(false);
        private Date date = new Date();

        private static PrintStream outputStream() {
            return System.err;
        }

        DefaultLoggerProxy(String string) {
            super(string);
            this.effectiveLevel = this.deriveEffectiveLevel(null);
        }

        @Override
        boolean isEnabled() {
            return this.effectiveLevel != Level.OFF;
        }

        @Override
        Level getLevel() {
            return this.level;
        }

        @Override
        void setLevel(Level level) {
            Level level2 = this.level;
            if (level2 != level) {
                this.level = level;
                this.effectiveLevel = this.deriveEffectiveLevel(level);
            }
        }

        @Override
        void doLog(Level level, String string) {
            if (this.isLoggable(level)) {
                DefaultLoggerProxy.outputStream().print(this.format(level, string, null));
            }
        }

        @Override
        void doLog(Level level, String string, Throwable throwable) {
            if (this.isLoggable(level)) {
                DefaultLoggerProxy.outputStream().print(this.format(level, string, throwable));
            }
        }

        @Override
        void doLog(Level level, String string, Object ... objectArray) {
            if (this.isLoggable(level)) {
                String string2 = this.formatMessage(string, objectArray);
                DefaultLoggerProxy.outputStream().print(this.format(level, string2, null));
            }
        }

        @Override
        boolean isLoggable(Level level) {
            Level level2 = this.effectiveLevel;
            return level.intValue() >= level2.intValue() && level2 != Level.OFF;
        }

        private Level deriveEffectiveLevel(Level level) {
            return level == null ? DEFAULT_LEVEL : level;
        }

        private String formatMessage(String string, Object ... objectArray) {
            try {
                if (objectArray == null || objectArray.length == 0) {
                    return string;
                }
                if (string.indexOf("{0") >= 0 || string.indexOf("{1") >= 0 || string.indexOf("{2") >= 0 || string.indexOf("{3") >= 0) {
                    return MessageFormat.format(string, objectArray);
                }
                return string;
            }
            catch (Exception exception) {
                return string;
            }
        }

        private synchronized String format(Level level, String string, Throwable throwable) {
            this.date.setTime(System.currentTimeMillis());
            String string2 = "";
            if (throwable != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.println();
                throwable.printStackTrace(printWriter);
                printWriter.close();
                string2 = stringWriter.toString();
            }
            return String.format(formatString, this.date, this.getCallerInfo(), this.name, level.name(), string, string2);
        }

        private String getCallerInfo() {
            String string = null;
            String string2 = null;
            JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
            Throwable throwable = new Throwable();
            int n = javaLangAccess.getStackTraceDepth(throwable);
            String string3 = "sun.util.logging.PlatformLogger";
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                StackTraceElement stackTraceElement = javaLangAccess.getStackTraceElement(throwable, i);
                String string4 = stackTraceElement.getClassName();
                if (bl) {
                    if (!string4.equals(string3)) continue;
                    bl = false;
                    continue;
                }
                if (string4.equals(string3)) continue;
                string = string4;
                string2 = stackTraceElement.getMethodName();
                break;
            }
            if (string != null) {
                return string + " " + string2;
            }
            return this.name;
        }
    }

    private static abstract class LoggerProxy {
        final String name;

        protected LoggerProxy(String string) {
            this.name = string;
        }

        abstract boolean isEnabled();

        abstract Level getLevel();

        abstract void setLevel(Level var1);

        abstract void doLog(Level var1, String var2);

        abstract void doLog(Level var1, String var2, Throwable var3);

        abstract void doLog(Level var1, String var2, Object ... var3);

        abstract boolean isLoggable(Level var1);
    }

    public static enum Level {
        ALL,
        FINEST,
        FINER,
        FINE,
        CONFIG,
        INFO,
        WARNING,
        SEVERE,
        OFF;

        Object javaLevel;
        private static final int[] LEVEL_VALUES;

        public int intValue() {
            return LEVEL_VALUES[this.ordinal()];
        }

        static Level valueOf(int n) {
            switch (n) {
                case 300: {
                    return FINEST;
                }
                case 500: {
                    return FINE;
                }
                case 400: {
                    return FINER;
                }
                case 800: {
                    return INFO;
                }
                case 900: {
                    return WARNING;
                }
                case 700: {
                    return CONFIG;
                }
                case 1000: {
                    return SEVERE;
                }
                case 0x7FFFFFFF: {
                    return OFF;
                }
                case -2147483648: {
                    return ALL;
                }
            }
            int n2 = Arrays.binarySearch(LEVEL_VALUES, 0, LEVEL_VALUES.length - 2, n);
            return Level.values()[n2 >= 0 ? n2 : -n2 - 1];
        }

        static {
            LEVEL_VALUES = new int[]{Integer.MIN_VALUE, 300, 400, 500, 700, 800, 900, 1000, Integer.MAX_VALUE};
        }
    }
}

