/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import java.util.Stack;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.process.IterateStructuralProcessStep;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class ParagraphLineBreakStep
extends IterateStructuralProcessStep {
    private FastStack paragraphNesting = new FastStack();
    private ParagraphLineBreakState breakState;

    public void compute(LogicalPageBox logicalPageBox) {
        this.startProcessing(logicalPageBox);
    }

    protected boolean startBlockBox(BlockRenderBox blockRenderBox) {
        if (blockRenderBox instanceof ParagraphRenderBox) {
            Object object;
            boolean bl;
            ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)blockRenderBox;
            boolean bl2 = bl = paragraphRenderBox.getPool().getChangeTracker() == paragraphRenderBox.getLineBoxAge();
            if (bl) {
                ParagraphRenderBox paragraphRenderBox2 = (ParagraphRenderBox)blockRenderBox.derive(true);
                this.breakState.getInsertationPoint().addGeneratedChild(paragraphRenderBox2);
                ParagraphLineBreakState paragraphLineBreakState = new ParagraphLineBreakState(paragraphRenderBox2, true);
                this.paragraphNesting.push((Object)paragraphLineBreakState);
                this.breakState = paragraphLineBreakState;
                return false;
            }
            if (this.breakState != null) {
                if (!this.breakState.isDirty()) {
                    throw new IllegalStateException("A child cannot be dirty, if the parent is clean");
                }
                object = (RenderBox)blockRenderBox.deriveFrozen(false);
                this.breakState.getInsertationPoint().addGeneratedChild((RenderNode)object);
                paragraphRenderBox = (ParagraphRenderBox)object;
            }
            object = new ParagraphLineBreakState(paragraphRenderBox, false);
            this.paragraphNesting.push(object);
            this.breakState = object;
        } else if (this.breakState != null && this.breakState.isDirty()) {
            RenderBox renderBox = (RenderBox)blockRenderBox.deriveFrozen(false);
            this.breakState.getInsertationPoint().addGeneratedChild(renderBox);
            this.breakState.setInsertationPoint(renderBox);
            if (this.breakState.getSuspendItem() == null) {
                this.breakState.setSuspendItem(blockRenderBox.getInstanceId());
            }
        }
        return true;
    }

    protected void finishBlockBox(BlockRenderBox blockRenderBox) {
        if (blockRenderBox instanceof ParagraphRenderBox) {
            ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)blockRenderBox;
            paragraphRenderBox.setLineBoxAge(paragraphRenderBox.getPool().getChangeTracker());
            this.paragraphNesting.pop();
            this.breakState = this.paragraphNesting.isEmpty() ? null : (ParagraphLineBreakState)this.paragraphNesting.peek();
        } else if (this.breakState != null && this.breakState.isDirty()) {
            RenderBox renderBox = this.breakState.getInsertationPoint().getParent();
            this.breakState.setInsertationPoint(renderBox);
            Object object = this.breakState.getSuspendItem();
            if (blockRenderBox.getInstanceId() == object) {
                this.breakState.setSuspendItem(null);
            }
        }
    }

    protected boolean startInlineBox(InlineRenderBox inlineRenderBox) {
        if (this.breakState == null || !this.breakState.isDirty()) {
            return true;
        }
        RenderBox renderBox = (RenderBox)inlineRenderBox.deriveFrozen(false);
        this.breakState.getInsertationPoint().addGeneratedChild(renderBox);
        this.breakState.setInsertationPoint(renderBox);
        return true;
    }

    protected void finishInlineBox(InlineRenderBox inlineRenderBox) {
        if (this.breakState == null || !this.breakState.isDirty()) {
            return;
        }
        RenderBox renderBox = this.breakState.getInsertationPoint().getParent();
        this.breakState.setInsertationPoint(renderBox);
        if (this.breakState.isBreakRequested() && inlineRenderBox.getNext() != null) {
            this.performBreak();
        }
    }

    protected void startOtherNode(RenderNode renderNode) {
        if (this.breakState == null || !this.breakState.isDirty()) {
            return;
        }
        if (this.breakState.getSuspendItem() != null || !(renderNode instanceof RenderableText)) {
            RenderNode renderNode2 = renderNode.deriveFrozen(false);
            this.breakState.getInsertationPoint().addGeneratedChild(renderNode2);
            return;
        }
        RenderableText renderableText = (RenderableText)renderNode;
        RenderNode renderNode3 = renderableText.deriveFrozen(false);
        this.breakState.getInsertationPoint().addGeneratedChild(renderNode3);
        if (!renderableText.isForceLinebreak()) {
            return;
        }
        if (renderNode.getNext() == null) {
            boolean bl = true;
            for (RenderBox renderBox = renderNode.getParent(); renderBox != null && renderBox instanceof InlineRenderBox; renderBox = renderBox.getParent()) {
                if (renderBox.getNext() == null) continue;
                bl = false;
                break;
            }
            if (bl) {
                return;
            }
            this.breakState.setBreakRequested(true);
            return;
        }
        this.performBreak();
    }

    private void performBreak() {
        RenderBox renderBox;
        Stack<RenderBox> stack = new Stack<RenderBox>();
        BlockRenderBox blockRenderBox = this.breakState.getLines();
        for (RenderBox renderBox2 = this.breakState.getInsertationPoint(); renderBox2 != blockRenderBox; renderBox2 = renderBox2.getParent()) {
            if (!(renderBox2 instanceof InlineRenderBox)) {
                throw new IllegalStateException("Confused: I expect InlineBoxes ..");
            }
            renderBox = (InlineRenderBox)renderBox2;
            stack.push(renderBox.split(0));
        }
        this.breakState.setInsertationPoint(blockRenderBox);
        while (!stack.isEmpty()) {
            renderBox = (RenderBox)stack.pop();
            this.breakState.getInsertationPoint().addGeneratedChild(renderBox);
            this.breakState.setInsertationPoint(renderBox);
        }
        this.breakState.setBreakRequested(false);
    }

    protected boolean startOtherBox(RenderBox renderBox) {
        if (this.breakState == null) {
            return false;
        }
        if (!this.breakState.isDirty()) {
            return false;
        }
        if (this.breakState.getSuspendItem() == null) {
            this.breakState.setSuspendItem(renderBox.getInstanceId());
        }
        RenderBox renderBox2 = (RenderBox)renderBox.deriveFrozen(false);
        this.breakState.getInsertationPoint().addGeneratedChild(renderBox2);
        this.breakState.setInsertationPoint(renderBox2);
        return true;
    }

    protected void finishOtherBox(RenderBox renderBox) {
        if (this.breakState != null && this.breakState.isDirty()) {
            Object object = this.breakState.getSuspendItem();
            if (renderBox.getInstanceId() == object) {
                this.breakState.setSuspendItem(null);
            }
            RenderBox renderBox2 = this.breakState.getInsertationPoint().getParent();
            this.breakState.setInsertationPoint(renderBox2);
        }
    }

    private static class ParagraphLineBreakState {
        private Object suspendItem;
        private BlockRenderBox lines;
        private RenderBox insertationPoint;
        private boolean breakRequested;

        private ParagraphLineBreakState(ParagraphRenderBox paragraphRenderBox, boolean bl) {
            if (paragraphRenderBox == null) {
                throw new NullPointerException();
            }
            this.lines = paragraphRenderBox.getLineboxContainer();
            if (bl) {
                this.insertationPoint = null;
            } else {
                this.insertationPoint = (RenderBox)paragraphRenderBox.getPool().deriveFrozen(false);
                this.lines.clear();
                this.lines.addGeneratedChild(this.insertationPoint);
            }
        }

        public BlockRenderBox getLines() {
            return this.lines;
        }

        public Object getSuspendItem() {
            return this.suspendItem;
        }

        public void setSuspendItem(Object object) {
            this.suspendItem = object;
        }

        public RenderBox getInsertationPoint() {
            return this.insertationPoint;
        }

        public boolean isDirty() {
            return this.insertationPoint != null;
        }

        public void setInsertationPoint(RenderBox renderBox) {
            this.insertationPoint = renderBox;
        }

        public boolean isBreakRequested() {
            return this.breakRequested;
        }

        public void setBreakRequested(boolean bl) {
            this.breakRequested = bl;
        }
    }
}

