/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.elasticsearch.common.logging.PrefixLogger;
import org.elasticsearch.common.settings.Setting;

public final class ESLoggerFactory {
    public static final Setting<Level> LOG_DEFAULT_LEVEL_SETTING = new Setting<Level>("logger.level", Level.INFO.name(), Level::valueOf, Setting.Property.NodeScope);
    public static final Setting<Level> LOG_LEVEL_SETTING = Setting.prefixKeySetting("logger.", key -> new Setting<Level>((String)key, Level.INFO.name(), Level::valueOf, Setting.Property.Dynamic, Setting.Property.NodeScope));

    private ESLoggerFactory() {
    }

    public static Logger getLogger(String prefix, String name) {
        return ESLoggerFactory.getLogger(prefix, LogManager.getLogger((String)name));
    }

    public static Logger getLogger(String prefix, Class<?> clazz) {
        return ESLoggerFactory.getLogger(prefix, LogManager.getLogger(clazz));
    }

    public static Logger getLogger(String prefix, Logger logger) {
        return new PrefixLogger((ExtendedLogger)logger, logger.getName(), prefix);
    }

    public static Logger getLogger(Class<?> clazz) {
        return ESLoggerFactory.getLogger(null, clazz);
    }

    public static Logger getLogger(String name) {
        return ESLoggerFactory.getLogger(null, name);
    }

    public static Logger getRootLogger() {
        return LogManager.getRootLogger();
    }
}

