/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.openpgp.PGPException;

class PGPUtil {
    PGPUtil() {
    }

    static String getDigestName(int n) throws PGPException {
        switch (n) {
            case 2: {
                return "SHA1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA256";
            }
            case 9: {
                return "SHA384";
            }
            case 10: {
                return "SHA512";
            }
            case 11: {
                return "SHA224";
            }
            case 6: {
                return "TIGER";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + n);
    }

    static String getSignatureName(int n, int n2) throws PGPException {
        String string;
        switch (n) {
            case 1: 
            case 3: {
                string = "RSA";
                break;
            }
            case 17: {
                string = "DSA";
                break;
            }
            case 16: 
            case 20: {
                string = "ElGamal";
                break;
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + n);
            }
        }
        return PGPUtil.getDigestName(n2) + "with" + string;
    }

    static String getSymmetricCipherName(int n) {
        switch (n) {
            case 0: {
                return null;
            }
            case 2: {
                return "DESEDE";
            }
            case 1: {
                return "IDEA";
            }
            case 3: {
                return "CAST5";
            }
            case 4: {
                return "Blowfish";
            }
            case 5: {
                return "SAFER";
            }
            case 6: {
                return "DES";
            }
            case 7: {
                return "AES";
            }
            case 8: {
                return "AES";
            }
            case 9: {
                return "AES";
            }
            case 11: {
                return "Camellia";
            }
            case 12: {
                return "Camellia";
            }
            case 13: {
                return "Camellia";
            }
            case 10: {
                return "Twofish";
            }
        }
        throw new IllegalArgumentException("unknown symmetric algorithm: " + n);
    }

    public static SecretKey makeSymmetricKey(int n, byte[] byArray) throws PGPException {
        String string = PGPUtil.getSymmetricCipherName(n);
        if (string == null) {
            throw new PGPException("unknown symmetric algorithm: " + n);
        }
        return new SecretKeySpec(byArray, string);
    }
}

