/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.TreeSet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.text.TreeFormatter;

public class IncompatibleConfigurationSelectionException
extends IllegalArgumentException {
    public IncompatibleConfigurationSelectionException(AttributeContainer fromConfigurationAttributes, AttributesSchema consumerSchema, ComponentResolveMetadata targetComponent, String targetConfiguration) {
        super(IncompatibleConfigurationSelectionException.generateMessage(fromConfigurationAttributes, consumerSchema, targetComponent, targetConfiguration));
    }

    private static String generateMessage(AttributeContainer fromConfigurationAttributes, AttributesSchema consumerSchema, ComponentResolveMetadata targetComponent, String targetConfiguration) {
        TreeSet requestedAttributes = Sets.newTreeSet((Iterable)Iterables.transform((Iterable)fromConfigurationAttributes.keySet(), AmbiguousConfigurationSelectionException.ATTRIBUTE_NAME));
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Configuration '" + targetConfiguration + "' in " + targetComponent.getComponentId().getDisplayName() + " does not match the consumer attributes");
        AmbiguousConfigurationSelectionException.formatConfiguration(formatter, fromConfigurationAttributes, consumerSchema, Collections.singletonList(targetComponent.getConfiguration(targetConfiguration)), requestedAttributes, targetConfiguration);
        return formatter.toString();
    }
}

