#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: esqueleto
version: 2.5.2
id: esqueleto-2.5.2-Ie94aOPgU0H3dIb6K9LhcV
key: esqueleto-2.5.2-Ie94aOPgU0H3dIb6K9LhcV
license: BSD3
copyright: (c) 2012-2016 Felipe Almeida Lessa
maintainer: cma@bitemyapp.com
homepage: https://github.com/bitemyapp/esqueleto
synopsis: Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries
    that works with unmodified @persistent@ SQL backends.  Its
    language closely resembles SQL, so you don'\''t have to learn
    new concepts, just new syntax, and it'\''s fairly easy to
    predict the generated SQL and optimize it for your backend.
    Most kinds of errors committed when writing SQL are caught as
    compile-time errors---although it is possible to write
    type-checked @esqueleto@ queries that fail at runtime.
    .
    @persistent@ is a library for type-safe data serialization.  It
    has many kinds of backends, such as SQL backends
    (@persistent-mysql@, @persistent-postgresql@,
    @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@).
    While @persistent@ is a nice library for storing and retrieving
    records, including with filters, it does not try to support
    some of the features that are specific to SQL backends.  In
    particular, @esqueleto@ is the recommended library for
    type-safe @JOIN@s on @persistent@ SQL backends.  (The
    alternative is using raw SQL, but that'\''s error prone and does
    not offer any composability.)
    .
    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported.
    Not all SQL features are available, but most of them can be easily added
    (especially functions), so please open an issue or send a pull request if
    you need anything that is not covered by @esqueleto@ on
    <https://github.com/bitemyapp/esqueleto>.
    .
    The name of this library means \"skeleton\" in Portuguese and
    contains all three SQL letters in the correct order =).  It was
    inspired by Scala'\''s Squeryl but created from scratch.
category: Database
author: Felipe Lessa
exposed: True
exposed-modules:
    Database.Esqueleto Database.Esqueleto.PostgreSQL
    Database.Esqueleto.Internal.Language
    Database.Esqueleto.Internal.Sql
hidden-modules: Database.Esqueleto.Internal.PersistentImport
abi: 13a6aad5839d825bd27467b4c268f1c2
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/esqueleto-2.5.2
library-dirs: /usr/lib/ghc-8.0.1/site-local/esqueleto-2.5.2
data-dir: /usr/share/arm-linux-ghc-8.0.1/esqueleto-2.5.2
hs-libraries: HSesqueleto-2.5.2-Ie94aOPgU0H3dIb6K9LhcV
depends:
    base-4.9.0.0 blaze-html-0.8.1.3-5umpHbJSFbGGX5TQ5mnIPt
    bytestring-0.10.8.1 conduit-1.2.10-HIC8vE5Ia4HDIPETJJNHDv
    monad-logger-0.3.24-7gRQSYJ9o62K37akkpEQgF
    persistent-2.6.1-Bms8UcNe7SU94p1UOqGWGn
    resourcet-1.1.9-4wjmwiYhI4Y4ny0clYPjM8
    tagged-0.8.5-I7Gu0uzBLkQJCVUvdvwKKq
    text-1.2.2.2-9rr3K4o0GAG9P33dGDnV9v transformers-0.5.2.0
    unordered-containers-0.2.8.0-Njz6QHP7Gk5G9PhT6D28J
haddock-interfaces: /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html: /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
