#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: free
version: 4.12.4
id: free-4.12.4-DgwCflt2BkkHDPCZmuZfk0
key: free-4.12.4-DgwCflt2BkkHDPCZmuZfk0
license: BSD3
copyright: Copyright (C) 2008-2015 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/free/
synopsis: Monads for free
description:
    Free monads are useful for many tree-like structures and domain specific languages.
    .
    If @f@ is a '\''Functor'\'' then the free '\''Monad'\'' on @f@ is the type
    of trees whose nodes are labeled with the constructors of @f@. The word
    \"free\" is used in the sense of \"unrestricted\" rather than \"zero-cost\":
    @Free f@ makes no constraining assumptions beyond those given by @f@ and the
    definition of '\''Monad'\''. As used here it is a standard term from the
    mathematical theory of adjoint functors.
    .
    Cofree comonads are dual to free monads. They provide convenient ways to talk
    about branching streams and rose-trees, and can be used to annotate syntax
    trees. The cofree comonad can be seen as a stream parameterized by a '\''Functor'\''
    that controls its branching factor.
    .
    More information on free monads, including examples, can be found in the
    following blog posts:
    <http://comonad.com/reader/2008/monads-for-free/>
    <http://comonad.com/reader/2011/free-monads-for-less/>
category: Control, Monads
author: Edward A. Kmett
exposed: True
exposed-modules:
    Control.Applicative.Free Control.Applicative.Free.Final
    Control.Applicative.Trans.Free Control.Alternative.Free
    Control.Alternative.Free.Final Control.Comonad.Cofree
    Control.Comonad.Cofree.Class Control.Comonad.Trans.Cofree
    Control.Comonad.Trans.Coiter Control.Monad.Free
    Control.Monad.Free.Church Control.Monad.Free.Class
    Control.Monad.Free.TH Control.Monad.Trans.Free
    Control.Monad.Trans.Free.Church Control.Monad.Trans.Iter
abi: 9e577a09e043c0ad894f8192f77bce8f
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/free-4.12.4
library-dirs: /usr/lib/ghc-8.0.1/site-local/free-4.12.4
data-dir: /usr/share/arm-linux-ghc-8.0.1/free-4.12.4
hs-libraries: HSfree-4.12.4-DgwCflt2BkkHDPCZmuZfk0
depends:
    base-4.9.0.0 bifunctors-5.4.2-89Yr6mDv1GYKyj9AXEUlAj
    comonad-5.0.1-EAitB0Um1u97dvApDogomX containers-0.5.7.1
    distributive-0.5.2-4LsZjgK7w7a5vNYTgeYpWm
    exceptions-0.8.3-5cAKIsqc1DD7jaNW3zLxAN
    mtl-2.2.1-6qsR1PHUy5lL47Hpoa4jCM
    prelude-extras-0.4.0.3-FAyB4iuuM7cHXdrLMZtdXq
    profunctors-5.2-BK9PDuHw2BPIuZitSy103t
    semigroupoids-5.2-4ZQ3kF1yWRr609NjdCdW7C
    semigroups-0.18.3-8OeihxGDuPl3I5Jsa4Tvoj template-haskell-2.11.0.0
    transformers-0.5.2.0
    transformers-compat-0.5.1.4-81lZyuOJOvsD0zyCv2TKld
haddock-interfaces: /usr/share/doc/haskell-free/html/free.haddock
haddock-html: /usr/share/doc/haskell-free/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
