/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.pqc.jcajce.provider.mceliece;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.python.bouncycastle.asn1.ASN1Integer;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.ASN1OctetString;
import org.python.bouncycastle.asn1.ASN1Primitive;
import org.python.bouncycastle.asn1.ASN1Sequence;
import org.python.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.python.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.python.bouncycastle.pqc.asn1.McEliecePrivateKey;
import org.python.bouncycastle.pqc.asn1.McEliecePublicKey;
import org.python.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePrivateKey;
import org.python.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePublicKey;
import org.python.bouncycastle.pqc.jcajce.spec.McEliecePrivateKeySpec;
import org.python.bouncycastle.pqc.jcajce.spec.McEliecePublicKeySpec;

public class McElieceKeyFactorySpi
extends KeyFactorySpi {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.1";

    public PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof McEliecePublicKeySpec) {
            return new BCMcEliecePublicKey((McEliecePublicKeySpec)keySpec);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            SubjectPublicKeyInfo subjectPublicKeyInfo;
            byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
            try {
                subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException(iOException.toString());
            }
            try {
                ASN1Primitive aSN1Primitive = subjectPublicKeyInfo.parsePublicKey();
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
                String string = ((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)).toString();
                BigInteger bigInteger = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue();
                int n = bigInteger.intValue();
                BigInteger bigInteger2 = ((ASN1Integer)aSN1Sequence.getObjectAt(2)).getValue();
                int n2 = bigInteger2.intValue();
                byte[] byArray2 = ((ASN1OctetString)aSN1Sequence.getObjectAt(3)).getOctets();
                return new BCMcEliecePublicKey(new McEliecePublicKeySpec(OID, n2, n, byArray2));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Unable to decode X509EncodedKeySpec: " + iOException.getMessage());
            }
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + keySpec.getClass() + ".");
    }

    public PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof McEliecePrivateKeySpec) {
            return new BCMcEliecePrivateKey((McEliecePrivateKeySpec)keySpec);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            PrivateKeyInfo privateKeyInfo;
            byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            try {
                privateKeyInfo = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec: " + iOException);
            }
            try {
                ASN1Primitive aSN1Primitive = privateKeyInfo.parsePrivateKey().toASN1Primitive();
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
                String string = ((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)).toString();
                BigInteger bigInteger = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue();
                int n = bigInteger.intValue();
                BigInteger bigInteger2 = ((ASN1Integer)aSN1Sequence.getObjectAt(2)).getValue();
                int n2 = bigInteger2.intValue();
                byte[] byArray2 = ((ASN1OctetString)aSN1Sequence.getObjectAt(3)).getOctets();
                byte[] byArray3 = ((ASN1OctetString)aSN1Sequence.getObjectAt(4)).getOctets();
                byte[] byArray4 = ((ASN1OctetString)aSN1Sequence.getObjectAt(5)).getOctets();
                byte[] byArray5 = ((ASN1OctetString)aSN1Sequence.getObjectAt(6)).getOctets();
                byte[] byArray6 = ((ASN1OctetString)aSN1Sequence.getObjectAt(7)).getOctets();
                byte[] byArray7 = ((ASN1OctetString)aSN1Sequence.getObjectAt(8)).getOctets();
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(9);
                byte[][] byArrayArray = new byte[aSN1Sequence2.size()][];
                for (int i = 0; i < aSN1Sequence2.size(); ++i) {
                    byArrayArray[i] = ((ASN1OctetString)aSN1Sequence2.getObjectAt(i)).getOctets();
                }
                return new BCMcEliecePrivateKey(new McEliecePrivateKeySpec(OID, n, n2, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7, byArrayArray));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec.");
            }
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + keySpec.getClass() + ".");
    }

    public KeySpec getKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof BCMcEliecePrivateKey) {
            if (PKCS8EncodedKeySpec.class.isAssignableFrom(clazz)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
            if (McEliecePrivateKeySpec.class.isAssignableFrom(clazz)) {
                BCMcEliecePrivateKey bCMcEliecePrivateKey = (BCMcEliecePrivateKey)key;
                return new McEliecePrivateKeySpec(OID, bCMcEliecePrivateKey.getN(), bCMcEliecePrivateKey.getK(), bCMcEliecePrivateKey.getField(), bCMcEliecePrivateKey.getGoppaPoly(), bCMcEliecePrivateKey.getSInv(), bCMcEliecePrivateKey.getP1(), bCMcEliecePrivateKey.getP2(), bCMcEliecePrivateKey.getH(), bCMcEliecePrivateKey.getQInv());
            }
        } else if (key instanceof BCMcEliecePublicKey) {
            if (X509EncodedKeySpec.class.isAssignableFrom(clazz)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            if (McEliecePublicKeySpec.class.isAssignableFrom(clazz)) {
                BCMcEliecePublicKey bCMcEliecePublicKey = (BCMcEliecePublicKey)key;
                return new McEliecePublicKeySpec(OID, bCMcEliecePublicKey.getN(), bCMcEliecePublicKey.getT(), bCMcEliecePublicKey.getG());
            }
        } else {
            throw new InvalidKeySpecException("Unsupported key type: " + key.getClass() + ".");
        }
        throw new InvalidKeySpecException("Unknown key specification: " + clazz + ".");
    }

    public Key translateKey(Key key) throws InvalidKeyException {
        if (key instanceof BCMcEliecePrivateKey || key instanceof BCMcEliecePublicKey) {
            return key;
        }
        throw new InvalidKeyException("Unsupported key type.");
    }

    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws InvalidKeySpecException {
        try {
            ASN1Primitive aSN1Primitive = subjectPublicKeyInfo.parsePublicKey();
            McEliecePublicKey mcEliecePublicKey = McEliecePublicKey.getInstance(aSN1Primitive);
            return new BCMcEliecePublicKey(mcEliecePublicKey.getOID().getId(), mcEliecePublicKey.getN(), mcEliecePublicKey.getT(), mcEliecePublicKey.getG());
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException("Unable to decode X509EncodedKeySpec");
        }
    }

    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws InvalidKeySpecException {
        try {
            ASN1Primitive aSN1Primitive = privateKeyInfo.parsePrivateKey().toASN1Primitive();
            McEliecePrivateKey mcEliecePrivateKey = McEliecePrivateKey.getInstance(aSN1Primitive);
            return new BCMcEliecePrivateKey(mcEliecePrivateKey.getOID().getId(), mcEliecePrivateKey.getN(), mcEliecePrivateKey.getK(), mcEliecePrivateKey.getField(), mcEliecePrivateKey.getGoppaPoly(), mcEliecePrivateKey.getSInv(), mcEliecePrivateKey.getP1(), mcEliecePrivateKey.getP2(), mcEliecePrivateKey.getH(), mcEliecePrivateKey.getQInv());
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec");
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        return null;
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        return null;
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        return null;
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        return null;
    }
}

