/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.operation.IncrementTranslator;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

public final class IntrinsicIncrementTranslator
extends IncrementTranslator {
    @NotNull
    private final ResolvedCall<? extends FunctionDescriptor> resolvedCall;

    public IntrinsicIncrementTranslator(@NotNull KtUnaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "<init>"));
        }
        super(expression, context);
        this.resolvedCall = CallUtilKt.getFunctionResolvedCallWithAssert(expression, context.bindingContext());
    }

    @Override
    @NotNull
    protected JsExpression operationExpression(@NotNull JsExpression receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "operationExpression"));
        }
        FunctionIntrinsic intrinsic = this.context().intrinsics().getFunctionIntrinsic(this.resolvedCall.getResultingDescriptor());
        CallInfo callInfo = CallInfoKt.getCallInfo(this.context(), this.resolvedCall, receiver);
        JsExpression jsExpression = intrinsic.apply(callInfo, Collections.emptyList(), this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/IntrinsicIncrementTranslator", "operationExpression"));
        }
        return jsExpression;
    }
}

