/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Interner<T> {
    private final Interner<T> parent;
    private final int firstIndex;
    private final Map<T, Integer> interned = new HashMap<T, Integer>();

    public Interner(Interner<T> parent2) {
        this.parent = parent2;
        this.firstIndex = parent2 != null ? parent2.interned.size() + parent2.firstIndex : 0;
    }

    public Interner() {
        this(null);
    }

    @Nullable
    private Integer find(@NotNull T obj) {
        Integer index2;
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "org/jetbrains/kotlin/utils/Interner", "find"));
        }
        assert (this.parent == null || this.parent.interned.size() + this.parent.firstIndex == this.firstIndex) : "Parent changed in parallel with child: indexes will be wrong";
        if (this.parent != null && (index2 = super.find(obj)) != null) {
            return index2;
        }
        return this.interned.get(obj);
    }

    public int intern(@NotNull T obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "org/jetbrains/kotlin/utils/Interner", "intern"));
        }
        Integer index2 = this.find(obj);
        if (index2 != null) {
            return index2;
        }
        index2 = this.firstIndex + this.interned.size();
        this.interned.put(obj, index2);
        return index2;
    }

    @NotNull
    public List<T> getAllInternedObjects() {
        List<T> list2 = CollectionsKt.sortedBy(this.interned.keySet(), new Function1<T, Integer>(){

            @Override
            public Integer invoke(T key) {
                return (Integer)Interner.this.interned.get(key);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/Interner", "getAllInternedObjects"));
        }
        return list2;
    }

    public boolean isEmpty() {
        return this.interned.isEmpty() && (this.parent == null || this.parent.isEmpty());
    }
}

